/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.geomatics;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotoolkit.geometry.Envelopes;
import org.geotoolkit.geometry.GeneralEnvelope;
import org.opengis.cite.geomatics.GeodesyUtils;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class SpatialAssert {
    private static final Logger LOGR = Logger.getLogger(SpatialAssert.class.getPackage().getName());

    public static void assertIntersects(Envelope env1, Envelope env2) {
        CoordinateReferenceSystem crs1 = env1.getCoordinateReferenceSystem();
        Envelope env = env2;
        if (!env2.getCoordinateReferenceSystem().equals(crs1)) {
            try {
                env = Envelopes.transform((Envelope)env2, (CoordinateReferenceSystem)crs1);
            }
            catch (TransformException te) {
                StringBuilder msg = new StringBuilder("Coordinate transformation failed.");
                msg.append("\n crs1 is ").append(GeodesyUtils.getCRSIdentifier(crs1));
                msg.append("\n crs2 is ").append(GeodesyUtils.getCRSIdentifier(env2.getCoordinateReferenceSystem()));
                throw new AssertionError(msg.toString(), te);
            }
        }
        LOGR.log(Level.FINE, String.format("env1: %s with CRS %s", env1.toString(), GeodesyUtils.getCRSIdentifier(crs1)));
        LOGR.log(Level.FINE, String.format("env: %s with CRS %s", env.toString(), GeodesyUtils.getCRSIdentifier(env.getCoordinateReferenceSystem())));
        GeneralEnvelope genEnv1 = new GeneralEnvelope(env1);
        if (!genEnv1.intersects(env, false)) {
            StringBuilder msg = new StringBuilder("The envelopes do not intersect.\n");
            msg.append(env1.toString()).append(" with CRS ").append(GeodesyUtils.getCRSIdentifier(crs1));
            msg.append('\n').append(env2.toString()).append(" with CRS ").append(GeodesyUtils.getCRSIdentifier(env2.getCoordinateReferenceSystem()));
            throw new AssertionError((Object)msg.toString());
        }
    }
}

