/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotoolkit.util.collection.CloseableIterator;

public class SequenceIterator<F>
implements CloseableIterator<F> {
    private final Iterator<F>[] wrapped;
    private int currentIndex = 0;
    private Iterator<F> active = null;

    public SequenceIterator(Iterator<F> ... wrapped) {
        if (wrapped == null || wrapped.length == 0 || wrapped[0] == null) {
            throw new IllegalArgumentException("Iterators can not be empty or null");
        }
        this.wrapped = wrapped;
        this.active = wrapped[0];
    }

    @Override
    public F next() {
        if (this.active == null) {
            throw new NoSuchElementException("No more elements");
        }
        return this.active.next();
    }

    @Override
    public void close() {
        for (Iterator<F> ite : this.wrapped) {
            if (!(ite instanceof CloseableIterator)) continue;
            ((CloseableIterator)ite).close();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.active == null) {
            return false;
        }
        if (this.active.hasNext()) {
            return true;
        }
        if (this.active instanceof CloseableIterator) {
            ((CloseableIterator)this.active).close();
        }
        ++this.currentIndex;
        while (this.currentIndex < this.wrapped.length) {
            this.active = this.wrapped[this.currentIndex];
            if (this.active.hasNext()) {
                return true;
            }
            if (this.active instanceof CloseableIterator) {
                ((CloseableIterator)this.active).close();
            }
            ++this.currentIndex;
        }
        return false;
    }

    @Override
    public void remove() {
        if (this.active != null) {
            this.active.remove();
        }
    }
}

