/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.jaxb;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import org.geotoolkit.internal.Citations;
import org.geotoolkit.internal.jaxb.IdentifierMapAdapter;
import org.geotoolkit.internal.jaxb.IdentifierMapEntry;
import org.geotoolkit.internal.jaxb.NonMarshalledAuthority;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.logging.Logging;
import org.geotoolkit.xml.IdentifierMap;
import org.geotoolkit.xml.IdentifierSpace;
import org.geotoolkit.xml.XLink;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;

public final class SpecializedIdentifier<T>
implements Identifier,
Serializable {
    private static final long serialVersionUID = 1673231050676950993L;
    private final IdentifierSpace<T> authority;
    T value;

    public SpecializedIdentifier(IdentifierSpace<T> identifierSpace, T t) {
        this.authority = identifierSpace;
        this.value = t;
    }

    static Identifier parse(Citation citation, String string) {
        if (citation instanceof NonMarshalledAuthority) {
            switch (((NonMarshalledAuthority)citation).ordinal) {
                case 0: {
                    return new SpecializedIdentifier<String>(IdentifierSpace.ID, string);
                }
                case 1: {
                    try {
                        return new SpecializedIdentifier<UUID>(IdentifierSpace.UUID, UUID.fromString(string));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        SpecializedIdentifier.parseFailure(illegalArgumentException);
                        break;
                    }
                }
                case 2: {
                    URI uRI;
                    try {
                        uRI = new URI(string);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        SpecializedIdentifier.parseFailure(uRISyntaxException);
                        break;
                    }
                    return new SpecializedIdentifier<URI>(IdentifierSpace.HREF, uRI);
                }
                case 3: {
                    URI uRI;
                    try {
                        uRI = new URI(string);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        SpecializedIdentifier.parseFailure(uRISyntaxException);
                        break;
                    }
                    XLink xLink = new XLink();
                    xLink.setHRef(uRI);
                    return new SpecializedIdentifier<XLink>(IdentifierSpace.XLINK, xLink);
                }
            }
        }
        return new IdentifierMapEntry(citation, string);
    }

    private static void parseFailure(Exception exception) {
        Logging.recoverableException(IdentifierMap.class, "put", exception);
    }

    public void putInto(IdentifierMap identifierMap) {
        if (!(identifierMap instanceof IdentifierMapAdapter) || !((IdentifierMapAdapter)identifierMap).putSpecialized(this)) {
            identifierMap.putSpecialized(this.authority, this.value);
        }
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public Citation getAuthority() {
        return this.authority;
    }

    @Override
    public String getCode() {
        return this.value != null ? this.value.toString() : null;
    }

    public int hashCode() {
        return Utilities.hash(this.value, this.authority.hashCode());
    }

    public boolean equals(Object object) {
        if (object instanceof SpecializedIdentifier) {
            SpecializedIdentifier specializedIdentifier = (SpecializedIdentifier)object;
            return Utilities.equals(this.authority, specializedIdentifier.authority) && Utilities.equals(this.value, specializedIdentifier.value);
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Identifier[");
        SpecializedIdentifier.format(stringBuilder, this.authority, this.getCode());
        return stringBuilder.append(']').toString();
    }

    static void format(StringBuilder stringBuilder, Citation citation, String string) {
        boolean bl;
        stringBuilder.append(Citations.getIdentifier(citation)).append('=');
        boolean bl2 = bl = string != null && string.indexOf(91) < 0;
        if (bl) {
            stringBuilder.append('\u201c');
        }
        stringBuilder.append(string);
        if (bl) {
            stringBuilder.append('\u201d');
        }
    }
}

