/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.process;

import java.util.Locale;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.process.ProcessEvent;
import org.geotoolkit.process.ProcessListener;
import org.geotoolkit.util.Localized;
import org.geotoolkit.util.SimpleInternationalString;
import org.opengis.util.InternationalString;

@ThreadSafe
public abstract class ProgressController
implements Localized,
ProcessListener {
    private final Locale locale = Locale.getDefault();
    private volatile InternationalString task;
    private volatile float progress;
    private volatile boolean canceled;

    protected ProgressController() {
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public InternationalString getTask() {
        return this.task;
    }

    public void setTask(CharSequence charSequence) {
        if (charSequence != null && !(charSequence instanceof InternationalString)) {
            charSequence = new SimpleInternationalString(((Object)charSequence).toString());
        }
        this.task = (InternationalString)charSequence;
    }

    public abstract void started();

    @Override
    public void started(ProcessEvent processEvent) {
        this.started();
        this.progressing(processEvent);
    }

    public abstract void paused();

    @Override
    public void paused(ProcessEvent processEvent) {
        this.progressing(processEvent);
        this.paused();
    }

    public abstract void resumed();

    @Override
    public void resumed(ProcessEvent processEvent) {
        this.resumed();
        this.progressing(processEvent);
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 100.0f) {
            f = 100.0f;
        }
        this.progress = f;
    }

    @Override
    public void progressing(ProcessEvent processEvent) {
        if (processEvent != null) {
            Exception exception;
            float f;
            InternationalString internationalString = processEvent.getTask();
            if (internationalString != null) {
                this.setTask(internationalString);
            }
            if (!Float.isNaN(f = processEvent.getProgress())) {
                this.setProgress(f);
            }
            if ((exception = processEvent.getException()) != null) {
                this.exceptionOccurred(exception);
            }
        }
    }

    public abstract void completed();

    @Override
    public void completed(ProcessEvent processEvent) {
        this.progressing(processEvent);
        this.completed();
    }

    @Override
    public void failed(ProcessEvent processEvent) {
        this.progressing(processEvent);
    }

    public void cancel() {
        this.canceled = true;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public abstract void warningOccurred(String var1, String var2, String var3);

    public abstract void exceptionOccurred(Throwable var1);
}

