/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.geotoolkit.display.shape.ShapeUtilities;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.geometry.GeneralEnvelope;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.datum.DefaultEllipsoid;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class GeometricUtilities {
    private static final DefaultEllipsoid DE = DefaultEllipsoid.WGS84;

    private GeometricUtilities() {
    }

    public static double bboxToPointDistance(GeneralEnvelope boundingBox, GeneralDirectPosition point, String units) {
        if (boundingBox.contains(point)) {
            return 0.0;
        }
        List<Line2D> border = GeometricUtilities.getBorder(boundingBox);
        double distance = Double.MAX_VALUE;
        for (Line2D l : border) {
            double tempDistance = GeometricUtilities.lineToPointDistance(l, point, units);
            if (!(tempDistance < distance)) continue;
            distance = tempDistance;
        }
        return distance;
    }

    public static double lineToPointDistance(Line2D line, GeneralDirectPosition point, String units) {
        Point2D.Double pt = ShapeUtilities.nearestColinearPoint(line, new Point2D.Double(point.getOrdinate(0), point.getOrdinate(1)));
        return GeometricUtilities.getOrthodromicDistance(point.getOrdinate(0), point.getOrdinate(1), ((Point2D)pt).getX(), ((Point2D)pt).getY(), units);
    }

    public static double lineTolineDistance(Line2D line1, Line2D line2, String units) {
        double distance = Double.MAX_VALUE;
        if (line1.intersectsLine(line2)) {
            return 0.0;
        }
        Point2D.Double pt = ShapeUtilities.nearestColinearPoint(line2, line1.getP1());
        double tempDistance = GeometricUtilities.getOrthodromicDistance(((Point2D)pt).getX(), ((Point2D)pt).getY(), line1.getX1(), line1.getY1(), units);
        if (tempDistance < distance) {
            distance = tempDistance;
        }
        if ((tempDistance = GeometricUtilities.getOrthodromicDistance(((Point2D)(pt = ShapeUtilities.nearestColinearPoint(line2, line1.getP2()))).getX(), ((Point2D)pt).getY(), line1.getX2(), line1.getY2(), units)) < distance) {
            distance = tempDistance;
        }
        if ((tempDistance = GeometricUtilities.getOrthodromicDistance(((Point2D)(pt = ShapeUtilities.nearestColinearPoint(line1, line2.getP1()))).getX(), ((Point2D)pt).getY(), line2.getX1(), line2.getY1(), units)) < distance) {
            distance = tempDistance;
        }
        if ((tempDistance = GeometricUtilities.getOrthodromicDistance(((Point2D)(pt = ShapeUtilities.nearestColinearPoint(line1, line2.getP2()))).getX(), ((Point2D)pt).getY(), line2.getX2(), line2.getY2(), units)) < distance) {
            distance = tempDistance;
        }
        return distance;
    }

    public static double lineToBBoxDistance(Line2D line, GeneralEnvelope boundingBox, String units) {
        CoordinateReferenceSystem crs = boundingBox.getCoordinateReferenceSystem();
        GeneralDirectPosition tempPoint1 = new GeneralDirectPosition(line.getX1(), line.getY1());
        tempPoint1.setCoordinateReferenceSystem(crs);
        GeneralDirectPosition tempPoint2 = new GeneralDirectPosition(line.getX2(), line.getY2());
        tempPoint2.setCoordinateReferenceSystem(crs);
        if (boundingBox.contains(tempPoint1) || boundingBox.contains(tempPoint2)) {
            return 0.0;
        }
        List<Line2D> border = GeometricUtilities.getBorder(boundingBox);
        double distance = Double.MAX_VALUE;
        for (Line2D l : border) {
            if (l.intersectsLine(line)) {
                return 0.0;
            }
            double tempDistance = GeometricUtilities.lineTolineDistance(l, line, units);
            if (!(tempDistance < distance)) continue;
            distance = tempDistance;
        }
        return distance;
    }

    public static double bboxToBBoxDistance(GeneralEnvelope boundingBox1, GeneralEnvelope boundingBox2, String units) {
        if (boundingBox1.intersects(boundingBox2, false)) {
            return 0.0;
        }
        List<Line2D> border = GeometricUtilities.getBorder(boundingBox1);
        double distance = Double.MAX_VALUE;
        for (Line2D l : border) {
            double tempDistance = GeometricUtilities.lineToBBoxDistance(l, boundingBox2, units);
            if (!(tempDistance < distance)) continue;
            distance = tempDistance;
        }
        return distance;
    }

    public static double getOrthodromicDistance(double x1, double y1, double x2, double y2, String units) {
        double result = DE.orthodromicDistance(y1, x1, y2, x2);
        if (units.equals("meters") || units.equals("m")) {
            return result;
        }
        if (units.equals("kilometers") || units.equals("km")) {
            return result / 1000.0;
        }
        if (units.equals("centimeters") || units.equals("cm")) {
            return result * 100.0;
        }
        if (units.equals("milimeters") || units.equals("mm")) {
            return result * 1000.0;
        }
        if (units.equals("miles") || units.equals("mi")) {
            return result * 0.621371 / 1000.0;
        }
        throw new IllegalArgumentException("unknow distance units");
    }

    public static List<Line2D> getBorder(Object geometry) {
        ArrayList<Line2D> result = new ArrayList<Line2D>();
        if (geometry instanceof GeneralEnvelope) {
            GeneralEnvelope env = (GeneralEnvelope)geometry;
            Line2D.Double heightLeft = new Line2D.Double(env.getMinimum(0), env.getMaximum(1), env.getMinimum(0), env.getMinimum(1));
            result.add(heightLeft);
            Line2D.Double widthTop = new Line2D.Double(env.getMinimum(0), env.getMaximum(1), env.getMaximum(0), env.getMaximum(1));
            result.add(widthTop);
            Line2D.Double heightRight = new Line2D.Double(env.getMaximum(0), env.getMaximum(1), env.getMaximum(0), env.getMinimum(1));
            result.add(heightRight);
            Line2D.Double widthBottom = new Line2D.Double(env.getMinimum(0), env.getMinimum(1), env.getMaximum(0), env.getMinimum(1));
            result.add(widthBottom);
        }
        return result;
    }

    public static List<Point2D> getCorner(Object geometry) {
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        if (geometry instanceof GeneralEnvelope) {
            GeneralEnvelope env = (GeneralEnvelope)geometry;
            Point2D.Double upperLeft = new Point2D.Double(env.getMinimum(0), env.getMaximum(1));
            result.add(upperLeft);
            Point2D.Double upperRight = new Point2D.Double(env.getMaximum(0), env.getMaximum(1));
            result.add(upperRight);
            Point2D.Double bottomRight = new Point2D.Double(env.getMaximum(0), env.getMinimum(1));
            result.add(bottomRight);
            Point2D.Double bottomLeft = new Point2D.Double(env.getMinimum(0), env.getMinimum(1));
            result.add(bottomLeft);
        }
        return result;
    }

    public static boolean touches(GeneralEnvelope boundingBox, GeneralDirectPosition point) {
        if (point == null || boundingBox == null) {
            return false;
        }
        Line2D.Double pointLine = new Line2D.Double(point.getOrdinate(0), point.getOrdinate(1), point.getOrdinate(0), point.getOrdinate(1));
        List<Line2D> border = GeometricUtilities.getBorder(boundingBox);
        for (Line2D l : border) {
            if (!l.intersectsLine(pointLine)) continue;
            return true;
        }
        return false;
    }

    public static boolean touches(Line2D line1, Line2D line2) {
        if (line1 == null || line2 == null) {
            return false;
        }
        return line1.intersectsLine(new Line2D.Double(line2.getX1(), line2.getY1(), line2.getX1(), line2.getY1())) || line1.intersectsLine(new Line2D.Double(line2.getX2(), line2.getY2(), line2.getX2(), line2.getY2())) || line2.intersectsLine(new Line2D.Double(line1.getX1(), line1.getY1(), line1.getX1(), line1.getY1())) || line2.intersectsLine(new Line2D.Double(line1.getX2(), line1.getY2(), line1.getX2(), line1.getY2()));
    }

    public static boolean touches(GeneralEnvelope boundingBox, Line2D line) {
        if (line == null || boundingBox == null) {
            return false;
        }
        List<Line2D> border = GeometricUtilities.getBorder(boundingBox);
        for (Line2D l : border) {
            if (!l.intersectsLine(line.getX1(), line.getY1(), line.getX1(), line.getY1()) && !l.intersectsLine(line.getX2(), line.getY2(), line.getX2(), line.getY2())) continue;
            return true;
        }
        return false;
    }

    public static boolean touches(GeneralEnvelope boundingBox1, GeneralEnvelope boundingBox2) {
        if (boundingBox1 == null || boundingBox2 == null) {
            return false;
        }
        boolean touches = false;
        List<Line2D> bboxBorder1 = GeometricUtilities.getBorder(boundingBox1);
        for (Line2D l : bboxBorder1) {
            for (Point2D p : GeometricUtilities.getCorner(boundingBox2)) {
                if (!l.intersectsLine(p.getX(), p.getY(), p.getX(), p.getY())) continue;
                touches = true;
            }
        }
        List<Point2D> filterBoxCorner = GeometricUtilities.getCorner(boundingBox1);
        for (Line2D l : GeometricUtilities.getBorder(boundingBox2)) {
            for (Point2D p : filterBoxCorner) {
                if (!l.intersectsLine(p.getX(), p.getY(), p.getX(), p.getY())) continue;
                touches = true;
            }
        }
        return touches;
    }

    public static boolean disjoint(GeneralEnvelope boundingBox, Line2D line) {
        GeneralDirectPosition tempPoint1 = new GeneralDirectPosition(line.getX1(), line.getY1());
        GeneralDirectPosition tempPoint2 = new GeneralDirectPosition(line.getX2(), line.getY2());
        if (!boundingBox.contains(tempPoint1) && !boundingBox.contains(tempPoint2)) {
            List<Line2D> border = GeometricUtilities.getBorder(boundingBox);
            for (Line2D l : border) {
                if (!l.intersectsLine(line)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean intersect(GeneralEnvelope boundingBox, Line2D line) {
        GeneralDirectPosition tempPoint1 = new GeneralDirectPosition(line.getX1(), line.getY1());
        GeneralDirectPosition tempPoint2 = new GeneralDirectPosition(line.getX2(), line.getY2());
        if (boundingBox.contains(tempPoint1) || boundingBox.contains(tempPoint2)) {
            return true;
        }
        for (Line2D l : GeometricUtilities.getBorder(boundingBox)) {
            if (!l.intersectsLine(line)) continue;
            return true;
        }
        return false;
    }

    public static boolean crosses(GeneralEnvelope boundingBox, Line2D line) {
        CoordinateReferenceSystem crs = boundingBox.getCoordinateReferenceSystem();
        GeneralDirectPosition tempPoint1 = new GeneralDirectPosition(line.getX1(), line.getY1());
        tempPoint1.setCoordinateReferenceSystem(crs);
        GeneralDirectPosition tempPoint2 = new GeneralDirectPosition(line.getX2(), line.getY2());
        tempPoint2.setCoordinateReferenceSystem(crs);
        return boundingBox.contains(tempPoint1) && !boundingBox.contains(tempPoint2) || !boundingBox.contains(tempPoint1) && boundingBox.contains(tempPoint2);
    }

    public static boolean crosses(GeneralEnvelope boundingBox, GeneralDirectPosition point) {
        for (Line2D l : GeometricUtilities.getBorder(boundingBox)) {
            if (!l.intersectsLine(point.getOrdinate(0), point.getOrdinate(1), point.getOrdinate(0), point.getOrdinate(1))) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(GeneralEnvelope boundingBox, Line2D line) {
        CoordinateReferenceSystem crs = boundingBox.getCoordinateReferenceSystem();
        GeneralDirectPosition tempPoint1 = new GeneralDirectPosition(line.getX1(), line.getY1());
        tempPoint1.setCoordinateReferenceSystem(crs);
        GeneralDirectPosition tempPoint2 = new GeneralDirectPosition(line.getX2(), line.getY2());
        tempPoint2.setCoordinateReferenceSystem(crs);
        return boundingBox.contains(tempPoint1) && boundingBox.contains(tempPoint2);
    }

    public static boolean overlaps(GeneralEnvelope boundingBox1, GeneralEnvelope boundingBox2) {
        if (boundingBox1.contains(boundingBox2, true) || boundingBox2.contains(boundingBox1, true)) {
            return false;
        }
        return boundingBox1.intersects(boundingBox2, true);
    }

    public static boolean equalsLine(Line2D l1, Line2D l2) {
        if (l1 == null && l2 == null) {
            return true;
        }
        if (l1 == null || l2 == null) {
            return false;
        }
        return l1.getX1() == l2.getX1() && l1.getX2() == l2.getX2() && l1.getY1() == l2.getY1() && l1.getY2() == l2.getY2();
    }

    public static String logLine2D(Line2D line) {
        if (line == null) {
            return "null";
        }
        return "x1=" + line.getX1() + " y1=" + line.getY1() + " x2=" + line.getX2() + " y2=" + line.getY2();
    }

    public static Object reprojectGeometry(String targetCRSName, String sourceCRSName, Object geometry) throws NoSuchAuthorityCodeException, FactoryException, TransformException {
        CoordinateReferenceSystem targetCRS = CRS.decode(targetCRSName, true);
        CoordinateReferenceSystem sourceCRS = CRS.decode(sourceCRSName, true);
        if (geometry instanceof GeneralEnvelope) {
            GeneralEnvelope env = (GeneralEnvelope)geometry;
            if (env.getCoordinateReferenceSystem() == null) {
                env.setCoordinateReferenceSystem(sourceCRS);
            }
            return CRS.transform((GeneralEnvelope)geometry, targetCRS);
        }
        if (geometry instanceof GeneralDirectPosition) {
            CoordinateOperation operation;
            CoordinateOperationFactory factory = CRS.getCoordinateOperationFactory(true);
            try {
                operation = factory.createOperation(sourceCRS, targetCRS);
            }
            catch (FactoryException exception) {
                throw new TransformException("transform exception: " + exception.getMessage());
            }
            MathTransform mt = operation.getMathTransform();
            mt.transform((GeneralDirectPosition)geometry, (GeneralDirectPosition)geometry);
            return geometry;
        }
        if (geometry instanceof Line2D) {
            CoordinateOperation operation;
            Line2D line = (Line2D)geometry;
            GeneralDirectPosition pt1 = new GeneralDirectPosition(line.getX1(), line.getY1());
            GeneralDirectPosition pt2 = new GeneralDirectPosition(line.getX2(), line.getY2());
            CoordinateOperationFactory factory = CRS.getCoordinateOperationFactory(true);
            try {
                operation = factory.createOperation(sourceCRS, targetCRS);
            }
            catch (FactoryException exception) {
                throw new TransformException("transform exception: " + exception.getMessage());
            }
            MathTransform mt = operation.getMathTransform();
            mt.transform(pt1, pt1);
            mt.transform(pt2, pt2);
            return new Line2D.Double(pt1.getOrdinate(0), pt1.getOrdinate(1), pt2.getOrdinate(0), pt2.getOrdinate(1));
        }
        throw new IllegalArgumentException("Unknow geometry types: allowed ones are: GeneralEnvelope, Line2D, GeneralDirectPosition");
    }

    public static Object reprojectBbox2DString(String sourceCRSName, String targetCRSName, String boundingBox) throws NoSuchAuthorityCodeException, FactoryException, TransformException {
        String[] bbox = boundingBox.split(",");
        double[] lowerCorner = new double[]{Double.parseDouble(bbox[1]), Double.parseDouble(bbox[0])};
        double[] upperCorner = new double[]{Double.parseDouble(bbox[3]), Double.parseDouble(bbox[2])};
        GeneralEnvelope env = new GeneralEnvelope(lowerCorner, upperCorner);
        env.setCoordinateReferenceSystem(CRS.decode(sourceCRSName, true));
        env = (GeneralEnvelope)GeometricUtilities.reprojectGeometry(targetCRSName, sourceCRSName, env);
        lowerCorner = env.getLowerCorner().getCoordinate();
        upperCorner = env.getUpperCorner().getCoordinate();
        return lowerCorner[0] + "," + lowerCorner[1] + "," + upperCorner[0] + "," + upperCorner[1];
    }
}

