/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import net.jcip.annotations.Immutable;
import org.geotoolkit.parameter.Parameters;
import org.geotoolkit.referencing.operation.provider.NADCON;
import org.geotoolkit.referencing.operation.transform.GridTransform2D;
import org.geotoolkit.referencing.operation.transform.GridType;
import org.geotoolkit.referencing.operation.transform.NadconLoader;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.FactoryException;

@Immutable
public class NadconTransform
extends GridTransform2D {
    private static final long serialVersionUID = -4707304160205218546L;
    private final String latitudeGridFile;
    private final String longitudeGridFile;

    public NadconTransform(String string, String string2) throws FactoryException {
        this(NadconLoader.loadIfAbsent(string, string2));
    }

    private NadconTransform(NadconLoader nadconLoader) {
        super(GridType.NADCON, nadconLoader.getDataBuffer(), nadconLoader.getSize(), nadconLoader.getArea());
        this.latitudeGridFile = (String)nadconLoader.latitudeGridFile;
        this.longitudeGridFile = (String)nadconLoader.longitudeGridFile;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return NADCON.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup parameterValueGroup = this.getParameterDescriptors().createValue();
        Parameters.getOrCreate(NADCON.LAT_DIFF_FILE, parameterValueGroup).setValue(this.latitudeGridFile);
        Parameters.getOrCreate(NADCON.LONG_DIFF_FILE, parameterValueGroup).setValue(this.longitudeGridFile);
        return parameterValueGroup;
    }
}

