/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.converter;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import net.jcip.annotations.Immutable;
import org.geotoolkit.util.converter.NonconvertibleObjectException;
import org.geotoolkit.util.converter.SimpleConverter;

@Immutable
abstract class URIConverter<T>
extends SimpleConverter<URI, T>
implements Serializable {
    private static final long serialVersionUID = 5419481828621160876L;

    URIConverter() {
    }

    @Override
    public final Class<URI> getSourceClass() {
        return URI.class;
    }

    @Override
    public boolean isOrderPreserving() {
        return false;
    }

    @Immutable
    static final class URL
    extends URIConverter<java.net.URL> {
        private static final long serialVersionUID = -7866572007304228474L;
        public static final URL INSTANCE = new URL();

        private URL() {
        }

        @Override
        public Class<java.net.URL> getTargetClass() {
            return java.net.URL.class;
        }

        @Override
        public java.net.URL convert(URI uRI) throws NonconvertibleObjectException {
            if (uRI == null) {
                return null;
            }
            try {
                return uRI.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                throw new NonconvertibleObjectException(URL.formatErrorMessage("URI", uRI, malformedURLException), malformedURLException);
            }
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class File
    extends URIConverter<java.io.File> {
        private static final long serialVersionUID = 5289256237146366469L;
        public static final File INSTANCE = new File();

        private File() {
        }

        @Override
        public Class<java.io.File> getTargetClass() {
            return java.io.File.class;
        }

        @Override
        public java.io.File convert(URI uRI) throws NonconvertibleObjectException {
            if (uRI == null) {
                return null;
            }
            try {
                return new java.io.File(uRI);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new NonconvertibleObjectException(File.formatErrorMessage("URI", uRI, illegalArgumentException), illegalArgumentException);
            }
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class String
    extends URIConverter<java.lang.String> {
        private static final long serialVersionUID = -1745990349642467147L;
        public static final String INSTANCE = new String();

        private String() {
        }

        @Override
        public Class<java.lang.String> getTargetClass() {
            return java.lang.String.class;
        }

        @Override
        public java.lang.String convert(URI uRI) throws NonconvertibleObjectException {
            return uRI != null ? uRI.toASCIIString() : null;
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }
}

