/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.basic.filter.temporal;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Date;
import java.util.List;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.geotoolkit.temporal.factory.DefaultTemporalFactory;
import org.geotoolkit.temporal.object.DefaultPosition;
import org.opengis.cite.iso19136.util.XMLSchemaModelUtils;
import org.opengis.cite.iso19142.util.WFSMessage;
import org.opengis.temporal.TemporalGeometricPrimitive;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class TemporalQuery {
    public static List<Node> extractTemporalNodes(Document rspEntity, XSElementDeclaration timeProperty, XSModel model) {
        List<Node> temporalNodes = null;
        XSTypeDefinition timePropType = timeProperty.getTypeDefinition();
        if (timePropType.getTypeCategory() == 16 || ((XSComplexTypeDefinition)timePropType).getContentType() == 1) {
            temporalNodes = WFSMessage.findMatchingElements(rspEntity, timeProperty);
        } else {
            XSElementDeclaration gmlAbstractTimePrimitive = model.getElementDeclaration("AbstractTimeGeometricPrimitive", "http://www.opengis.net/gml/3.2");
            List<XSElementDeclaration> expectedValues = XMLSchemaModelUtils.getElementsByAffiliation(model, gmlAbstractTimePrimitive);
            temporalNodes = WFSMessage.findMatchingElements(rspEntity, expectedValues.toArray(new XSElementDeclaration[expectedValues.size()]));
        }
        return temporalNodes;
    }

    public static TemporalGeometricPrimitive parseTemporalValue(String value, XSTypeDefinition typeDefinition) {
        if (typeDefinition.getTypeCategory() != 16 && ((XSComplexTypeDefinition)typeDefinition).getContentType() != 1) {
            throw new IllegalArgumentException("Not a simple type definition: " + typeDefinition.getName());
        }
        TemporalGeometricPrimitive tmPrimitive = null;
        DefaultTemporalFactory tmFactory = new DefaultTemporalFactory();
        XSSimpleTypeDefinition simpleTypeDefinition = typeDefinition.getTypeCategory() == 16 ? (XSSimpleTypeDefinition)XSSimpleTypeDefinition.class.cast(typeDefinition) : ((XSComplexTypeDefinition)typeDefinition).getSimpleType();
        switch (simpleTypeDefinition.getBuiltInKind()) {
            case 8: {
                DateTimeFormatter xsdDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss[.SSS][XXX]");
                TemporalAccessor tm = xsdDateTimeFormatter.parseBest(value, ZonedDateTime::from, LocalDateTime::from);
                if (tm instanceof LocalDateTime) {
                    tm = ((LocalDateTime)LocalDateTime.class.cast(tm)).atZone(ZonedDateTime.now().getOffset());
                }
                ZonedDateTime dateTime = (ZonedDateTime)tm;
                tmPrimitive = tmFactory.createInstant(new DefaultPosition(Date.from(dateTime.toInstant())));
                break;
            }
            case 10: {
                ZoneOffset zone = DateTimeFormatter.ISO_DATE.parse((CharSequence)value, TemporalQueries.offset());
                if (null == zone) {
                    zone = ZonedDateTime.now().getOffset();
                }
                LocalDate date = LocalDate.parse(value, DateTimeFormatter.ISO_DATE);
                ZonedDateTime startOfDay = date.atStartOfDay(zone);
                Temporal endOfDay = startOfDay.plus(1L, ChronoUnit.DAYS).minus(1L, ChronoUnit.MILLIS);
                tmPrimitive = tmFactory.createPeriod(tmFactory.createInstant(new DefaultPosition(Date.from(Instant.from(startOfDay)))), tmFactory.createInstant(new DefaultPosition(Date.from(Instant.from(endOfDay)))));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported datatype: " + typeDefinition.getName());
            }
        }
        return tmPrimitive;
    }
}

