/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.simple;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.InputStream;
import java.net.URI;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.opengis.cite.iso19142.BaseFixture;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.SuiteAttribute;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.ValidationUtils;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.opengis.cite.validation.SchematronValidator;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class SimpleCapabilitiesTests
extends BaseFixture {
    private URI reqEndpointUsingGET;
    private Client client;

    @BeforeTest
    public void checkSuitePreconditions(ITestContext context) {
        Object failedPreconditions = context.getSuite().getAttribute(SuiteAttribute.FAILED_PRECONDITIONS.getName());
        if (null != failedPreconditions) {
            throw new SkipException("One or more test suite preconditions were not satisfied: " + failedPreconditions);
        }
    }

    @BeforeClass
    public void extractEndpoint(ITestContext testContext) {
        this.client = Client.create();
        this.reqEndpointUsingGET = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "GetCapabilities", ProtocolBinding.GET);
    }

    @Test(description="See ISO 19142: 7.5")
    public void getCapabilities_missingServiceParam() {
        WebResource resource = this.client.resource(this.reqEndpointUsingGET).queryParam("request", "GetCapabilities");
        resource.accept("application/xml");
        ClientResponse rsp = resource.get(ClientResponse.class);
        Assert.assertEquals(rsp.getStatus(), ClientResponse.Status.BAD_REQUEST.getStatusCode(), ErrorMessage.get("UnexpectedStatus"));
        Assert.assertTrue(rsp.hasEntity(), ErrorMessage.get("MissingXMLEntity"));
        this.rspEntity = rsp.getEntity(Document.class);
        SchematronValidator validator = ValidationUtils.buildSchematronValidator("ExceptionReport.sch", "MissingParameterValuePhase");
        Result result = validator.validate(new DOMSource(this.rspEntity));
        Assert.assertFalse(validator.ruleViolationsDetected(), ErrorMessage.format("NotSchemaValid", validator.getRuleViolationCount(), XMLUtils.resultToString(result)));
    }

    @Test(description="See ISO 19142: 7.2")
    public void getFullCapabilities() {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.putSingle("request", "GetCapabilities");
        params.putSingle("service", "WFS");
        WebResource resource = this.client.resource(this.reqEndpointUsingGET).queryParams(params);
        resource.accept("application/xml");
        ClientResponse rsp = resource.get(ClientResponse.class);
        Assert.assertEquals(rsp.getStatus(), ClientResponse.Status.OK.getStatusCode(), ErrorMessage.get("UnexpectedStatus"));
        this.rspEntity = rsp.getEntity(Document.class);
        Assert.assertNotNull(this.rspEntity, ErrorMessage.get("MissingXMLEntity"));
        SchematronValidator validator = ValidationUtils.buildSchematronValidator("wfs-capabilities-2.0.sch", "SimpleWFSPhase");
        Result result = validator.validate(new DOMSource(this.rspEntity, this.rspEntity.getDocumentURI()), false);
        Assert.assertFalse(validator.ruleViolationsDetected(), ErrorMessage.format("NotSchemaValid", validator.getRuleViolationCount(), XMLUtils.resultToString(result)));
    }

    @Test(description="See ISO 19142: 7.2, 7.3.2", dataProvider="protocol-binding")
    public void getCapabilities_acceptVersions(ProtocolBinding binding) {
        InputStream entityStream = this.getClass().getResourceAsStream("getCapabilities_acceptVersions.xml");
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "GetCapabilities", binding);
        ClientResponse rsp = this.wfsClient.submitRequest(new StreamSource(entityStream), binding, endpoint);
        Assert.assertTrue(rsp.hasEntity(), ErrorMessage.get("MissingXMLEntity"));
        this.rspEntity = this.extractBodyAsDocument(rsp);
        String xpath = "/wfs:WFS_Capabilities/@version = '2.0.0'";
        ETSAssert.assertXPath(xpath, this.rspEntity.getDocumentElement(), null);
    }
}

