/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.transaction;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSModel;
import org.opengis.cite.iso19142.BaseFixture;
import org.opengis.cite.iso19142.FeatureTypeInfo;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.SuiteAttribute;
import org.opengis.cite.iso19142.util.DataSampler;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.WFSMessage;
import org.testng.ISuite;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.w3c.dom.Document;

public class TransactionFixture
extends BaseFixture {
    protected DataSampler dataSampler;
    protected XSModel model;

    void setModel(XSModel model) {
        this.model = model;
    }

    @BeforeClass(alwaysRun=true)
    public void initTransactionFixture(ITestContext testContext) {
        ISuite suite = testContext.getSuite();
        this.dataSampler = (DataSampler)suite.getAttribute(SuiteAttribute.SAMPLER.getName());
        this.model = (XSModel)suite.getAttribute(org.opengis.cite.iso19136.SuiteAttribute.XSMODEL.getName());
    }

    @BeforeMethod
    public void buildTransactionRequest() {
        this.reqEntity = WFSMessage.createRequestEntity("Transaction", this.wfsVersion);
    }

    @DataProvider(name="binding+availFeatureType")
    public Iterator<Object[]> trxTestParameters(ITestContext testContext) {
        ISuite suite = testContext.getSuite();
        Document wfsMetadata = (Document)suite.getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        if (null == wfsMetadata) {
            throw new NullPointerException("Service description not found in ITestContext");
        }
        Set<ProtocolBinding> trxBindings = ServiceMetadataUtils.getOperationBindings(wfsMetadata, "Transaction");
        DataSampler sampler = (DataSampler)suite.getAttribute(SuiteAttribute.SAMPLER.getName());
        Map<QName, FeatureTypeInfo> featureInfo = sampler.getFeatureTypeInfo();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (ProtocolBinding binding : trxBindings) {
            for (FeatureTypeInfo typeInfo : featureInfo.values()) {
                if (!typeInfo.isInstantiated()) continue;
                Object[] tuple = new Object[]{binding, typeInfo.getTypeName()};
                paramList.add(tuple);
            }
        }
        return paramList.iterator();
    }
}

