/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.util.Iterator;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmEmptySequence;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XQueryEvaluator
implements Iterable<XdmItem> {
    private Processor processor;
    private XQueryExpression expression;
    private DynamicQueryContext context;
    private Destination destination;

    protected XQueryEvaluator(Processor processor, XQueryExpression expression) {
        this.processor = processor;
        this.expression = expression;
        this.context = new DynamicQueryContext(expression.getExecutable().getConfiguration());
    }

    public void setSource(Source source) throws SaxonApiException {
        this.setContextItem(this.processor.newDocumentBuilder().build(source));
    }

    public void setContextItem(XdmItem item) {
        this.context.setContextItem(item == null ? null : (Item)item.getUnderlyingValue());
    }

    public XdmItem getContextItem() {
        return (XdmItem)XdmValue.wrap(this.context.getContextItem());
    }

    public void setExternalVariable(QName name, XdmValue value) {
        this.context.setParameter(name.getClarkName(), value == null ? null : value.getUnderlyingValue());
    }

    public XdmValue getExternalVariable(QName name) {
        Object oval = this.context.getParameter(name.getClarkName());
        if (oval == null) {
            return null;
        }
        if (oval instanceof ValueRepresentation) {
            return XdmValue.wrap((ValueRepresentation)oval);
        }
        throw new IllegalStateException(oval.getClass().getName());
    }

    public void setURIResolver(URIResolver resolver2) {
        this.context.setURIResolver(resolver2);
    }

    public URIResolver getURIResolver() {
        return this.context.getURIResolver();
    }

    public void setErrorListener(ErrorListener listener) {
        this.context.setErrorListener(listener);
    }

    public ErrorListener getErrorListener() {
        return this.context.getErrorListener();
    }

    public void setTraceListener(TraceListener listener) {
        this.context.setTraceListener(listener);
    }

    public TraceListener getTraceListener() {
        return this.context.getTraceListener();
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public void run() throws SaxonApiException {
        try {
            this.expression.run(this.context, this.destination.getReceiver(this.expression.getExecutable().getConfiguration()), null);
        }
        catch (TransformerException e) {
            throw new SaxonApiException(e);
        }
    }

    public void run(Destination destination) throws SaxonApiException {
        try {
            this.expression.run(this.context, destination.getReceiver(this.expression.getExecutable().getConfiguration()), null);
        }
        catch (TransformerException e) {
            throw new SaxonApiException(e);
        }
    }

    public XdmValue evaluate() throws SaxonApiException {
        try {
            SequenceIterator iter = this.expression.iterator(this.context);
            ValueRepresentation result = SequenceExtent.makeSequenceExtent(iter);
            if (result instanceof NodeInfo) {
                return new XdmNode((NodeInfo)result);
            }
            if (result instanceof AtomicValue) {
                return new XdmAtomicValue((AtomicValue)result);
            }
            if (result instanceof EmptySequence) {
                return XdmEmptySequence.getInstance();
            }
            return new XdmValue(result);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    @Override
    public Iterator<XdmItem> iterator() throws SaxonApiUncheckedException {
        try {
            return new XdmSequenceIterator(this.expression.iterator(this.context));
        }
        catch (XPathException e) {
            throw new SaxonApiUncheckedException(e);
        }
    }

    public DynamicQueryContext getUnderlyingQueryContext() {
        return this.context;
    }
}

