/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.io;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.geotoolkit.lang.Static;
import org.geotoolkit.resources.Errors;

public final class Buffers
extends Static {
    private Buffers() {
    }

    public static int getDataSize(Buffer buffer) throws IllegalArgumentException {
        if (buffer == null) {
            return 0;
        }
        if (buffer instanceof ByteBuffer) {
            return 8;
        }
        if (buffer instanceof CharBuffer) {
            return 16;
        }
        if (buffer instanceof ShortBuffer) {
            return 16;
        }
        if (buffer instanceof IntBuffer) {
            return 32;
        }
        if (buffer instanceof LongBuffer) {
            return 64;
        }
        if (buffer instanceof FloatBuffer) {
            return 32;
        }
        if (buffer instanceof DoubleBuffer) {
            return 64;
        }
        throw new IllegalArgumentException(Errors.format(226, buffer.getClass()));
    }

    public static CharBuffer asCharBuffer(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        byteBuffer.position(0).limit(byteBuffer.capacity());
        CharBuffer charBuffer = byteBuffer.asCharBuffer();
        byteBuffer.position(n).limit(n2);
        return charBuffer;
    }

    public static ShortBuffer asShortBuffer(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        byteBuffer.position(0).limit(byteBuffer.capacity());
        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
        byteBuffer.position(n).limit(n2);
        return shortBuffer;
    }

    public static IntBuffer asIntBuffer(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        byteBuffer.position(0).limit(byteBuffer.capacity());
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        byteBuffer.position(n).limit(n2);
        return intBuffer;
    }

    public static LongBuffer asLongBuffer(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        byteBuffer.position(0).limit(byteBuffer.capacity());
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        byteBuffer.position(n).limit(n2);
        return longBuffer;
    }

    public static FloatBuffer asFloatBuffer(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        byteBuffer.position(0).limit(byteBuffer.capacity());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        byteBuffer.position(n).limit(n2);
        return floatBuffer;
    }

    public static DoubleBuffer asDoubleBuffer(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        byteBuffer.position(0).limit(byteBuffer.capacity());
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        byteBuffer.position(n).limit(n2);
        return doubleBuffer;
    }
}

