/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.sql.DataSource;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.internal.Citations;
import org.geotoolkit.internal.sql.DefaultDataSource;
import org.geotoolkit.internal.sql.IdentifierGenerator;
import org.geotoolkit.internal.sql.StatementEntry;
import org.geotoolkit.internal.sql.StatementPool;
import org.geotoolkit.metadata.KeyNamePolicy;
import org.geotoolkit.metadata.MetadataStandard;
import org.geotoolkit.metadata.NullValuePolicy;
import org.geotoolkit.metadata.TypeValuePolicy;
import org.geotoolkit.metadata.sql.MetadataSource;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.util.CodeList;

@ThreadSafe
public class MetadataWriter
extends MetadataSource {
    private static final boolean INDEX_INHERITANCE_SUPPORTED = false;
    private static final String CODE_COLUMN = "CODE";
    private int maximumIdentifierLength = 24;
    private int maximumValueLength = 1000;
    private NullValuePolicy columnCreationPolicy = NullValuePolicy.NON_EMPTY;
    private final IdentifierGenerator<String, StatementEntry> idCheck = new IdentifierGenerator.Simple(this.statements, "ID", this.buffer);

    public MetadataWriter(String string, String string2) throws SQLException {
        this(MetadataStandard.ISO_19115, new DefaultDataSource(string), string2);
    }

    public MetadataWriter(MetadataStandard metadataStandard, DataSource dataSource, String string) throws SQLException {
        super(metadataStandard, dataSource, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NullValuePolicy getColumnCreationPolicy() {
        StatementPool statementPool = this.statements;
        synchronized (statementPool) {
            return this.columnCreationPolicy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColumnCreationPolicy(NullValuePolicy nullValuePolicy) {
        ArgumentChecks.ensureNonNull("policy", (Object)nullValuePolicy);
        StatementPool statementPool = this.statements;
        synchronized (statementPool) {
            this.columnCreationPolicy = nullValuePolicy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaximumValueLength() {
        StatementPool statementPool = this.statements;
        synchronized (statementPool) {
            return this.maximumValueLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumValueLength(int n) {
        ArgumentChecks.ensureStrictlyPositive("length", n);
        StatementPool statementPool = this.statements;
        synchronized (statementPool) {
            this.maximumValueLength = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaximumIdentifierLength() {
        StatementPool statementPool = this.statements;
        synchronized (statementPool) {
            return this.maximumIdentifierLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumIdentifierLength(int n) {
        ArgumentChecks.ensureStrictlyPositive("length", n);
        StatementPool statementPool = this.statements;
        synchronized (statementPool) {
            this.maximumIdentifierLength = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String add(Object object) throws ClassCastException, SQLException {
        String string = this.proxy(object);
        if (string == null) {
            StatementPool statementPool = this.statements;
            synchronized (statementPool) {
                Connection connection = this.statements.connection();
                Statement statement = connection.createStatement();
                connection.setAutoCommit(false);
                boolean bl = false;
                try {
                    string = object instanceof CodeList ? this.addCode(statement, (CodeList)object) : this.add(statement, object, new IdentityHashMap<Object, String>(), null);
                    statement.close();
                    bl = true;
                }
                finally {
                    if (bl) {
                        connection.commit();
                    } else {
                        connection.rollback();
                    }
                    connection.setAutoCommit(true);
                }
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String add(Statement statement, Object object, Map<Object, String> map, String string) throws ClassCastException, SQLException {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Set<String> set;
        assert (Thread.holdsLock(this.statements));
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> clazz2 : this.asMap(object).entrySet()) {
            linkedHashMap.put(clazz2.getKey(), MetadataWriter.extractFromCollection(clazz2.getValue()));
        }
        Class<?> clazz3 = object.getClass();
        Class<?> clazz = this.standard.getInterface(clazz3);
        String string2 = MetadataWriter.getTableName(clazz);
        String string3 = this.search(string2, set = this.getExistingColumns(string2), linkedHashMap, statement, this.buffer);
        if (string3 != null) {
            if (map.put(object, string3) != null) {
                throw new AssertionError(object);
            }
            return string3;
        }
        if (this.columnCreationPolicy != NullValuePolicy.ALL) {
            object6 = linkedHashMap.values().iterator();
            while (object6.hasNext()) {
                if (object6.next() != null) continue;
                object6.remove();
            }
        }
        this.createTable(statement, clazz, string2, set);
        object6 = null;
        Map<String, Class<?>> map2 = null;
        LinkedHashMap<Object, FKey> linkedHashMap2 = null;
        for (Object n : linkedHashMap.keySet()) {
            if (set.contains(n)) continue;
            if (object6 == null) {
                object6 = this.standard.asTypeMap(clazz3, TypeValuePolicy.ELEMENT_TYPE, KeyNamePolicy.UML_IDENTIFIER);
                map2 = this.standard.asTypeMap(clazz3, TypeValuePolicy.DECLARING_INTERFACE, KeyNamePolicy.UML_IDENTIFIER);
            }
            Map.Entry entry = string2;
            object5 = (Class)map2.get(n);
            if (!clazz.isAssignableFrom((Class<?>)object5)) {
                entry = MetadataWriter.getTableName(object5);
            }
            int n2 = this.maximumValueLength;
            object4 = (Class)object6.get(n);
            if (CodeList.class.isAssignableFrom((Class<?>)object4) || this.standard.isMetadata((Class<?>)object4)) {
                n2 = this.maximumIdentifierLength;
                if (linkedHashMap2 == null) {
                    linkedHashMap2 = new LinkedHashMap<Object, FKey>();
                }
                if (linkedHashMap2.put(n, new FKey((String)((Object)entry), (Class<?>)object4, null)) != null) {
                    throw new AssertionError(n);
                }
                object4 = null;
            }
            statement.executeUpdate(this.buffer.createColumn(this.schema, (String)((Object)entry), (String)n, (Class<?>)object4, n2));
            set.add((String)n);
        }
        string3 = this.suggestIdentifier(object);
        if (string3 == null && (string3 = string) == null) {
            string3 = "unknown";
            for (Object n : linkedHashMap.values()) {
                if (n == null || this.standard.isMetadata(n.getClass())) continue;
                string3 = MetadataWriter.abbreviation(n.toString());
                break;
            }
        }
        for (int hashMap = 0; hashMap < 4; ++hashMap) {
            int string5 = this.maximumIdentifierLength - hashMap;
            if (string3.length() > string5) {
                string3 = string3.substring(0, string5);
            }
            if ((string3 = this.idCheck.identifier(this.schema, string2, string3)).length() <= this.maximumIdentifierLength) break;
        }
        if (map.put(object, string3) != null) {
            throw new AssertionError(object);
        }
        HashMap<String, FKey> hashMap = null;
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            object5 = entry.getValue();
            Class<?> clazz5 = object5.getClass();
            if (CodeList.class.isAssignableFrom(clazz5)) {
                object5 = this.addCode(statement, (CodeList)object5);
            } else if (this.standard.isMetadata(clazz5)) {
                object4 = this.proxy(object5);
                if (object4 == null && (object4 = map.get(object5)) == null) {
                    object4 = this.add(statement, object5, map, string3);
                    assert (map.get(object5) == object4);
                    String bl = (String)entry.getKey();
                    object3 = this.standard.getInterface(object5.getClass());
                    object2 = null;
                    if (linkedHashMap2 != null && (object2 = (FKey)linkedHashMap2.get(bl)) != null && !((Class)object3).isAssignableFrom(((FKey)object2).tableType)) {
                        ((FKey)object2).tableType = object3;
                    }
                    if (object2 == null) {
                        Object object7;
                        if (hashMap == null) {
                            hashMap = new HashMap<String, FKey>();
                            object7 = statement.getConnection().getMetaData().getImportedKeys(CATALOG, this.schema, string2);
                            try {
                                while (object7.next()) {
                                    if (this.schema != null && !this.schema.equals(object7.getString("PKTABLE_SCHEM")) || CATALOG != null && !CATALOG.equals(object7.getString("PKTABLE_CAT"))) continue;
                                    hashMap.put(object7.getString("FKCOLUMN_NAME"), new FKey(object7.getString("PKTABLE_NAME"), null, object7.getString("FK_NAME")));
                                }
                            }
                            finally {
                                object7.close();
                            }
                        }
                        if ((object2 = (FKey)hashMap.remove(bl)) != null && !((FKey)object2).tableName.equals(MetadataWriter.getTableName(object3))) {
                            this.buffer.clear().append("ALTER TABLE ").appendIdentifier(this.schema, string2).append(" DROP CONSTRAINT ").appendIdentifier(((FKey)object2).keyName);
                            statement.executeUpdate(this.buffer.toString());
                            object7 = Errors.getResources(null).getLogRecord(Level.WARNING, 267, string2 + '.' + bl + " \u21d2 " + ((FKey)object2).tableName + '.' + "ID");
                            ((LogRecord)object7).setSourceMethodName("add");
                            ((LogRecord)object7).setSourceClassName(MetadataWriter.class.getName());
                            Logging.getLogger(MetadataWriter.class).log((LogRecord)object7);
                        }
                    }
                }
                object5 = object4;
            }
            entry.setValue(object5);
        }
        if (linkedHashMap2 != null) {
            for (Map.Entry entry : linkedHashMap2.entrySet()) {
                object5 = (FKey)entry.getValue();
                Class<?> clazz2 = ((FKey)object5).tableType;
                object4 = "ID";
                boolean bl = CodeList.class.isAssignableFrom(clazz2);
                if (bl) {
                    object4 = CODE_COLUMN;
                } else {
                    clazz2 = this.standard.getInterface(clazz2);
                }
                object3 = (String)entry.getKey();
                object2 = MetadataWriter.getTableName(clazz2);
                statement.executeUpdate(this.buffer.createForeignKey(this.schema, ((FKey)object5).tableName, (String)object3, (String)object2, (String)object4, !bl));
                if (string2.equals(((FKey)object5).tableName)) continue;
                statement.executeUpdate(this.buffer.createForeignKey(this.schema, string2, (String)object3, (String)object2, (String)object4, !bl));
            }
        }
        this.buffer.clear().append("INSERT INTO ").appendIdentifier(this.schema, string2).append(" (").append("ID");
        for (Map.Entry entry : linkedHashMap.keySet()) {
            this.buffer.append(", ").appendIdentifier((String)((Object)entry));
        }
        this.buffer.append(") VALUES (").appendValue(string3);
        for (Map.Entry entry : linkedHashMap.values()) {
            this.buffer.append(", ").appendValue(entry);
        }
        String string4 = this.buffer.append(')').toString();
        if (statement.executeUpdate(string4) != 1) {
            throw new SQLException(Errors.format(47));
        }
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    private void createTable(Statement statement, Class<?> clazz, String string, Set<String> set) throws SQLException {
        if (set.isEmpty()) {
            void var6_9;
            StringBuilder stringBuilder = null;
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                if (!this.standard.isMetadata(clazz2)) continue;
                String string2 = MetadataWriter.getTableName(clazz2);
                this.createTable(statement, clazz2, string2, this.getExistingColumns(string2));
                if (stringBuilder == null) {
                    this.buffer.clear().append("CREATE TABLE ").appendIdentifier(this.schema, string);
                    this.buffer.append("(CONSTRAINT ").appendIdentifier(string + "_pkey").append(" PRIMARY KEY (").append("ID").append(")) ");
                    stringBuilder = new StringBuilder(this.buffer.append(" INHERITS (").toString());
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.buffer.clear().appendIdentifier(this.schema, string2));
            }
            if (stringBuilder != null) {
                String string3 = stringBuilder.append(')').toString();
            } else {
                String string4 = this.createTable(string, "ID");
            }
            statement.executeUpdate((String)var6_9);
            set.add("ID");
        }
    }

    private String createTable(String string, String string2) {
        return this.buffer.clear().append("CREATE TABLE ").appendIdentifier(this.schema, string).append(" (").append(string2).append(" VARCHAR(").append(this.maximumIdentifierLength).append(") NOT NULL PRIMARY KEY)").toString();
    }

    private String addCode(Statement statement, CodeList<?> codeList) throws SQLException {
        String string;
        assert (Thread.holdsLock(this.statements));
        String string2 = MetadataWriter.getTableName(codeList.getClass());
        Set<String> set = this.getExistingColumns(string2);
        if (set.isEmpty()) {
            statement.executeUpdate(this.createTable(string2, CODE_COLUMN));
            set.add(CODE_COLUMN);
        }
        String string3 = codeList.name();
        ResultSet resultSet = statement.executeQuery(this.buffer.clear().append("SELECT ").append(CODE_COLUMN).append(" FROM ").appendIdentifier(this.schema, string2).append(" WHERE ").append(CODE_COLUMN).appendCondition(string3).toString());
        boolean bl = resultSet.next();
        resultSet.close();
        if (!bl && statement.executeUpdate(string = this.buffer.clear().append("INSERT INTO ").appendIdentifier(this.schema, string2).append(" (").append(CODE_COLUMN).append(") VALUES (").appendValue(string3).append(')').toString()) != 1) {
            throw new SQLException(Errors.format(47));
        }
        return string3;
    }

    protected String suggestIdentifier(Object object) throws SQLException {
        if (object instanceof Identifier) {
            Identifier identifier = (Identifier)object;
            String string = Citations.getIdentifier(identifier.getAuthority());
            String string2 = identifier.getCode();
            return string != null ? string + ':' + string2 : string2;
        }
        if (object instanceof Citation) {
            return Citations.getIdentifier((Citation)object);
        }
        if (object instanceof ResponsibleParty) {
            ResponsibleParty responsibleParty = (ResponsibleParty)object;
            CharSequence charSequence = responsibleParty.getIndividualName();
            if (charSequence == null && (charSequence = responsibleParty.getOrganisationName()) == null) {
                charSequence = responsibleParty.getPositionName();
            }
            if (charSequence != null) {
                return MetadataWriter.abbreviation(charSequence.toString());
            }
        }
        return null;
    }

    private static String abbreviation(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            stringBuilder.append(stringTokenizer.nextToken().charAt(0));
        }
        if (stringBuilder.length() > 2) {
            return stringBuilder.toString();
        }
        return string;
    }

    private static final class FKey {
        final String tableName;
        Class<?> tableType;
        final String keyName;

        FKey(String string, Class<?> clazz, String string2) {
            this.tableName = string;
            this.tableType = clazz;
            this.keyName = string2;
        }
    }
}

