/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.transaction;

import com.sun.jersey.api.client.ClientResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xerces.xs.XSElementDeclaration;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.transaction.TransactionFixture;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.cite.iso19142.util.WFSMessage;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ReplaceTests
extends TransactionFixture {
    public static final String REPL_PROPS = "replProps";
    private List<Element> originalFeatures = new ArrayList<Element>();

    @AfterClass
    public void restoreModifiedFeatures() {
        Boolean result;
        if (this.originalFeatures.isEmpty()) {
            return;
        }
        Document req = WFSMessage.createRequestEntity("Transaction", this.wfsVersion);
        WFSMessage.addReplaceStatements(req, this.originalFeatures);
        ClientResponse rsp = this.wfsClient.submitRequest(req, ProtocolBinding.ANY);
        Document rspEntity = rsp.getEntity(Document.class);
        String expr = String.format("//wfs:totalReplaced = '%d'", this.originalFeatures.size());
        try {
            result = (Boolean)XMLUtils.evaluateXPath(rspEntity, expr, null, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        if (!result.booleanValue()) {
            String msg = String.format("%s: Failed to replace modified features.\n%s", this.getClass().getName(), XMLUtils.writeNodeToString(rspEntity));
            TestSuiteLogger.log(Level.WARNING, msg);
        }
    }

    @Test(description="See ISO 19142: 15.3.3, 15.3.6", dataProvider="binding+availFeatureType")
    public void replaceFeature(ProtocolBinding binding, QName featureType) {
        Document doc = this.wfsClient.getFeatureByType(featureType, 1, null);
        NodeList features = doc.getElementsByTagNameNS(featureType.getNamespaceURI(), featureType.getLocalPart());
        Element originalFeature = (Element)features.item(0);
        Element replacement = this.createReplacementFeature(originalFeature);
        List<Element> replacements = Arrays.asList(replacement);
        WFSMessage.addReplaceStatements(this.reqEntity, replacements);
        ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, binding);
        this.rspEntity = rsp.getEntity(Document.class);
        String xpath = String.format("//wfs:totalReplaced = '%d'", replacements.size());
        ETSAssert.assertXPath(xpath, this.rspEntity, null);
        this.originalFeatures.add(originalFeature);
        Element resourceId = (Element)this.rspEntity.getElementsByTagNameNS("http://www.opengis.net/fes/2.0", "ResourceId").item(0);
        Assert.assertNotNull(resourceId, ErrorMessage.format("MissingInfosetItem", "ResourceId"));
        String gmlId = resourceId.getAttribute("rid");
        Map replProps = (Map)replacement.getUserData(REPL_PROPS);
        this.rspEntity = this.wfsClient.invokeStoredQuery("http://www.opengis.net/def/query/OGC-WFS/0/GetFeatureById", Collections.singletonMap("id", gmlId));
        Element feature = this.rspEntity.getDocumentElement();
        ETSAssert.assertQualifiedName(feature, featureType);
        ETSAssert.assertSimpleProperties(feature, replProps, null);
    }

    Element createReplacementFeature(Element originalFeature) {
        Element replacement = (Element)originalFeature.cloneNode(true);
        HashMap<XSElementDeclaration, String> replProps = new HashMap<XSElementDeclaration, String>();
        QName propName = new QName("http://www.opengis.net/gml/3.2", "identifier");
        Element identifier = XMLUtils.createElement(propName);
        identifier.setAttribute("codeSpace", "http://cite.opengeospatial.org/");
        String idValue = UUID.randomUUID().toString();
        identifier.setTextContent(idValue);
        WFSMessage.insertGMLProperty(replacement, identifier);
        replProps.put(this.model.getElementDeclaration("identifier", "http://www.opengis.net/gml/3.2"), idValue);
        propName = new QName("http://www.opengis.net/gml/3.2", "description");
        Element desc = XMLUtils.createElement(propName);
        String description = "Lorem ipsum dolor sit amet.";
        desc.setTextContent(description);
        WFSMessage.insertGMLProperty(replacement, desc);
        replProps.put(this.model.getElementDeclaration("description", "http://www.opengis.net/gml/3.2"), description);
        replacement.setUserData(REPL_PROPS, replProps, null);
        return replacement;
    }
}

