/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.rmi;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.internal.rmi.LocalExecutor;
import org.geotoolkit.internal.rmi.RemoteFuture;
import org.geotoolkit.internal.rmi.RemoteService;
import org.geotoolkit.internal.rmi.ShareableTask;
import org.geotoolkit.internal.rmi.TaskExecutor;
import org.geotoolkit.internal.rmi.TaskFuture;

@ThreadSafe
class RemoteExecutor
extends RemoteService
implements TaskExecutor {
    private static final long serialVersionUID = -8679778209372812019L;
    static final String NAME = "org/geotoolkit/RemoteExecutor";
    private final TaskExecutor master;
    private final List<TaskExecutor> slaves = new ArrayList<TaskExecutor>(1);

    public RemoteExecutor(TaskExecutor taskExecutor) throws RemoteException {
        super(NAME);
        this.master = taskExecutor;
        if (taskExecutor != null) {
            this.slaves.add(new LocalExecutor(false));
            taskExecutor.slave(this, true);
        }
    }

    @Override
    public String name() {
        return LocalExecutor.hostname();
    }

    @Override
    public synchronized <Input, Output> TaskFuture<Output> submit(ShareableTask<Input, Output> shareableTask) throws RemoteException {
        if (this.slaves.isEmpty()) {
            this.slaves.add(new LocalExecutor(false));
        }
        ArrayList arrayList = new ArrayList(this.slaves.size());
        for (TaskExecutor taskExecutor : this.slaves) {
            arrayList.add(taskExecutor.submit(shareableTask));
        }
        return new RemoteFuture<Output>(shareableTask, arrayList);
    }

    @Override
    public synchronized void slave(TaskExecutor taskExecutor, boolean bl) throws RemoteException {
        RemoteExecutor.logger().log(Level.INFO, "{0} \"{1}\" node.", new Object[]{bl ? "Register" : "Shutdown", taskExecutor.name()});
        if (bl) {
            this.slaves.add(taskExecutor);
        } else {
            this.slaves.remove(taskExecutor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() throws RemoteException {
        TaskExecutor[] taskExecutorArray = this;
        synchronized (this) {
            super.shutdown();
            if (this.master != null) {
                this.master.slave((TaskExecutor)this, false);
            }
            TaskExecutor[] taskExecutorArray2 = this.slaves.toArray(new TaskExecutor[this.slaves.size()]);
            this.slaves.clear();
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (TaskExecutor taskExecutor : taskExecutorArray2) {
                taskExecutor.shutdown();
            }
            return;
        }
    }
}

