/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.math;

import java.io.Serializable;
import org.geotoolkit.math.Vector;
import org.geotoolkit.util.converter.Numbers;

final class ConcatenatedVector
extends Vector
implements Serializable {
    private static final long serialVersionUID = 4639375525939012394L;
    private final Vector first;
    private final Vector second;
    private final int limit;

    public ConcatenatedVector(Vector vector, Vector vector2) {
        this.first = vector;
        this.second = vector2;
        this.limit = vector.size();
    }

    @Override
    public Class<? extends Number> getElementType() {
        return Numbers.widestClass(this.first.getElementType(), this.second.getElementType());
    }

    @Override
    public int size() {
        return this.limit + this.second.size();
    }

    @Override
    public boolean isNaN(int n) throws IndexOutOfBoundsException {
        Vector vector;
        if (n < this.limit) {
            vector = this.first;
        } else {
            vector = this.second;
            n -= this.limit;
        }
        return vector.isNaN(n);
    }

    @Override
    public double doubleValue(int n) {
        Vector vector;
        if (n < this.limit) {
            vector = this.first;
        } else {
            vector = this.second;
            n -= this.limit;
        }
        return vector.doubleValue(n);
    }

    @Override
    public float floatValue(int n) {
        Vector vector;
        if (n < this.limit) {
            vector = this.first;
        } else {
            vector = this.second;
            n -= this.limit;
        }
        return vector.floatValue(n);
    }

    @Override
    public long longValue(int n) {
        Vector vector;
        if (n < this.limit) {
            vector = this.first;
        } else {
            vector = this.second;
            n -= this.limit;
        }
        return vector.longValue(n);
    }

    @Override
    public int intValue(int n) {
        Vector vector;
        if (n < this.limit) {
            vector = this.first;
        } else {
            vector = this.second;
            n -= this.limit;
        }
        return vector.intValue(n);
    }

    @Override
    public short shortValue(int n) {
        Vector vector;
        if (n < this.limit) {
            vector = this.first;
        } else {
            vector = this.second;
            n -= this.limit;
        }
        return vector.shortValue(n);
    }

    @Override
    public byte byteValue(int n) {
        Vector vector;
        if (n < this.limit) {
            vector = this.first;
        } else {
            vector = this.second;
            n -= this.limit;
        }
        return vector.byteValue(n);
    }

    @Override
    public Number get(int n) {
        Vector vector;
        if (n < this.limit) {
            vector = this.first;
        } else {
            vector = this.second;
            n -= this.limit;
        }
        return vector.get(n);
    }

    @Override
    public Number set(int n, Number number) {
        Vector vector;
        if (n < this.limit) {
            vector = this.first;
        } else {
            vector = this.second;
            n -= this.limit;
        }
        return vector.set(n, number);
    }

    @Override
    Vector createSubList(int n, int n2, int n3) {
        if (n >= this.limit) {
            return this.second.subList(n - this.limit, n2, n3);
        }
        if (n + n2 * n3 <= this.limit) {
            return this.first.subList(n, n2, n3);
        }
        return super.createSubList(n, n2, n3);
    }

    @Override
    Vector createConcatenate(Vector vector) {
        return this.first.concatenate(this.second.concatenate(vector));
    }
}

