/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.querymgmt;

import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import org.opengis.cite.iso19142.BaseFixture;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.SuiteAttribute;
import org.opengis.cite.iso19142.util.DataSampler;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.WFSMessage;
import org.testng.Assert;
import org.testng.ISuite;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class DropStoredQueryTests
extends BaseFixture {
    private DataSampler dataSampler;

    @BeforeClass
    public void initQueryFilterFixture(ITestContext testContext) {
        ISuite suite = testContext.getSuite();
        this.dataSampler = (DataSampler)suite.getAttribute(SuiteAttribute.SAMPLER.getName());
    }

    @Test(description="See OGC 09-025: 14.6.2")
    public void dropStoredQuery() {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "CreateStoredQuery", ProtocolBinding.POST);
        this.reqEntity = WFSMessage.createRequestEntity("/org/opengis/cite/iso19142/querymgmt/CreateStoredQuery-GetFeatureByName", this.wfsVersion);
        WFSMessage.setReturnTypesAndTypeNamesAttribute(this.reqEntity, this.dataSampler.selectRandomFeatureType());
        ClientResponse rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), ProtocolBinding.POST, endpoint);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        this.reqEntity = WFSMessage.createRequestEntity("DropStoredQuery", this.wfsVersion);
        this.reqEntity.getDocumentElement().setAttribute("id", "urn:example:wfs2-query:GetFeatureByName");
        endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "DropStoredQuery", ProtocolBinding.POST);
        rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), ProtocolBinding.POST, endpoint);
        this.rspEntity = (Document)rsp.getEntity(Document.class);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        ETSAssert.assertQualifiedName(this.rspEntity.getDocumentElement(), new QName("http://www.opengis.net/wfs/2.0", "DropStoredQueryResponse"));
        Map<String, Object> params = Collections.singletonMap("name", "Irrelevant");
        this.rspEntity = this.wfsClient.invokeStoredQuery("urn:example:wfs2-query:GetFeatureByName", params);
        ETSAssert.assertExceptionReport(this.rspEntity, "InvalidParameterValue", "id");
    }

    @Test(description="See OGC 09-025: 14.6.1, 14.7")
    public void dropNonexistentQuery() {
        this.reqEntity = WFSMessage.createRequestEntity("DropStoredQuery", this.wfsVersion);
        this.reqEntity.getDocumentElement().setAttribute("id", "urn:uuid:" + UUID.randomUUID().toString());
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "DropStoredQuery", ProtocolBinding.POST);
        ClientResponse rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), ProtocolBinding.POST, endpoint);
        this.rspEntity = (Document)rsp.getEntity(Document.class);
        ETSAssert.assertExceptionReport(this.rspEntity, "InvalidParameterValue", "id");
    }
}

