/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.util;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.opengis.cite.iso19136.util.XMLSchemaModelUtils;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.util.AppSchemaUtils;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WFSMessage {
    private static final Logger LOGR = Logger.getLogger(WFSMessage.class.getPackage().getName());
    private static final String TNS_PREFIX = "tns";
    private static final DocumentBuilder BUILDER = WFSMessage.initDocBuilder();

    private static DocumentBuilder initDocBuilder() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            TestSuiteLogger.log(Level.WARNING, "Failed to create parser", e);
        }
        return builder;
    }

    public static String transformEntityToKVP(Source xmlSource) {
        StreamSource xsltSource = new StreamSource(WFSMessage.class.getResourceAsStream("xml2kvp.xsl"));
        TransformerFactory factory = TransformerFactory.newInstance();
        StringWriter writer = new StringWriter();
        try {
            Transformer transformer = factory.newTransformer(xsltSource);
            transformer.transform(xmlSource, new StreamResult(writer));
        }
        catch (Exception e) {
            TestSuiteLogger.log(Level.WARNING, "Failed to generate KVP result from Source " + xmlSource.getSystemId(), e);
        }
        return writer.toString();
    }

    public static Document wrapEntityInSOAPEnvelope(Source xmlSource, String version) {
        if ("1.1".equals(version)) {
            return WFSMessage.wrapEntityInSOAPEnvelopeWithNS(xmlSource, "http://schemas.xmlsoap.org/soap/envelope/");
        }
        return WFSMessage.wrapEntityInSOAPEnvelopeWithNS(xmlSource, "http://www.w3.org/2003/05/soap-envelope");
    }

    public static Element appendSimpleQuery(Document doc, QName ... qNames) {
        Element docElement = doc.getDocumentElement();
        Element newQuery = doc.createElementNS("http://www.opengis.net/wfs/2.0", "wfs:Query");
        StringBuilder typeNames = new StringBuilder();
        for (QName qName : qNames) {
            String nsPrefix = docElement.lookupPrefix(qName.getNamespaceURI());
            if (null == nsPrefix) {
                nsPrefix = "ns" + Integer.toString((int)(Math.random() * 100.0));
                newQuery.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + nsPrefix, qName.getNamespaceURI());
            }
            typeNames.append(nsPrefix).append(':').append(qName.getLocalPart()).append(' ');
        }
        newQuery.setAttribute("typeNames", typeNames.toString().trim());
        docElement.appendChild(newQuery);
        return newQuery;
    }

    public static void appendStoredQuery(Document doc, String queryId, Map<String, Object> params) {
        Element docElement = doc.getDocumentElement();
        Element newQuery = doc.createElementNS("http://www.opengis.net/wfs/2.0", "wfs:StoredQuery");
        newQuery.setAttribute("id", queryId);
        docElement.appendChild(newQuery);
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Element param = doc.createElementNS("http://www.opengis.net/wfs/2.0", "Parameter");
            param.setPrefix("wfs");
            param.setAttribute("name", entry.getKey());
            newQuery.appendChild(param);
            Object value = entry.getValue();
            if (QName.class.isInstance(value)) {
                QName qName = (QName)QName.class.cast(value);
                String prefix = qName.getPrefix().isEmpty() ? TNS_PREFIX : qName.getPrefix();
                param.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, qName.getNamespaceURI());
                param.setTextContent(prefix + ":" + qName.getLocalPart());
                continue;
            }
            param.setTextContent(value.toString());
        }
    }

    public static Document createRequestEntity(String reqResource, String wfsVersion) {
        String resourceName = reqResource + ".xml";
        Document doc = null;
        try {
            doc = BUILDER.parse(WFSMessage.class.getResourceAsStream(resourceName));
        }
        catch (Exception e) {
            TestSuiteLogger.log(Level.WARNING, "Failed to parse request entity from classpath: " + resourceName, e);
        }
        WFSMessage.updateVersion(doc, wfsVersion);
        return doc;
    }

    public static void updateVersion(Document doc, String wfsVersion) {
        Attr verAttr = doc.getDocumentElement().getAttributeNode("version");
        if (null != verAttr && null != wfsVersion && !wfsVersion.isEmpty()) {
            doc.getDocumentElement().getAttributeNode("version").setValue(wfsVersion);
        }
    }

    public static void setTypeName(Element elem, QName qName) {
        List<String> actions = Arrays.asList("Update", "Delete");
        if (!actions.contains(elem.getLocalName())) {
            return;
        }
        StringBuilder typeNames = new StringBuilder();
        String nsPrefix = elem.lookupPrefix(qName.getNamespaceURI());
        if (null == nsPrefix) {
            nsPrefix = elem.getOwnerDocument().lookupPrefix(qName.getNamespaceURI());
        }
        if (null == nsPrefix) {
            nsPrefix = "ns" + Integer.toString((int)(Math.random() * 100.0));
            elem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + nsPrefix, qName.getNamespaceURI());
        }
        typeNames.append(nsPrefix).append(':').append(qName.getLocalPart());
        elem.setAttribute("typeName", typeNames.toString());
    }

    public static Element newResourceIdFilter(String id) {
        Element filter = XMLUtils.createElement(new QName("http://www.opengis.net/fes/2.0", "Filter", "fes"));
        Element resourceId = XMLUtils.createElement(new QName("http://www.opengis.net/fes/2.0", "ResourceId", "fes"));
        resourceId.setAttribute("rid", id);
        filter.appendChild(filter.getOwnerDocument().adoptNode(resourceId));
        return filter;
    }

    public static void insertGMLProperty(Element feature, Element gmlProperty) {
        Document doc = feature.getOwnerDocument();
        QName gmlPropName = new QName(gmlProperty.getNamespaceURI(), gmlProperty.getLocalName());
        NodeList existing = feature.getElementsByTagNameNS(gmlPropName.getNamespaceURI(), gmlPropName.getLocalPart());
        if (existing.getLength() > 0) {
            Node oldProp = existing.item(0);
            gmlProperty.setPrefix(oldProp.getPrefix());
            feature.replaceChild(doc.adoptNode(gmlProperty), oldProp);
            return;
        }
        HashMap<QName, List<String>> followingSiblingsMap = new HashMap<QName, List<String>>();
        followingSiblingsMap.put(new QName("http://www.opengis.net/gml/3.2", "description"), Arrays.asList("descriptionReference", "identifier", "name", "boundedBy", "location"));
        followingSiblingsMap.put(new QName("http://www.opengis.net/gml/3.2", "identifier"), Arrays.asList("name", "boundedBy", "location"));
        followingSiblingsMap.put(new QName("http://www.opengis.net/gml/3.2", "name"), Arrays.asList("boundedBy", "location"));
        if (!followingSiblingsMap.containsKey(gmlPropName)) {
            return;
        }
        List followingSibs = (List)followingSiblingsMap.get(gmlPropName);
        NodeList properties = feature.getChildNodes();
        Node nextSibling = null;
        for (int i = 0; i < properties.getLength(); ++i) {
            Node property = properties.item(i);
            if (property.getNodeType() != 1) continue;
            String nsURI = property.getNamespaceURI();
            String propName = property.getLocalName();
            if (nsURI.equals("http://www.opengis.net/gml/3.2") && (!followingSibs.contains(propName) || !nsURI.equals("http://www.opengis.net/gml/3.2"))) continue;
            nextSibling = property;
            break;
        }
        if (nextSibling.getNamespaceURI().equals("http://www.opengis.net/gml/3.2")) {
            gmlProperty.setPrefix(nextSibling.getPrefix());
        } else {
            gmlProperty.setPrefix("gml");
        }
        feature.insertBefore(doc.adoptNode(gmlProperty), nextSibling);
    }

    public static Element createValueReference(XSElementDeclaration propertyElem) {
        Element valueRef = XMLUtils.createElement(new QName("http://www.opengis.net/fes/2.0", "ValueReference", "fes"));
        valueRef.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:tns", propertyElem.getNamespace());
        valueRef.setTextContent("tns:" + propertyElem.getName());
        return valueRef;
    }

    public static Document createGMLEnvelope() {
        Document doc;
        try {
            doc = BUILDER.parse(WFSMessage.class.getResourceAsStream("Envelope.xml"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return doc;
    }

    public static void addNamespaceBinding(Document doc, QName qName) {
        Element docElem = doc.getDocumentElement();
        docElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + qName.getPrefix(), qName.getNamespaceURI());
    }

    public static void addReplaceStatements(Document trxRequest, List<Element> replacements) {
        Element docElem = trxRequest.getDocumentElement();
        if (!docElem.getLocalName().equals("Transaction")) {
            throw new IllegalArgumentException("Document node is not a Transaction request: " + docElem.getNodeName());
        }
        for (Element feature : replacements) {
            Element replace = trxRequest.createElementNS("http://www.opengis.net/wfs/2.0", "Replace");
            replace.setPrefix("wfs");
            replace.appendChild(trxRequest.importNode(feature, true));
            Element filter = WFSMessage.newResourceIdFilter(feature.getAttributeNS("http://www.opengis.net/gml/3.2", "id"));
            replace.appendChild(trxRequest.adoptNode(filter));
            docElem.appendChild(replace);
        }
        if (TestSuiteLogger.isLoggable(Level.FINE)) {
            TestSuiteLogger.log(Level.FINE, XMLUtils.writeNodeToString(trxRequest));
        }
    }

    public static void addInsertStatement(Document request, Node feature) {
        Element docElem = request.getDocumentElement();
        if (!docElem.getLocalName().equals("Transaction")) {
            throw new IllegalArgumentException("Document node is not a Transaction request: " + docElem.getNodeName());
        }
        Element insert = request.createElementNS("http://www.opengis.net/wfs/2.0", "Insert");
        docElem.appendChild(insert);
        insert.appendChild(request.importNode(feature, true));
    }

    public static void addResourceIdPredicate(Document request, Set<String> idSet) {
        if (idSet.isEmpty()) {
            return;
        }
        if (!request.getDocumentElement().getLocalName().startsWith("GetFeature")) {
            throw new IllegalArgumentException("Expected a GetFeature(WithLock) request: " + request.getDocumentElement().getNodeName());
        }
        NodeList queryList = request.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "Query");
        if (queryList.getLength() == 0) {
            throw new IllegalArgumentException("No wfs:Query element found in request: " + request.getDocumentElement().getNodeName());
        }
        Element filter = request.createElementNS("http://www.opengis.net/fes/2.0", "Filter");
        queryList.item(0).appendChild(filter);
        for (String id : idSet) {
            Element resourceId = request.createElementNS("http://www.opengis.net/fes/2.0", "ResourceId");
            resourceId.setAttribute("rid", id);
            filter.appendChild(resourceId);
        }
    }

    public static boolean containsGetProtocolBinding(Object[] testParams) {
        if (null == testParams || testParams.length == 0) {
            return false;
        }
        boolean foundGetBinding = false;
        for (Object param : testParams) {
            if (!ProtocolBinding.class.isInstance(param) || !((ProtocolBinding)((Object)ProtocolBinding.class.cast(param))).equals((Object)ProtocolBinding.GET)) continue;
            foundGetBinding = true;
            break;
        }
        return foundGetBinding;
    }

    public static List<Node> findMatchingElements(Document doc, XSElementDeclaration ... elemDeclarations) {
        LOGR.log(Level.FINE, String.format("In %s, find %s", doc.getDocumentElement().getNodeName(), Arrays.toString(elemDeclarations)));
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (XSElementDeclaration decl : elemDeclarations) {
            NodeList matches = doc.getElementsByTagNameNS(decl.getNamespace(), decl.getName());
            LOGR.log(Level.FINE, String.format("Found %d instances of %s", matches.getLength(), decl));
            for (int i = 0; i < matches.getLength(); ++i) {
                nodes.add(matches.item(i));
            }
        }
        return nodes;
    }

    public static List<Node> findPropertyValues(Document doc, XSElementDeclaration propertyDecl, XSModel schema) {
        LOGR.log(Level.FINE, String.format("In %s, find values of %s", doc.getDocumentElement().getNodeName(), propertyDecl));
        XSElementDeclaration propValue = AppSchemaUtils.getComplexPropertyValue(propertyDecl);
        XSElementDeclaration[] expectedValues = new XSElementDeclaration[1];
        if (propValue.getAbstract()) {
            List allowedValues = XMLSchemaModelUtils.getElementsByAffiliation((XSModel)schema, (XSElementDeclaration)propValue);
            if (allowedValues.isEmpty()) {
                throw new AssertionError((Object)String.format("For property %s, no substitutable elements found for abstract property value: %s", propertyDecl, propValue));
            }
            expectedValues = allowedValues.toArray(expectedValues);
        } else {
            expectedValues[0] = propValue;
        }
        List<Node> valueNodes = WFSMessage.findMatchingElements(doc, expectedValues);
        return valueNodes;
    }

    public static Set<String> extractFeatureIdentifiers(Document doc, QName featureType) {
        HashSet<String> idSet = new HashSet<String>();
        if (null == featureType) {
            throw new IllegalArgumentException("featureType is null");
        }
        NodeList features = doc.getElementsByTagNameNS(featureType.getNamespaceURI(), featureType.getLocalPart());
        for (int i = 0; i < features.getLength(); ++i) {
            Element feature = (Element)features.item(i);
            idSet.add(feature.getAttributeNS("http://www.opengis.net/gml/3.2", "id"));
        }
        return idSet;
    }

    public static void addTemporalPredicate(Document request, String temporalOp, Document gmlTime, Element valueRef) {
        if (!request.getDocumentElement().getLocalName().equals("GetFeature")) {
            throw new IllegalArgumentException("Not a GetFeature request: " + request.getDocumentElement().getNodeName());
        }
        Element queryElem = (Element)request.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "Query").item(0);
        if (null == queryElem) {
            throw new IllegalArgumentException("No Query element found in GetFeature request entity.");
        }
        Element filter = request.createElementNS("http://www.opengis.net/fes/2.0", "fes:Filter");
        queryElem.appendChild(filter);
        Element predicate = request.createElementNS("http://www.opengis.net/fes/2.0", "fes:" + temporalOp);
        filter.appendChild(predicate);
        if (null != valueRef) {
            predicate.appendChild(request.importNode(valueRef, true));
        }
        predicate.appendChild(request.importNode(gmlTime.getDocumentElement(), true));
    }

    public static void setReturnTypesAndTypeNamesAttribute(Document request, QName featureTypeName) {
        if (!request.getDocumentElement().getLocalName().equals("CreateStoredQuery")) {
            throw new IllegalArgumentException("Not a CreateStoredQuery request: " + request.getDocumentElement().getNodeName());
        }
        Element storedQueryDefinition = (Element)request.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "StoredQueryDefinition").item(0);
        Element queryExpressionText = (Element)storedQueryDefinition.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "QueryExpressionText").item(0);
        Element queryElem = (Element)queryExpressionText.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "Query").item(0);
        String prefix = "ns" + Integer.toString((int)(Math.random() * 100.0));
        String typeNamesAttributeValue = prefix + ":" + featureTypeName.getLocalPart();
        queryExpressionText.setAttribute("xmlns:" + prefix, featureTypeName.getNamespaceURI());
        queryElem.setAttribute("typeNames", typeNamesAttributeValue);
        queryExpressionText.setAttribute("returnFeatureTypes", typeNamesAttributeValue);
    }

    private static Document wrapEntityInSOAPEnvelopeWithNS(Source xmlSource, String soapNS) {
        Document soapDoc = BUILDER.newDocument();
        Element soapEnv = soapDoc.createElementNS(soapNS, "soap:Envelope");
        soapDoc.appendChild(soapEnv);
        Element soapBody = soapDoc.createElementNS(soapNS, "soap:Body");
        soapEnv.appendChild(soapBody);
        WFSMessage.appendContent(xmlSource, soapDoc, soapBody);
        return soapDoc;
    }

    private static void appendContent(Source xmlSource, Document soapDoc, Element soapBody) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer idTransformer = tFactory.newTransformer();
            Document wfsReq = BUILDER.newDocument();
            idTransformer.transform(xmlSource, new DOMResult(wfsReq));
            soapBody.appendChild(soapDoc.importNode(wfsReq.getDocumentElement(), true));
        }
        catch (Exception e) {
            TestSuiteLogger.log(Level.WARNING, "Failed to create SOAP envelope from Source " + xmlSource.getSystemId(), e);
        }
    }
}

