/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import java.util.ArrayList;
import org.geotoolkit.geometry.DirectPosition2D;
import org.geotoolkit.geometry.jts.JTS;
import org.geotoolkit.gml.xml.AbstractGeometricAggregate;
import org.geotoolkit.gml.xml.AbstractGeometry;
import org.geotoolkit.gml.xml.AbstractRing;
import org.geotoolkit.gml.xml.GMLXmlFactory;
import org.geotoolkit.gml.xml.LineString;
import org.geotoolkit.gml.xml.LinearRing;
import org.geotoolkit.gml.xml.MultiPoint;
import org.geotoolkit.gml.xml.Point;
import org.geotoolkit.gml.xml.Polygon;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

public final class JTStoGeometry {
    private JTStoGeometry() {
    }

    public static AbstractGeometry toGML(String gmlVersion, Geometry jts) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem crs = JTS.findCoordinateReferenceSystem((Geometry)jts);
        return JTStoGeometry.toGML(gmlVersion, jts, crs);
    }

    public static AbstractGeometry toGML(String gmlVersion, Geometry jts, CoordinateReferenceSystem crs) throws NoSuchAuthorityCodeException, FactoryException {
        if (crs == null) {
            crs = JTS.findCoordinateReferenceSystem((Geometry)jts);
        }
        if (jts instanceof com.vividsolutions.jts.geom.Point) {
            return JTStoGeometry.toGML(gmlVersion, (com.vividsolutions.jts.geom.Point)jts, crs);
        }
        if (jts instanceof com.vividsolutions.jts.geom.LineString) {
            return JTStoGeometry.toGML(gmlVersion, (com.vividsolutions.jts.geom.LineString)jts, crs);
        }
        if (jts instanceof com.vividsolutions.jts.geom.Polygon) {
            return JTStoGeometry.toGML(gmlVersion, (com.vividsolutions.jts.geom.Polygon)jts, crs);
        }
        if (jts instanceof com.vividsolutions.jts.geom.LinearRing) {
            return JTStoGeometry.toGML(gmlVersion, (com.vividsolutions.jts.geom.LinearRing)jts, crs);
        }
        if (jts instanceof GeometryCollection) {
            return JTStoGeometry.toGML(gmlVersion, (GeometryCollection)jts, crs);
        }
        if (jts instanceof com.vividsolutions.jts.geom.MultiPoint) {
            return JTStoGeometry.toGML(gmlVersion, (com.vividsolutions.jts.geom.MultiPoint)jts, crs);
        }
        if (jts instanceof MultiLineString) {
            return JTStoGeometry.toGML(gmlVersion, (MultiLineString)jts, crs);
        }
        if (jts instanceof MultiPolygon) {
            return JTStoGeometry.toGML(gmlVersion, (MultiPolygon)jts, crs);
        }
        throw new IllegalArgumentException("Unsupported geometry type : " + jts);
    }

    public static AbstractGeometricAggregate toGML(String gmlVersion, GeometryCollection jtsGeom, CoordinateReferenceSystem crs) throws NoSuchAuthorityCodeException, FactoryException {
        Geometry geom;
        JTStoGeometry.isValideGeometry(crs);
        Class<?> buffer = null;
        if (jtsGeom.getNumGeometries() > 0 && ((geom = jtsGeom.getGeometryN(0)).getClass().isAssignableFrom(com.vividsolutions.jts.geom.Polygon.class) || geom.getClass().isAssignableFrom(com.vividsolutions.jts.geom.Point.class) || geom.getClass().isAssignableFrom(com.vividsolutions.jts.geom.LineString.class))) {
            buffer = geom.getClass();
        }
        boolean isSupported = true;
        for (int i = 0; i < jtsGeom.getNumGeometries(); ++i) {
            if (jtsGeom.getGeometryN(i).getClass().isAssignableFrom(buffer)) continue;
            isSupported = false;
            break;
        }
        if (isSupported) {
            GeometryFactory gf = new GeometryFactory();
            if (buffer.equals(com.vividsolutions.jts.geom.Point.class)) {
                ArrayList<com.vividsolutions.jts.geom.Point> ptList = new ArrayList<com.vividsolutions.jts.geom.Point>();
                for (int i = 0; i < jtsGeom.getNumGeometries(); ++i) {
                    ptList.add((com.vividsolutions.jts.geom.Point)jtsGeom.getGeometryN(i));
                }
                com.vividsolutions.jts.geom.MultiPoint mutlPt = gf.createMultiPoint(ptList.toArray(new com.vividsolutions.jts.geom.Point[ptList.size()]));
                JTS.setCRS((Geometry)mutlPt, (CoordinateReferenceSystem)crs);
                return JTStoGeometry.toGML(gmlVersion, mutlPt, crs);
            }
            if (buffer.equals(com.vividsolutions.jts.geom.LineString.class)) {
                ArrayList<com.vividsolutions.jts.geom.LineString> lsList = new ArrayList<com.vividsolutions.jts.geom.LineString>();
                for (int i = 0; i < jtsGeom.getNumGeometries(); ++i) {
                    lsList.add((com.vividsolutions.jts.geom.LineString)jtsGeom.getGeometryN(i));
                }
                MultiLineString multLineString = gf.createMultiLineString(lsList.toArray(new com.vividsolutions.jts.geom.LineString[lsList.size()]));
                JTS.setCRS((Geometry)multLineString, (CoordinateReferenceSystem)crs);
                return JTStoGeometry.toGML(gmlVersion, multLineString, crs);
            }
            if (buffer.equals(com.vividsolutions.jts.geom.Polygon.class)) {
                ArrayList<com.vividsolutions.jts.geom.Polygon> polyList = new ArrayList<com.vividsolutions.jts.geom.Polygon>();
                for (int i = 0; i < jtsGeom.getNumGeometries(); ++i) {
                    polyList.add((com.vividsolutions.jts.geom.Polygon)jtsGeom.getGeometryN(i));
                }
                MultiPolygon multPoly = gf.createMultiPolygon(polyList.toArray(new com.vividsolutions.jts.geom.Polygon[polyList.size()]));
                JTS.setCRS((Geometry)multPoly, (CoordinateReferenceSystem)crs);
                return JTStoGeometry.toGML(gmlVersion, multPoly, crs);
            }
            throw new IllegalArgumentException("Unssupported geometry type : " + jtsGeom);
        }
        throw new IllegalArgumentException("Unssupported geometry type : " + jtsGeom);
    }

    public static MultiPoint toGML(String gmlVersion, com.vividsolutions.jts.geom.MultiPoint jtsGeom, CoordinateReferenceSystem crs) throws NoSuchAuthorityCodeException, FactoryException {
        JTStoGeometry.isValideGeometry(crs);
        ArrayList<Point> pointList = new ArrayList<Point>();
        for (int i = 0; i < jtsGeom.getNumGeometries(); ++i) {
            pointList.add(JTStoGeometry.toGML(gmlVersion, (com.vividsolutions.jts.geom.Point)jtsGeom.getGeometryN(i), crs));
        }
        String srs = JTStoGeometry.getSRS(crs);
        return GMLXmlFactory.buildMultiPoint(gmlVersion, pointList, srs);
    }

    public static AbstractGeometricAggregate toGML(String gmlVersion, MultiLineString jtsGeom, CoordinateReferenceSystem crs) throws NoSuchAuthorityCodeException, FactoryException {
        JTStoGeometry.isValideGeometry(crs);
        ArrayList<LineString> lineList = new ArrayList<LineString>();
        for (int i = 0; i < jtsGeom.getNumGeometries(); ++i) {
            lineList.add(JTStoGeometry.toGML(gmlVersion, (com.vividsolutions.jts.geom.LineString)jtsGeom.getGeometryN(i), crs));
        }
        String srs = JTStoGeometry.getSRS(crs);
        return GMLXmlFactory.buildMultiLineString(gmlVersion, lineList, srs);
    }

    public static AbstractGeometricAggregate toGML(String gmlVersion, MultiPolygon jtsGeom, CoordinateReferenceSystem crs) throws NoSuchAuthorityCodeException, FactoryException {
        JTStoGeometry.isValideGeometry(crs);
        ArrayList<Polygon> polyList = new ArrayList<Polygon>();
        for (int i = 0; i < jtsGeom.getNumGeometries(); ++i) {
            polyList.add(JTStoGeometry.toGML(gmlVersion, (com.vividsolutions.jts.geom.Polygon)jtsGeom.getGeometryN(i), crs));
        }
        String srs = JTStoGeometry.getSRS(crs);
        return GMLXmlFactory.buildMultiPolygon(gmlVersion, polyList, srs);
    }

    public static Polygon toGML(String gmlVersion, com.vividsolutions.jts.geom.Polygon jtsGeom, CoordinateReferenceSystem crs) throws NoSuchAuthorityCodeException, FactoryException {
        JTStoGeometry.isValideGeometry(crs);
        LinearRing gmlExterior = JTStoGeometry.toGML(gmlVersion, (com.vividsolutions.jts.geom.LinearRing)jtsGeom.getExteriorRing(), crs);
        ArrayList<AbstractRing> gmlInterior = new ArrayList<AbstractRing>();
        for (int i = 0; i < jtsGeom.getNumInteriorRing(); ++i) {
            gmlInterior.add(JTStoGeometry.toGML(gmlVersion, (com.vividsolutions.jts.geom.LinearRing)jtsGeom.getInteriorRingN(i), crs));
        }
        return GMLXmlFactory.buildPolygon(gmlVersion, gmlExterior, gmlInterior, JTStoGeometry.getSRS(crs));
    }

    public static LineString toGML(String gmlVersion, com.vividsolutions.jts.geom.LineString jtsGeom, CoordinateReferenceSystem crs) throws NoSuchAuthorityCodeException, FactoryException {
        JTStoGeometry.isValideGeometry(crs);
        Coordinate[] jtsCoord = jtsGeom.getCoordinates();
        ArrayList<DirectPosition> dpList = new ArrayList<DirectPosition>();
        for (Coordinate c : jtsCoord) {
            dpList.add(JTStoGeometry.coordinateToDirectPosition(c, crs));
        }
        LineString gmlString = GMLXmlFactory.buildLineString(gmlVersion, dpList);
        gmlString.setSrsName(JTStoGeometry.getSRS(crs));
        return gmlString;
    }

    public static LinearRing toGML(String gmlVersion, com.vividsolutions.jts.geom.LinearRing jtsGeom, CoordinateReferenceSystem crs) throws NoSuchAuthorityCodeException, FactoryException {
        JTStoGeometry.isValideGeometry(crs);
        Coordinate[] jtsCoord = jtsGeom.getCoordinates();
        ArrayList<Double> coordList = new ArrayList<Double>();
        for (Coordinate c : jtsCoord) {
            coordList.add(c.x);
            coordList.add(c.y);
        }
        return GMLXmlFactory.buildLinearRing(gmlVersion, coordList, JTStoGeometry.getSRS(crs));
    }

    public static Point toGML(String gmlVersion, com.vividsolutions.jts.geom.Point jtsPoint, CoordinateReferenceSystem crs) throws NoSuchAuthorityCodeException, FactoryException {
        JTStoGeometry.isValideGeometry(crs);
        Point gmlPoint = GMLXmlFactory.buildPoint(gmlVersion, null, JTStoGeometry.coordinateToDirectPosition(jtsPoint.getCoordinate(), crs));
        gmlPoint.setSrsName(JTStoGeometry.getSRS(crs));
        return gmlPoint;
    }

    private static DirectPosition coordinateToDirectPosition(Coordinate coord, CoordinateReferenceSystem crs) {
        if (coord.z != Double.NaN) {
            // empty if block
        }
        return new DirectPosition2D(crs, coord.x, coord.y);
    }

    private static CoordinateReferenceSystem getCRS(Geometry jtsGeom) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem crs = JTS.findCoordinateReferenceSystem((Geometry)jtsGeom);
        if (crs == null) {
            throw new IllegalArgumentException("JTS geometry must specify a Coordinate Reference System.");
        }
        return crs;
    }

    private static void isValideGeometry(CoordinateReferenceSystem crs) {
        if (crs == null || crs.getCoordinateSystem() == null) {
            throw new IllegalArgumentException("This service support only 2D JTS Geometry (CRS null, or coordinate system null).");
        }
        if (crs.getCoordinateSystem().getDimension() != 2) {
            throw new IllegalArgumentException("This service support only 2D JTS Geometry. (CRS dimension != 2) => " + crs.getCoordinateSystem().getDimension());
        }
    }

    private static String getSRS(CoordinateReferenceSystem crs) throws FactoryException {
        String srs = null;
        String method1 = IdentifiedObjects.lookupIdentifier(Citations.URN_OGC, (IdentifiedObject)crs, (boolean)false);
        if (method1 != null) {
            srs = method1;
        } else {
            String method2 = IdentifiedObjects.getIdentifier((IdentifiedObject)crs);
            if (method2 != null) {
                srs = method2;
            } else {
                throw new IllegalArgumentException("Can't get Coordinate Reference System identifier.");
            }
        }
        return srs;
    }
}

