/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.math;

import org.geotoolkit.math.ExtrapolationException;
import org.geotoolkit.math.Search1D;

public class Polynomial1D
extends Search1D {
    public double dy;
    private final double[] c;
    private final double[] d;
    private final int[] index;

    public Polynomial1D(int n) {
        this.index = new int[n];
        this.c = new double[n];
        this.d = new double[n];
    }

    @Override
    protected double interpolate(double xi, boolean reUseIndex) throws ExtrapolationException {
        if (!reUseIndex) {
            this.copyIndexInto(this.index);
            if (this.ignoreYNaN) {
                this.validateIndex(this.index, this.y);
            }
        }
        int ns = 0;
        int vi = this.index[0];
        this.c[0] = this.d[0] = this.y[vi];
        double dif = Math.abs(xi - this.x[vi]);
        for (int i = 1; i < this.index.length; ++i) {
            vi = this.index[i];
            double dift = Math.abs(xi - this.x[vi]);
            if (dift < dif) {
                ns = i;
                dif = dift;
            }
            this.c[i] = this.d[i] = this.y[vi];
        }
        double yi = this.y[this.index[ns]];
        for (int m = 1; m < this.index.length; ++m) {
            for (int i = 0; i < this.index.length - m; ++i) {
                double ho = this.x[this.index[i]] - xi;
                double hp = this.x[this.index[i + m]] - xi;
                double w = this.c[i + 1] - this.d[i];
                double den = ho - hp;
                double deny = w / den;
                this.d[i] = hp * deny;
                this.c[i] = ho * deny;
            }
            this.dy = (float)(ns << 1 < this.index.length - m ? this.c[ns] : this.d[--ns]);
            yi += this.dy;
        }
        return yi;
    }

    public static final boolean isInRangeOf(float[] x, float xi) {
        for (int j = 0; j < x.length; ++j) {
            if (xi >= x[j]) {
                int i = x.length;
                do {
                    if (!(xi <= x[--i])) continue;
                    return true;
                } while (i > j);
                return false;
            }
            if (!(xi <= x[j])) continue;
            int i = x.length;
            do {
                if (!(xi >= x[--i])) continue;
                return true;
            } while (i > j);
            return false;
        }
        return false;
    }

    @Override
    public double[] interpolateNaN(double dxStart, double dxStop) {
        return this.interpolateNaN(dxStart, dxStop, this.index.length >= 2 ? null : this.y);
    }
}

