/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.converter;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.charset.UnsupportedCharsetException;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.CodeLists;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Locales;
import org.geotoolkit.util.SimpleInternationalString;
import org.geotoolkit.util.converter.NonconvertibleObjectException;
import org.geotoolkit.util.converter.Numbers;
import org.geotoolkit.util.converter.SimpleConverter;

@Immutable
abstract class StringConverter<T>
extends SimpleConverter<String, T>
implements Serializable {
    private static final long serialVersionUID = -3397013355582381432L;

    StringConverter() {
    }

    @Override
    public final Class<String> getSourceClass() {
        return String.class;
    }

    @Override
    public boolean hasRestrictions() {
        return true;
    }

    @Override
    public boolean isOrderPreserving() {
        return false;
    }

    @Immutable
    static final class CodeList<T extends org.opengis.util.CodeList<T>>
    extends StringConverter<T> {
        private static final long serialVersionUID = 3289083947166861278L;
        private final Class<T> targetType;

        static <T extends org.opengis.util.CodeList<T>> CodeList<T> create(Class<T> clazz) {
            return new CodeList<T>(clazz);
        }

        private CodeList(Class<T> clazz) {
            this.targetType = clazz;
        }

        @Override
        public Class<? extends T> getTargetClass() {
            return this.targetType;
        }

        @Override
        public T convert(String string) {
            if (string == null) {
                return null;
            }
            return CodeLists.valueOf(this.targetType, string);
        }
    }

    @Immutable
    static final class URL
    extends StringConverter<java.net.URL> {
        private static final long serialVersionUID = 2303928306635765592L;
        public static final URL INSTANCE = new URL();

        private URL() {
        }

        @Override
        public Class<java.net.URL> getTargetClass() {
            return java.net.URL.class;
        }

        @Override
        public java.net.URL convert(String string) throws NonconvertibleObjectException {
            if (string == null) {
                return null;
            }
            try {
                return new java.net.URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new NonconvertibleObjectException(malformedURLException);
            }
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class URI
    extends StringConverter<java.net.URI> {
        private static final long serialVersionUID = -2804405634789179706L;
        public static final URI INSTANCE = new URI();

        private URI() {
        }

        @Override
        public Class<java.net.URI> getTargetClass() {
            return java.net.URI.class;
        }

        @Override
        public java.net.URI convert(String string) throws NonconvertibleObjectException {
            if (string == null) {
                return null;
            }
            try {
                return new java.net.URI(IOUtilities.encodeURI(string));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new NonconvertibleObjectException(uRISyntaxException);
            }
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class File
    extends StringConverter<java.io.File> {
        private static final long serialVersionUID = 6445208470928432376L;
        public static final File INSTANCE = new File();

        private File() {
        }

        @Override
        public Class<java.io.File> getTargetClass() {
            return java.io.File.class;
        }

        @Override
        public java.io.File convert(String string) {
            if (string == null) {
                return null;
            }
            return new java.io.File(string);
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class InternationalString
    extends StringConverter<org.opengis.util.InternationalString> {
        private static final long serialVersionUID = 730809620191573819L;
        public static final InternationalString INSTANCE = new InternationalString();

        private InternationalString() {
        }

        @Override
        public Class<org.opengis.util.InternationalString> getTargetClass() {
            return org.opengis.util.InternationalString.class;
        }

        @Override
        public org.opengis.util.InternationalString convert(String string) {
            if (string == null) {
                return null;
            }
            return new SimpleInternationalString(string);
        }

        @Override
        public boolean hasRestrictions() {
            return false;
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class Charset
    extends StringConverter<java.nio.charset.Charset> {
        private static final long serialVersionUID = 4539755855992944656L;
        public static final Charset INSTANCE = new Charset();

        private Charset() {
        }

        @Override
        public Class<java.nio.charset.Charset> getTargetClass() {
            return java.nio.charset.Charset.class;
        }

        @Override
        public java.nio.charset.Charset convert(String string) throws NonconvertibleObjectException {
            if (string == null) {
                return null;
            }
            string = string.trim();
            try {
                return java.nio.charset.Charset.forName(string);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                throw new NonconvertibleObjectException(unsupportedCharsetException);
            }
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class Locale
    extends StringConverter<java.util.Locale> {
        private static final long serialVersionUID = -2888932450292616036L;
        public static final Locale INSTANCE = new Locale();

        private Locale() {
        }

        @Override
        public Class<java.util.Locale> getTargetClass() {
            return java.util.Locale.class;
        }

        @Override
        public java.util.Locale convert(String string) throws NonconvertibleObjectException {
            if (string == null) {
                return null;
            }
            string = string.trim();
            try {
                return Locales.parse(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new NonconvertibleObjectException(Errors.format(11, string), illegalArgumentException);
            }
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class Color
    extends StringConverter<java.awt.Color> {
        private static final long serialVersionUID = 5294622747871370401L;
        public static final Color INSTANCE = new Color();

        private Color() {
        }

        @Override
        public Class<java.awt.Color> getTargetClass() {
            return java.awt.Color.class;
        }

        @Override
        public java.awt.Color convert(String string) throws NonconvertibleObjectException {
            if (string == null) {
                return null;
            }
            string = string.trim();
            try {
                return new java.awt.Color(InternalUtilities.parseColor(string), true);
            }
            catch (NumberFormatException numberFormatException) {
                throw new NonconvertibleObjectException(numberFormatException);
            }
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class Boolean
    extends StringConverter<java.lang.Boolean> {
        private static final long serialVersionUID = -27525398425996373L;
        public static final Boolean INSTANCE = new Boolean();

        private Boolean() {
        }

        @Override
        public Class<java.lang.Boolean> getTargetClass() {
            return java.lang.Boolean.class;
        }

        @Override
        public java.lang.Boolean convert(String string) throws NonconvertibleObjectException {
            int n;
            if (string == null) {
                return null;
            }
            if ((string = string.trim()).equalsIgnoreCase("true") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("on")) {
                return java.lang.Boolean.TRUE;
            }
            if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("no") || string.equalsIgnoreCase("off")) {
                return java.lang.Boolean.FALSE;
            }
            try {
                n = java.lang.Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new NonconvertibleObjectException(numberFormatException);
            }
            return n != 0;
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class BigInteger
    extends StringConverter<java.math.BigInteger> {
        private static final long serialVersionUID = 8658903031519526466L;
        public static final BigInteger INSTANCE = new BigInteger();

        private BigInteger() {
        }

        @Override
        public Class<java.math.BigInteger> getTargetClass() {
            return java.math.BigInteger.class;
        }

        @Override
        public java.math.BigInteger convert(String string) throws NonconvertibleObjectException {
            if (string == null) {
                return null;
            }
            string = string.trim();
            try {
                return new java.math.BigInteger(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new NonconvertibleObjectException(numberFormatException);
            }
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class BigDecimal
    extends StringConverter<java.math.BigDecimal> {
        private static final long serialVersionUID = -8597497425876120213L;
        public static final BigDecimal INSTANCE = new BigDecimal();

        private BigDecimal() {
        }

        @Override
        public Class<java.math.BigDecimal> getTargetClass() {
            return java.math.BigDecimal.class;
        }

        @Override
        public java.math.BigDecimal convert(String string) throws NonconvertibleObjectException {
            if (string == null) {
                return null;
            }
            string = string.trim();
            try {
                return new java.math.BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new NonconvertibleObjectException(numberFormatException);
            }
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class Byte
    extends StringConverter<java.lang.Byte> {
        private static final long serialVersionUID = 2084870859391804185L;
        public static final Byte INSTANCE = new Byte();

        private Byte() {
        }

        @Override
        public Class<java.lang.Byte> getTargetClass() {
            return java.lang.Byte.class;
        }

        @Override
        public java.lang.Byte convert(String string) throws NonconvertibleObjectException {
            if (string == null) {
                return null;
            }
            string = string.trim();
            try {
                return java.lang.Byte.parseByte(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new NonconvertibleObjectException(numberFormatException);
            }
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class Short
    extends StringConverter<java.lang.Short> {
        private static final long serialVersionUID = -1770870328699572960L;
        public static final Short INSTANCE = new Short();

        private Short() {
        }

        @Override
        public Class<java.lang.Short> getTargetClass() {
            return java.lang.Short.class;
        }

        @Override
        public java.lang.Short convert(String string) throws NonconvertibleObjectException {
            if (string == null) {
                return null;
            }
            string = string.trim();
            try {
                return java.lang.Short.parseShort(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new NonconvertibleObjectException(numberFormatException);
            }
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class Integer
    extends StringConverter<java.lang.Integer> {
        private static final long serialVersionUID = 763211364703205967L;
        public static final Integer INSTANCE = new Integer();

        private Integer() {
        }

        @Override
        public Class<java.lang.Integer> getTargetClass() {
            return java.lang.Integer.class;
        }

        @Override
        public java.lang.Integer convert(String string) throws NonconvertibleObjectException {
            if (string == null) {
                return null;
            }
            string = string.trim();
            try {
                return java.lang.Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new NonconvertibleObjectException(numberFormatException);
            }
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class Long
    extends StringConverter<java.lang.Long> {
        private static final long serialVersionUID = -2171263041723939779L;
        public static final Long INSTANCE = new Long();

        private Long() {
        }

        @Override
        public Class<java.lang.Long> getTargetClass() {
            return java.lang.Long.class;
        }

        @Override
        public java.lang.Long convert(String string) throws NonconvertibleObjectException {
            if (string == null) {
                return null;
            }
            string = string.trim();
            try {
                return java.lang.Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new NonconvertibleObjectException(numberFormatException);
            }
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class Float
    extends StringConverter<java.lang.Float> {
        private static final long serialVersionUID = -2815192289550338333L;
        public static final Float INSTANCE = new Float();

        private Float() {
        }

        @Override
        public Class<java.lang.Float> getTargetClass() {
            return java.lang.Float.class;
        }

        @Override
        public java.lang.Float convert(String string) throws NonconvertibleObjectException {
            if (string == null) {
                return null;
            }
            string = string.trim();
            try {
                return java.lang.Float.valueOf(java.lang.Float.parseFloat(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new NonconvertibleObjectException(numberFormatException);
            }
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class Double
    extends StringConverter<java.lang.Double> {
        private static final long serialVersionUID = -9094071164371643060L;
        public static final Double INSTANCE = new Double();

        private Double() {
        }

        @Override
        public Class<java.lang.Double> getTargetClass() {
            return java.lang.Double.class;
        }

        @Override
        public java.lang.Double convert(String string) throws NonconvertibleObjectException {
            if (string == null) {
                return null;
            }
            string = string.trim();
            try {
                return java.lang.Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new NonconvertibleObjectException(numberFormatException);
            }
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class Number
    extends StringConverter<java.lang.Number> {
        private static final long serialVersionUID = 1557277544742023571L;
        public static final Number INSTANCE = new Number();

        private Number() {
        }

        @Override
        public Class<java.lang.Number> getTargetClass() {
            return java.lang.Number.class;
        }

        @Override
        public java.lang.Number convert(String string) throws NonconvertibleObjectException {
            if (string == null) {
                return null;
            }
            string = string.trim();
            try {
                return Numbers.finestNumber(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new NonconvertibleObjectException(numberFormatException);
            }
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }
}

