/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.simple;

import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import java.util.Collections;
import java.util.UUID;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import org.opengis.cite.iso19142.BaseFixture;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.SuiteAttribute;
import org.opengis.cite.iso19142.util.DataSampler;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.ValidationUtils;
import org.opengis.cite.iso19142.util.WFSMessage;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.opengis.cite.validation.SchematronValidator;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

public class StoredQueryTests
extends BaseFixture {
    private Schema wfsSchema;
    private String queryId;
    private DataSampler dataSampler;

    @BeforeClass
    public void initClassFixture(ITestContext testContext) {
        this.wfsSchema = (Schema)testContext.getSuite().getAttribute(SuiteAttribute.WFS_SCHEMA.getName());
        Assert.assertNotNull((Object)this.wfsSchema, (String)"WFS schema not found in suite fixture.");
        this.queryId = this.wfsVersion.equals("2.0.0") ? "urn:ogc:def:query:OGC-WFS::GetFeatureById" : "http://www.opengis.net/def/query/OGC-WFS/0/GetFeatureById";
        this.dataSampler = (DataSampler)testContext.getSuite().getAttribute(SuiteAttribute.SAMPLER.getName());
    }

    @BeforeMethod
    public void buildGetFeatureRequestEntity() {
        this.reqEntity = WFSMessage.createRequestEntity("GetFeature", this.wfsVersion);
    }

    @Test(description="See ISO 19142: 7.9.3.4", dataProvider="protocol-binding")
    public void unknownStoredQuery(ProtocolBinding binding) {
        WFSMessage.appendStoredQuery(this.reqEntity, "http://docbook.org/ns/docbook", Collections.emptyMap());
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "GetFeature", binding);
        ClientResponse rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), binding, endpoint);
        this.rspEntity = this.extractBodyAsDocument(rsp);
        Assert.assertTrue((boolean)rsp.hasEntity(), (String)ErrorMessage.get("MissingXMLEntity"));
        SchematronValidator validator = ValidationUtils.buildSchematronValidator("ExceptionReport.sch", "InvalidParameterValuePhase");
        Result result = validator.validate((Source)new DOMSource(this.rspEntity), false);
        Assert.assertFalse((boolean)validator.ruleViolationsDetected(), (String)ErrorMessage.format("NotSchemaValid", validator.getRuleViolationCount(), XMLUtils.resultToString(result)));
    }

    @Test(description="See ISO 19142: 7.9.3.6, 11.4", dataProvider="protocol-binding")
    public void invokeGetFeatureByIdWithUnknownID(ProtocolBinding binding) {
        String id = "uuid-" + UUID.randomUUID().toString();
        WFSMessage.appendStoredQuery(this.reqEntity, this.queryId, Collections.singletonMap("id", id));
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "GetFeature", binding);
        ClientResponse rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), binding, endpoint);
        this.rspEntity = this.extractBodyAsDocument(rsp);
        int statusCode = rsp.getStatus();
        if (this.wfsVersion.equals("2.0.0")) {
            Assert.assertTrue((statusCode == ClientResponse.Status.NOT_FOUND.getStatusCode() || statusCode == ClientResponse.Status.FORBIDDEN.getStatusCode() ? 1 : 0) != 0, (String)("Expected status code 404 or 403. Received: " + statusCode));
        } else {
            Assert.assertTrue((statusCode == ClientResponse.Status.INTERNAL_SERVER_ERROR.getStatusCode() || statusCode == ClientResponse.Status.BAD_REQUEST.getStatusCode() || statusCode == ClientResponse.Status.FORBIDDEN.getStatusCode() ? 1 : 0) != 0, (String)"UnexpectedStatus");
        }
    }

    @Test(description="See ISO 19142: 7.9.3.6", dataProvider="protocol-binding")
    public void invokeGetFeatureById(ProtocolBinding binding) {
        String featureIdToRequest = this.dataSampler.getFeatureId();
        Assert.assertTrue((featureIdToRequest != null && !featureIdToRequest.isEmpty() ? 1 : 0) != 0, (String)ErrorMessage.get("FidNotFound"));
        WFSMessage.appendStoredQuery(this.reqEntity, this.queryId, Collections.singletonMap("id", featureIdToRequest));
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "GetFeature", binding);
        ClientResponse rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), binding, endpoint);
        this.rspEntity = this.extractBodyAsDocument(rsp);
        Assert.assertTrue((boolean)rsp.hasEntity(), (String)ErrorMessage.get("MissingXMLEntity"));
        Element feature = this.rspEntity.getDocumentElement();
        Assert.assertEquals((String)feature.getAttributeNS("http://www.opengis.net/gml/3.2", "id"), (String)featureIdToRequest, (String)ErrorMessage.get("UnexpectedIdentifier"));
    }
}

