/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.parameter;

import java.util.Map;
import net.jcip.annotations.Immutable;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;

@Immutable
public abstract class AbstractParameterDescriptor
extends AbstractIdentifiedObject
implements GeneralParameterDescriptor {
    private static final long serialVersionUID = -2630644278783845276L;
    private final int minimumOccurs;

    protected AbstractParameterDescriptor(GeneralParameterDescriptor generalParameterDescriptor) {
        super(generalParameterDescriptor);
        this.minimumOccurs = generalParameterDescriptor.getMinimumOccurs();
    }

    protected AbstractParameterDescriptor(Map<String, ?> map, int n, int n2) {
        super(map);
        this.minimumOccurs = n;
        if (n < 0 || n2 < n) {
            throw new IllegalArgumentException(Errors.format((int)14, (Object)n, (Object)n2));
        }
    }

    @Override
    public abstract GeneralParameterValue createValue();

    @Override
    public int getMinimumOccurs() {
        return this.minimumOccurs;
    }

    @Override
    public abstract int getMaximumOccurs();

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (super.equals(object, comparisonMode)) {
            switch (comparisonMode) {
                case STRICT: {
                    AbstractParameterDescriptor abstractParameterDescriptor = (AbstractParameterDescriptor)object;
                    return this.minimumOccurs == abstractParameterDescriptor.minimumOccurs;
                }
            }
            GeneralParameterDescriptor generalParameterDescriptor = (GeneralParameterDescriptor)object;
            return this.getMinimumOccurs() == generalParameterDescriptor.getMinimumOccurs() && this.getMaximumOccurs() == generalParameterDescriptor.getMaximumOccurs();
        }
        return false;
    }

    @Override
    protected int computeHashCode() {
        return Utilities.hash((int)this.minimumOccurs, (int)super.computeHashCode());
    }

    @Override
    public String formatWKT(Formatter formatter) {
        formatter.setInvalidWKT(GeneralParameterDescriptor.class);
        return "PARAMETER";
    }
}

