/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.crs;

import java.util.Map;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.CRSUtilities;
import org.geotoolkit.internal.referencing.NilReferencingObject;
import org.geotoolkit.internal.referencing.Semaphores;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.referencing.crs.AbstractSingleCRS;
import org.geotoolkit.referencing.crs.UnprefixedMap;
import org.geotoolkit.referencing.operation.DefaultConversion;
import org.geotoolkit.referencing.operation.DefaultOperationMethod;
import org.geotoolkit.referencing.operation.DefaultSingleOperation;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.Projection;

@Immutable
public class AbstractDerivedCRS
extends AbstractSingleCRS
implements GeneralDerivedCRS {
    private static final long serialVersionUID = -175151161496419854L;
    public static final String CONVERSION_TYPE_KEY = "conversionType";
    protected final CoordinateReferenceSystem baseCRS;
    protected final Conversion conversionFromBase;

    private AbstractDerivedCRS() {
        this(NilReferencingObject.INSTANCE);
    }

    protected AbstractDerivedCRS(GeneralDerivedCRS generalDerivedCRS) {
        super(generalDerivedCRS);
        this.baseCRS = generalDerivedCRS.getBaseCRS();
        this.conversionFromBase = generalDerivedCRS.getConversionFromBase();
    }

    protected AbstractDerivedCRS(Map<String, ?> map, Conversion conversion, CoordinateReferenceSystem coordinateReferenceSystem, MathTransform mathTransform, CoordinateSystem coordinateSystem) throws MismatchedDimensionException {
        super(map, CRSUtilities.getDatum(coordinateReferenceSystem), coordinateSystem);
        ArgumentChecks.ensureNonNull((String)"conversionFromBase", (Object)conversion);
        ArgumentChecks.ensureNonNull((String)"baseToDerived", (Object)mathTransform);
        this.baseCRS = coordinateReferenceSystem;
        AbstractDerivedCRS.checkDimensions(coordinateReferenceSystem, mathTransform, coordinateSystem);
        DefaultOperationMethod.checkDimensions(conversion.getMethod(), mathTransform);
        Class clazz = (Class)map.get(CONVERSION_TYPE_KEY);
        Class<? extends Conversion> clazz2 = this.getConversionType();
        if (clazz != null) {
            clazz2 = clazz.asSubclass(clazz2);
        }
        this.conversionFromBase = DefaultConversion.create(conversion, coordinateReferenceSystem, this, mathTransform, clazz2);
    }

    protected AbstractDerivedCRS(Map<String, ?> map, CoordinateReferenceSystem coordinateReferenceSystem, MathTransform mathTransform, CoordinateSystem coordinateSystem) throws MismatchedDimensionException {
        super(map, CRSUtilities.getDatum(coordinateReferenceSystem), coordinateSystem);
        ArgumentChecks.ensureNonNull((String)"baseToDerived", (Object)mathTransform);
        this.baseCRS = coordinateReferenceSystem;
        AbstractDerivedCRS.checkDimensions(coordinateReferenceSystem, mathTransform, coordinateSystem);
        DefaultOperationMethod defaultOperationMethod = new DefaultOperationMethod(mathTransform);
        DefaultOperationMethod.checkDimensions(defaultOperationMethod, mathTransform);
        this.conversionFromBase = (Conversion)DefaultSingleOperation.create(new UnprefixedMap(map, "conversion."), coordinateReferenceSystem, this, mathTransform, defaultOperationMethod, this instanceof ProjectedCRS ? Projection.class : Conversion.class);
    }

    private static void checkDimensions(CoordinateReferenceSystem coordinateReferenceSystem, MathTransform mathTransform, CoordinateSystem coordinateSystem) throws MismatchedDimensionException {
        int n = mathTransform.getSourceDimensions();
        int n2 = mathTransform.getTargetDimensions();
        int n3 = n;
        int n4 = coordinateReferenceSystem.getCoordinateSystem().getDimension();
        if (n3 != n4 || (n3 = n2) != (n4 = coordinateSystem.getDimension())) {
            throw new MismatchedDimensionException(Errors.format((int)112, (Object)n3, (Object)n4));
        }
    }

    @Override
    public CoordinateReferenceSystem getBaseCRS() {
        return this.baseCRS;
    }

    @Override
    public Conversion getConversionFromBase() {
        return this.conversionFromBase;
    }

    Class<? extends Conversion> getConversionType() {
        return Conversion.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        boolean bl;
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode) && Utilities.deepEquals((Object)((bl = comparisonMode == ComparisonMode.STRICT) ? this.baseCRS : this.getBaseCRS()), (Object)(bl ? ((AbstractDerivedCRS)object).baseCRS : ((GeneralDerivedCRS)object).getBaseCRS()), (ComparisonMode)comparisonMode)) {
            if (Semaphores.queryAndSet(1)) {
                return true;
            }
            try {
                boolean bl2 = Utilities.deepEquals((Object)(bl ? this.conversionFromBase : this.getConversionFromBase()), (Object)(bl ? ((AbstractDerivedCRS)object).conversionFromBase : ((GeneralDerivedCRS)object).getConversionFromBase()), (ComparisonMode)comparisonMode);
                return bl2;
            }
            finally {
                Semaphores.clear(1);
            }
        }
        return false;
    }

    @Override
    protected int computeHashCode() {
        return Utilities.hash((Object)this.baseCRS, (int)Utilities.hash((Object)this.conversionFromBase.getMathTransform(), (int)super.computeHashCode()));
    }

    @Override
    public String formatWKT(Formatter formatter) {
        MathTransform mathTransform = this.conversionFromBase.getMathTransform();
        try {
            mathTransform = mathTransform.inverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new IllegalStateException(noninvertibleTransformException.getLocalizedMessage(), noninvertibleTransformException);
        }
        formatter.append(mathTransform);
        formatter.append(this.baseCRS);
        return "FITTED_CS";
    }
}

