/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.jts.transform;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import org.geotoolkit.geometry.jts.coordinatesequence.LiteCoordinateSequence;
import org.geotoolkit.geometry.jts.transform.AbstractGeometryTransformer;
import org.opengis.referencing.operation.TransformException;

public class GeometryScaleTransformer
extends AbstractGeometryTransformer {
    private final double resX;
    private final double resY;

    public GeometryScaleTransformer(double resX, double resY) {
        this.resX = resX;
        this.resY = resY;
    }

    @Override
    public CoordinateSequence transform(CoordinateSequence cs, int minpoints) {
        Coordinate[] coords = cs.toCoordinateArray();
        Coordinate[] deci = this.decimate(coords, minpoints);
        if (deci.length == coords.length) {
            return cs;
        }
        return this.csf.create(deci);
    }

    private Coordinate[] decimate(Coordinate[] coords, int minpoint) {
        int lenght = 1;
        boolean closed = coords[0].equals2D(coords[coords.length - 1]);
        int j = 0;
        for (int i = 1; i < coords.length; ++i) {
            double distX = Math.abs(coords[j].x - coords[i].x);
            if (distX > this.resX) {
                ++lenght;
                coords[++j] = coords[i];
                continue;
            }
            double distY = Math.abs(coords[j].y - coords[i].y);
            if (!(distY > this.resY)) continue;
            ++lenght;
            coords[++j] = coords[i];
        }
        if (lenght == coords.length) {
            return coords;
        }
        if (lenght < minpoint) {
            Coordinate lastCoord = coords[coords.length - 1];
            for (int i = lenght; i < minpoint; ++i) {
                coords[i] = lastCoord;
            }
            lenght = minpoint;
        }
        if (closed && !coords[0].equals2D(coords[lenght - 1])) {
            coords[lenght] = new Coordinate(coords[0]);
            ++lenght;
        }
        Coordinate[] cs = new Coordinate[lenght];
        System.arraycopy(coords, 0, cs, 0, lenght);
        return cs;
    }

    @Override
    public Point transform(Point geom) throws TransformException {
        return geom;
    }

    @Override
    protected MultiPoint transform(MultiPoint geom) throws TransformException {
        int nbGeom = geom.getNumGeometries();
        if (nbGeom == 1) {
            return geom;
        }
        LiteCoordinateSequence cs = new LiteCoordinateSequence(nbGeom, 2);
        for (int i = 0; i < nbGeom; ++i) {
            Coordinate coord = geom.getGeometryN(i).getCoordinate();
            cs.setX(i, coord.x);
            cs.setY(i, coord.y);
        }
        return this.gf.createMultiPoint(this.transform((CoordinateSequence)cs, 1));
    }
}

