/*
 * Decompiled with CFR 0.152.
 */
package javax.measure;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import javax.measure.Measure;
import javax.measure.unit.CompoundUnit;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MeasureFormat
extends Format {
    private static final long serialVersionUID = -4628006924354248662L;
    private static final NumberSpaceUnit DEFAULT = new NumberSpaceUnit(NumberFormat.getInstance(), UnitFormat.getInstance());
    private static final Standard STANDARD = new Standard();

    public static MeasureFormat getInstance() {
        return DEFAULT;
    }

    public static MeasureFormat getInstance(NumberFormat numberFormat, UnitFormat unitFormat) {
        return new NumberSpaceUnit(numberFormat, unitFormat);
    }

    public static MeasureFormat getStandard() {
        return STANDARD;
    }

    public abstract Appendable format(Measure<?> var1, Appendable var2) throws IOException;

    public abstract Measure<?> parse(CharSequence var1, ParsePosition var2) throws IllegalArgumentException;

    protected Appendable formatCompound(double value, CompoundUnit<?> unit, Appendable dest) throws IOException {
        Unit<?> high = unit.getHigh();
        Unit<?> low = unit.getLow();
        long highValue = (long)low.getConverterTo(high).convert(value);
        double lowValue = value - high.getConverterTo(low).convert(highValue);
        if (high instanceof CompoundUnit) {
            this.formatCompound(highValue, (CompoundUnit)high, dest);
        } else {
            dest.append(DEFAULT._numberFormat.format(highValue));
            DEFAULT._unitFormat.format(high, dest);
        }
        dest.append(DEFAULT._numberFormat.format(lowValue));
        return DEFAULT._unitFormat.format(low, dest);
    }

    @Override
    public final StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (!(obj instanceof Measure)) {
            throw new IllegalArgumentException("obj: Not an instance of Measure");
        }
        if (toAppendTo == null || pos == null) {
            throw new NullPointerException();
        }
        try {
            return (StringBuffer)this.format((Measure)obj, toAppendTo);
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    @Override
    public final Measure<?> parseObject(String source, ParsePosition pos) {
        try {
            return this.parse(source, pos);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public final StringBuilder format(Measure<?> measure, StringBuilder dest) {
        try {
            return (StringBuilder)this.format(measure, (Appendable)dest);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Standard
    extends MeasureFormat {
        private static final long serialVersionUID = 2758248665095734058L;

        private Standard() {
        }

        public Appendable format(Measure measure, Appendable dest) throws IOException {
            Unit unit = measure.getUnit();
            if (unit instanceof CompoundUnit) {
                return this.formatCompound(measure.doubleValue(unit), (CompoundUnit)unit, dest);
            }
            BigDecimal decimal = measure.decimalValue(unit, MathContext.UNLIMITED);
            dest.append(decimal.toString());
            if (measure.getUnit().equals(Unit.ONE)) {
                return dest;
            }
            dest.append(' ');
            return UnitFormat.getStandard().format(unit, dest);
        }

        @Override
        public Measure<?> parse(CharSequence csq, ParsePosition cursor) throws IllegalArgumentException {
            int endDecimal;
            int startDecimal;
            for (startDecimal = cursor.getIndex(); startDecimal < csq.length() && Character.isWhitespace(csq.charAt(startDecimal)); ++startDecimal) {
            }
            for (endDecimal = startDecimal + 1; endDecimal < csq.length() && !Character.isWhitespace(csq.charAt(endDecimal)); ++endDecimal) {
            }
            BigDecimal decimal = new BigDecimal(((Object)csq.subSequence(startDecimal, endDecimal)).toString());
            cursor.setIndex(endDecimal + 1);
            Unit<?> unit = UnitFormat.getStandard().parse(csq, cursor);
            return Measure.valueOf(decimal, unit);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NumberSpaceUnit
    extends MeasureFormat {
        private final NumberFormat _numberFormat;
        private final UnitFormat _unitFormat;
        private static final long serialVersionUID = 1L;

        private NumberSpaceUnit(NumberFormat numberFormat, UnitFormat unitFormat) {
            this._numberFormat = numberFormat;
            this._unitFormat = unitFormat;
        }

        @Override
        public Appendable format(Measure<?> measure, Appendable dest) throws IOException {
            Unit<?> unit = measure.getUnit();
            if (unit instanceof CompoundUnit) {
                return this.formatCompound(measure.doubleValue(unit), (CompoundUnit)unit, dest);
            }
            dest.append(this._numberFormat.format(measure.getValue()));
            if (measure.getUnit().equals(Unit.ONE)) {
                return dest;
            }
            dest.append(' ');
            return this._unitFormat.format(measure.getUnit(), dest);
        }

        @Override
        public Measure<?> parse(CharSequence csq, ParsePosition cursor) throws IllegalArgumentException {
            String str = ((Object)csq).toString();
            Number number = this._numberFormat.parse(str, cursor);
            if (number == null) {
                throw new IllegalArgumentException("Number cannot be parsed");
            }
            Unit<?> unit = this._unitFormat.parse(csq, cursor);
            if (number instanceof BigDecimal) {
                return Measure.valueOf((BigDecimal)number, unit);
            }
            if (number instanceof Long) {
                return Measure.valueOf((Long)number, unit);
            }
            if (number instanceof Double) {
                return Measure.valueOf((Double)number, unit);
            }
            throw new UnsupportedOperationException("Number of type " + number.getClass() + " are not supported");
        }
    }
}

