/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.sql;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Collection;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.metadata.sql.MetadataException;
import org.geotoolkit.metadata.sql.MetadataSource;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.converter.Classes;

@ThreadSafe
final class MetadataHandler
implements InvocationHandler {
    private final String identifier;
    private final MetadataSource source;

    public MetadataHandler(String string, MetadataSource metadataSource) {
        this.identifier = string;
        this.source = metadataSource;
    }

    private static void checkArgumentCount(Object[] objectArray, int n) {
        int n2;
        int n3 = n2 = objectArray != null ? objectArray.length : 0;
        if (n2 != n) {
            Object object;
            int n4;
            if (n2 == 0) {
                n4 = 119;
                object = "arg";
            } else {
                n4 = 210;
                object = objectArray[0];
            }
            throw new MetadataException(Errors.format((int)n4, (Object)object));
        }
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) {
        Class<?> clazz = method.getDeclaringClass();
        if (this.source.standard.isMetadata(clazz)) {
            MetadataHandler.checkArgumentCount(objectArray, 0);
            try {
                return this.source.getValue(clazz, method, this.identifier);
            }
            catch (SQLException sQLException) {
                Class clazz2;
                Class clazz3 = method.getReturnType();
                if (Collection.class.isAssignableFrom(clazz3) && (clazz2 = Classes.boundOfParameterizedAttribute((Method)method)) != null) {
                    clazz3 = clazz2;
                }
                throw new MetadataException(Errors.format((int)46, (Object)clazz3, (Object)this.identifier), sQLException);
            }
        }
        String string = method.getName();
        switch (string.hashCode()) {
            case -1618432855: {
                if (!string.equals("identifier")) break;
                MetadataHandler.checkArgumentCount(objectArray, 1);
                return objectArray[0] == this.source ? this.identifier : null;
            }
            case -1295482945: {
                if (!string.equals("equals")) break;
                MetadataHandler.checkArgumentCount(objectArray, 1);
                return object == objectArray[0];
            }
            case -1776922004: {
                if (!string.equals("toString")) break;
                MetadataHandler.checkArgumentCount(objectArray, 0);
                return this.toString(clazz);
            }
            case 147696667: {
                if (!string.equals("hashCode")) break;
                MetadataHandler.checkArgumentCount(objectArray, 0);
                return System.identityHashCode(object);
            }
        }
        throw new MetadataException(Errors.format((int)83, (Object)string));
    }

    private String toString(Class<?> clazz) {
        return Classes.getShortName(clazz) + "[id=\"" + this.identifier + "\"]";
    }

    public String toString() {
        return this.toString(this.getClass());
    }

    public boolean equals(Object object) {
        if (object instanceof MetadataHandler) {
            MetadataHandler metadataHandler = (MetadataHandler)object;
            return this.source == metadataHandler.source && this.identifier.equals(metadataHandler.identifier);
        }
        return false;
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }
}

