/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory.wkt;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.geotoolkit.io.wkt.WKTFormat;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.collection.BackingStoreException;
import org.opengis.referencing.IdentifiedObject;

final class SpatialRefSysMap
extends AbstractMap<String, String> {
    final Connection connection;
    private final String schema;
    private transient PreparedStatement selectPK;
    private transient PreparedStatement select;

    public SpatialRefSysMap(Connection connection) throws SQLException {
        this.connection = connection;
        ResultSet resultSet = connection.getMetaData().getTables(null, null, "spatial_ref_sys", new String[]{"TABLE"});
        String string = null;
        if (resultSet.next()) {
            string = resultSet.getString("TABLE_SCHEM");
        }
        resultSet.close();
        this.schema = string;
    }

    private StringBuilder appendFrom(StringBuilder stringBuilder) {
        stringBuilder.append(" FROM ");
        if (this.schema != null) {
            stringBuilder.append(this.schema).append('.');
        }
        return stringBuilder.append("spatial_ref_sys");
    }

    Map<String, Boolean> getAuthorityNames() throws SQLException {
        StringBuilder stringBuilder = new StringBuilder("SELECT ").append("auth_name").append(", SUM(CASE WHEN ").append("auth_srid").append('=').append("srid").append(" THEN 1 ELSE 0 END) AS np, COUNT(").append("auth_name").append(") AS n");
        this.appendFrom(stringBuilder).append(" GROUP BY ").append("auth_name").append(" ORDER BY np DESC, n DESC");
        LinkedHashMap<String, Boolean> linkedHashMap = new LinkedHashMap<String, Boolean>();
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = statement.executeQuery(stringBuilder.toString());
        while (resultSet.next()) {
            int n;
            String string = resultSet.getString(1);
            int n2 = resultSet.getInt(2);
            linkedHashMap.put(string, n2 == (n = resultSet.getInt(3)));
        }
        resultSet.close();
        statement.close();
        return linkedHashMap;
    }

    Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> clazz) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder("SELECT CASE WHEN ").append("auth_srid").append('=').append("srid").append(" THEN ").append("srid").append("::text ELSE ").append("auth_name").append(" || '").append(':').append("' || ").append("auth_srid").append(" END AS code");
        this.appendFrom(stringBuilder);
        String string = WKTFormat.getNameOf(clazz);
        if (string != null) {
            stringBuilder.append(" WHERE srtext ILIKE '").append(string).append("%'");
        }
        stringBuilder.append(" ORDER BY ").append("srid");
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = statement.executeQuery(stringBuilder.toString());
        while (resultSet.next()) {
            linkedHashSet.add(resultSet.getString(1));
        }
        resultSet.close();
        statement.close();
        return linkedHashSet;
    }

    Integer getPrimaryKey(String string, String string2, int n) throws SQLException {
        if (this.selectPK == null) {
            StringBuilder stringBuilder = new StringBuilder("SELECT ").append("srid");
            this.appendFrom(stringBuilder).append(" WHERE ").append("auth_name").append("=?").append(" AND ").append("auth_srid").append("=?");
            this.selectPK = this.connection.prepareStatement(stringBuilder.toString());
        }
        this.selectPK.setString(1, string2);
        this.selectPK.setInt(2, n);
        return SpatialRefSysMap.singleton(this.selectPK, Integer.class, string);
    }

    private static <T> T singleton(PreparedStatement preparedStatement, Class<T> clazz, String string) throws SQLException {
        T t = null;
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            Object object = Integer.class.isAssignableFrom(clazz) ? Integer.valueOf(resultSet.getInt(1)) : resultSet.getString(1);
            if (resultSet.wasNull()) continue;
            if (t != null && !object.equals(t)) {
                resultSet.close();
                throw new SQLIntegrityConstraintViolationException(Errors.format((int)55, (Object)string));
            }
            t = clazz.cast(object);
        }
        resultSet.close();
        return t;
    }

    @Override
    public String get(Object object) throws BackingStoreException {
        int n = (Integer)object;
        try {
            if (this.select == null) {
                StringBuilder stringBuilder = new StringBuilder("SELECT ").append("srtext");
                this.appendFrom(stringBuilder).append(" WHERE ").append("srid").append("=?");
                this.select = this.connection.prepareStatement(stringBuilder.toString());
            }
            this.select.setInt(1, n);
            return SpatialRefSysMap.singleton(this.select, String.class, object.toString());
        }
        catch (SQLException sQLException) {
            throw new BackingStoreException((Throwable)sQLException);
        }
    }

    @Override
    public boolean containsKey(Object object) throws BackingStoreException {
        return this.get(object) != null;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        throw new UnsupportedOperationException();
    }

    void dispose() throws SQLException {
        if (this.select != null) {
            this.select.close();
            this.select = null;
        }
        if (this.selectPK != null) {
            this.selectPK.close();
            this.selectPK = null;
        }
        this.connection.close();
    }
}

