/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.io;

import java.io.IOException;
import java.io.Writer;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.io.FilterWriter;
import org.geotoolkit.util.ArgumentChecks;

@ThreadSafe
public class LineWrapWriter
extends FilterWriter {
    public static final char HYPHEN = '\u2010';
    public static final char SOFT_HYPHEN = '\u00ad';
    private static final char ESCAPE = '\u001b';
    private static final char IGNORE_AFTER_ESCAPE = '[';
    private final String lineSeparator = System.getProperty("line.separator", "\n");
    private int maximalLineLength = 80;
    private int length;
    private boolean escape;
    private final StringBuilder buffer = new StringBuilder();

    public LineWrapWriter(Writer writer) {
        super(writer);
    }

    public LineWrapWriter(Writer writer, int n) {
        super(writer);
        this.setMaximalLineLength(n);
    }

    public int getMaximalLineLength() {
        return this.maximalLineLength;
    }

    public void setMaximalLineLength(int n) {
        ArgumentChecks.ensureStrictlyPositive("length", n);
        this.maximalLineLength = n;
    }

    private static void deleteSoftHyphen(StringBuilder stringBuilder) {
        int n = stringBuilder.length();
        while (--n >= 0) {
            if (stringBuilder.charAt(n) != '\u00ad') continue;
            stringBuilder.deleteCharAt(n);
        }
    }

    private void doWrite(int n) throws IOException {
        assert (Thread.holdsLock(this.lock));
        StringBuilder stringBuilder = this.buffer;
        switch (n) {
            case 10: 
            case 13: {
                LineWrapWriter.deleteSoftHyphen(stringBuilder);
                this.out.append(stringBuilder).write(n);
                stringBuilder.setLength(0);
                this.length = 0;
                this.escape = false;
                return;
            }
            case 27: {
                stringBuilder.append('\u001b');
                this.escape = true;
                return;
            }
        }
        if (Character.isSpaceChar(n)) {
            LineWrapWriter.deleteSoftHyphen(stringBuilder);
            this.out.append(stringBuilder);
            stringBuilder.setLength(0);
            this.escape = false;
        }
        stringBuilder.append((char)n);
        if (this.escape) {
            if (n < 48 || n > 57) {
                int n2;
                if (n == 91 && (n2 = stringBuilder.length() - 2) >= 0 && stringBuilder.charAt(n2) == '\u001b') {
                    return;
                }
                this.escape = false;
            }
            return;
        }
        if (++this.length > this.maximalLineLength) {
            int n3 = stringBuilder.length();
            block8: while (--n3 >= 1) {
                switch (stringBuilder.charAt(n3)) {
                    case '-': {
                        if (!Character.isLetter(stringBuilder.charAt(n3 - 1))) continue block8;
                    }
                    case '\u00ad': 
                    case '\u2010': {
                        this.out.append(stringBuilder.substring(0, ++n3));
                        stringBuilder.delete(0, n3);
                        break block8;
                    }
                    default: {
                        continue block8;
                    }
                }
            }
            this.out.write(this.lineSeparator);
            this.length = stringBuilder.length();
            for (n3 = 0; n3 < this.length; ++n3) {
                if (Character.isSpaceChar(stringBuilder.charAt(n3))) continue;
                stringBuilder.delete(0, n3);
                this.length -= n3;
                return;
            }
            stringBuilder.setLength(0);
            this.length = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.doWrite(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            while (--n2 >= 0) {
                this.doWrite(cArray[n++]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String string, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            while (--n2 >= 0) {
                this.doWrite(string.charAt(n++));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.append(this.buffer);
            this.buffer.setLength(0);
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.append(this.buffer);
            this.buffer.setLength(0);
            this.out.close();
        }
    }
}

