/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util;

import java.util.Arrays;
import org.geotoolkit.lang.Static;

public class Ranks
extends Static {
    private final int index;

    private Ranks(int n) {
        this.index = n;
    }

    public static <T extends Comparable<T>> int[] ranks(T[] TArray, T[] TArray2) {
        if (TArray == null) {
            return null;
        }
        Ranks[] ranksArray = new Any[TArray.length];
        for (int i = 0; i < ranksArray.length; ++i) {
            ranksArray[i] = new Any<T>(i, TArray[i]);
        }
        int[] nArray = Ranks.ranks(ranksArray);
        if (TArray2 != null) {
            int n = Math.min(ranksArray.length, TArray2.length);
            while (--n >= 0) {
                TArray2[n] = ((Any)ranksArray[n]).value;
            }
        }
        return nArray;
    }

    public static int[] ranks(double[] dArray, double[] dArray2) {
        if (dArray == null) {
            return null;
        }
        Ranks[] ranksArray = new Double[dArray.length];
        for (int i = 0; i < ranksArray.length; ++i) {
            ranksArray[i] = new Double(i, dArray[i]);
        }
        int[] nArray = Ranks.ranks(ranksArray);
        if (dArray2 != null) {
            int n = Math.min(ranksArray.length, dArray2.length);
            while (--n >= 0) {
                dArray2[n] = ((Double)ranksArray[n]).value;
            }
        }
        return nArray;
    }

    public static int[] ranks(float[] fArray, float[] fArray2) {
        if (fArray == null) {
            return null;
        }
        Ranks[] ranksArray = new Float[fArray.length];
        for (int i = 0; i < ranksArray.length; ++i) {
            ranksArray[i] = new Float(i, fArray[i]);
        }
        int[] nArray = Ranks.ranks(ranksArray);
        if (fArray2 != null) {
            int n = Math.min(ranksArray.length, fArray2.length);
            while (--n >= 0) {
                fArray2[n] = ((Float)ranksArray[n]).value;
            }
        }
        return nArray;
    }

    public static int[] ranks(long[] lArray, long[] lArray2) {
        if (lArray == null) {
            return null;
        }
        Ranks[] ranksArray = new Long[lArray.length];
        for (int i = 0; i < ranksArray.length; ++i) {
            ranksArray[i] = new Long(i, lArray[i]);
        }
        int[] nArray = Ranks.ranks(ranksArray);
        if (lArray2 != null) {
            int n = Math.min(ranksArray.length, lArray2.length);
            while (--n >= 0) {
                lArray2[n] = ((Long)ranksArray[n]).value;
            }
        }
        return nArray;
    }

    public static int[] ranks(int[] nArray, int[] nArray2) {
        if (nArray == null) {
            return null;
        }
        Ranks[] ranksArray = new Integer[nArray.length];
        for (int i = 0; i < ranksArray.length; ++i) {
            ranksArray[i] = new Integer(i, nArray[i]);
        }
        int[] nArray3 = Ranks.ranks(ranksArray);
        if (nArray2 != null) {
            int n = Math.min(ranksArray.length, nArray2.length);
            while (--n >= 0) {
                nArray2[n] = ((Integer)ranksArray[n]).value;
            }
        }
        return nArray3;
    }

    public static int[] ranks(short[] sArray, short[] sArray2) {
        if (sArray == null) {
            return null;
        }
        Ranks[] ranksArray = new Short[sArray.length];
        for (int i = 0; i < ranksArray.length; ++i) {
            ranksArray[i] = new Short(i, sArray[i]);
        }
        int[] nArray = Ranks.ranks(ranksArray);
        if (sArray2 != null) {
            int n = Math.min(ranksArray.length, sArray2.length);
            while (--n >= 0) {
                sArray2[n] = ((Short)ranksArray[n]).value;
            }
        }
        return nArray;
    }

    public static int[] ranks(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return null;
        }
        Ranks[] ranksArray = new Byte[byArray.length];
        for (int i = 0; i < ranksArray.length; ++i) {
            ranksArray[i] = new Byte(i, byArray[i]);
        }
        int[] nArray = Ranks.ranks(ranksArray);
        if (byArray2 != null) {
            int n = Math.min(ranksArray.length, byArray2.length);
            while (--n >= 0) {
                byArray2[n] = ((Byte)ranksArray[n]).value;
            }
        }
        return nArray;
    }

    private static int[] ranks(Ranks[] ranksArray) {
        Arrays.sort(ranksArray);
        int[] nArray = new int[ranksArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = ranksArray[i].index;
        }
        return nArray;
    }

    private static final class Byte
    extends Ranks
    implements Comparable<Byte> {
        private final byte value;

        Byte(int n, byte by) {
            super(n);
            this.value = by;
        }

        @Override
        public int compareTo(Byte byteVal) {
            return this.value - byteVal.value;
        }
    }

    private static final class Short
    extends Ranks
    implements Comparable<Short> {
        private final short value;

        Short(int n, short s) {
            super(n);
            this.value = s;
        }

        @Override
        public int compareTo(Short shortVal) {
            return this.value - shortVal.value;
        }
    }

    private static final class Integer
    extends Ranks
    implements Comparable<Integer> {
        private final int value;

        Integer(int n, int n2) {
            super(n);
            this.value = n2;
        }

        @Override
        public int compareTo(Integer integer) {
            return this.value < integer.value ? -1 : (this.value == integer.value ? 0 : 1);
        }
    }

    private static final class Long
    extends Ranks
    implements Comparable<Long> {
        private final long value;

        Long(int n, long l) {
            super(n);
            this.value = l;
        }

        @Override
        public int compareTo(Long longVal) {
            return this.value < longVal.value ? -1 : (this.value == longVal.value ? 0 : 1);
        }
    }

    private static final class Float
    extends Ranks
    implements Comparable<Float> {
        private final float value;

        Float(int n, float f) {
            super(n);
            this.value = f;
        }

        @Override
        public int compareTo(Float float_) {
            return java.lang.Float.compare(this.value, float_.value);
        }
    }

    private static final class Double
    extends Ranks
    implements Comparable<Double> {
        private final double value;

        Double(int n, double d) {
            super(n);
            this.value = d;
        }

        @Override
        public int compareTo(Double double_) {
            return java.lang.Double.compare(this.value, double_.value);
        }
    }

    private static final class Any<T extends Comparable<T>>
    extends Ranks
    implements Comparable<Any<T>> {
        private final T value;

        Any(int n, T t) {
            super(n);
            this.value = t;
        }

        @Override
        public int compareTo(Any<T> any) {
            return this.value.compareTo(any.value);
        }
    }
}

