/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.geotoolkit.factory.Factory;
import org.geotoolkit.gml.xml.v311.TimeInstantType;
import org.geotoolkit.gml.xml.v311.TimePeriodType;
import org.geotoolkit.gml.xml.v311.TimePositionType;
import org.geotoolkit.gts.xml.PeriodDurationType;
import org.geotoolkit.temporal.factory.DefaultTemporalFactory;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Period;
import org.opengis.temporal.PeriodDuration;
import org.opengis.temporal.Position;
import org.opengis.util.InternationalString;

public class GMLTemporalFactory
extends DefaultTemporalFactory {
    @Override
    protected void setOrdering(Factory.Organizer orgnzr) {
        orgnzr.before(DefaultTemporalFactory.class, false);
    }

    @Override
    public Instant createInstant(Position pstn) {
        if (pstn != null) {
            return new TimeInstantType(pstn);
        }
        return null;
    }

    @Override
    public Period createPeriod(Instant begin, Instant end) {
        Position beginPosition = null;
        if (begin != null) {
            beginPosition = begin.getPosition();
        }
        Position endPosition = null;
        if (end != null) {
            endPosition = end.getPosition();
        }
        return new TimePeriodType(beginPosition, endPosition);
    }

    @Override
    public Position createPosition(Date date) {
        if (date != null) {
            return new TimePositionType(date);
        }
        return null;
    }

    @Override
    public PeriodDuration createPeriodDuration(InternationalString years, InternationalString months, InternationalString week, InternationalString days, InternationalString hours, InternationalString minutes, InternationalString seconds) {
        BigInteger iyears = null;
        if (years != null) {
            iyears = new BigInteger(((Object)years).toString());
        }
        BigInteger imonths = null;
        if (months != null) {
            imonths = new BigInteger(((Object)months).toString());
        }
        BigInteger idays = null;
        if (days != null) {
            idays = new BigInteger(((Object)days).toString());
        }
        BigInteger ihours = null;
        if (hours != null) {
            ihours = new BigInteger(((Object)hours).toString());
        }
        BigInteger iminutes = null;
        if (minutes != null) {
            iminutes = new BigInteger(((Object)minutes).toString());
        }
        BigDecimal iseconds = null;
        if (seconds != null) {
            iseconds = new BigDecimal(((Object)seconds).toString());
        }
        return new PeriodDurationType(true, iyears, imonths, idays, ihours, iminutes, iseconds);
    }
}

