/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlTransient;
import org.geotoolkit.gml.xml.TimeIndeterminateValueType;
import org.geotoolkit.util.logging.Logging;
import org.opengis.temporal.Position;
import org.opengis.temporal.TemporalPosition;

@XmlTransient
public abstract class AbstractTimePosition
implements Position {
    protected static final Logger LOGGER = Logging.getLogger(AbstractTimePosition.class);
    protected static final List<DateFormat> FORMATTERS = new ArrayList<DateFormat>();

    @Override
    public TemporalPosition anyOther() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date parseDate(String value) {
        if (value != null && !value.isEmpty()) {
            for (DateFormat df : FORMATTERS) {
                try {
                    DateFormat dateFormat = df;
                    synchronized (dateFormat) {
                        return df.parse(value);
                    }
                }
                catch (ParseException ex) {
                }
            }
        }
        LOGGER.log(Level.WARNING, "Unable to parse date value:{0}", value);
        return null;
    }

    public abstract TimeIndeterminateValueType getIndeterminatePosition();

    static {
        FORMATTERS.add(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"));
        FORMATTERS.add(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        FORMATTERS.add(new SimpleDateFormat("yyyy-MM-dd"));
    }
}

