/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.identification;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.resources.Errors;
import org.opengis.metadata.identification.RepresentativeFraction;

@ThreadSafe
@XmlType(name="MD_RepresentativeFraction_Type")
@XmlRootElement(name="MD_RepresentativeFraction")
public class DefaultRepresentativeFraction
extends Number
implements RepresentativeFraction {
    private static final long serialVersionUID = 7228422109144637537L;
    private long denominator;

    public DefaultRepresentativeFraction() {
    }

    public DefaultRepresentativeFraction(RepresentativeFraction representativeFraction) {
        if (representativeFraction != null) {
            this.denominator = representativeFraction.getDenominator();
        }
    }

    public DefaultRepresentativeFraction(long l) {
        this.denominator = l;
    }

    public static DefaultRepresentativeFraction castOrCopy(RepresentativeFraction representativeFraction) {
        return representativeFraction == null || representativeFraction instanceof DefaultRepresentativeFraction ? (DefaultRepresentativeFraction)representativeFraction : new DefaultRepresentativeFraction(representativeFraction);
    }

    public static RepresentativeFraction fromScale(double d) throws IllegalArgumentException {
        if (Math.abs(d) <= 1.0 || d == Double.POSITIVE_INFINITY) {
            return new DefaultRepresentativeFraction(Math.round(1.0 / d));
        }
        throw new IllegalArgumentException(Errors.format(73, "scale", d));
    }

    @Override
    public synchronized double doubleValue() {
        return 1.0 / (double)this.denominator;
    }

    @Override
    public synchronized float floatValue() {
        return 1.0f / (float)this.denominator;
    }

    @Override
    public long longValue() throws ArithmeticException {
        return this.intValue();
    }

    @Override
    public synchronized int intValue() throws ArithmeticException {
        if (this.denominator == 1L) {
            return 1;
        }
        if (this.denominator != 0L) {
            return 0;
        }
        throw new ArithmeticException();
    }

    @Override
    @XmlElement(name="denominator", required=true)
    public synchronized long getDenominator() {
        return this.denominator;
    }

    public synchronized void setDenominator(long l) {
        this.denominator = l;
    }

    @Override
    public synchronized boolean equals(Object object) {
        if (object instanceof RepresentativeFraction) {
            RepresentativeFraction representativeFraction = (RepresentativeFraction)object;
            return this.denominator == representativeFraction.getDenominator();
        }
        return false;
    }

    @Override
    public synchronized int hashCode() {
        return (int)this.denominator;
    }
}

