/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.parameter;

import java.net.URI;
import javax.measure.converter.ConversionException;
import javax.measure.unit.Unit;
import org.geotoolkit.parameter.AbstractParameterValue;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.XArrays;
import org.opengis.parameter.InvalidParameterTypeException;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;

public class FloatParameter
extends AbstractParameterValue<Double> {
    private static final long serialVersionUID = 9027797654033417816L;
    private double value;
    private Unit<?> unit;

    public FloatParameter(ParameterDescriptor<Double> parameterDescriptor) {
        super(parameterDescriptor);
        Class<Double> clazz = parameterDescriptor.getValueClass();
        Class<Double> clazz2 = Double.class;
        if (!clazz2.equals(clazz) && !Double.TYPE.equals(clazz)) {
            throw new IllegalArgumentException(Errors.format(76, clazz, clazz2));
        }
        this.value = FloatParameter.defaultValue(parameterDescriptor);
        this.unit = parameterDescriptor.getUnit();
    }

    private static double defaultValue(ParameterDescriptor<Double> parameterDescriptor) {
        Number number = parameterDescriptor.getDefaultValue();
        return number != null ? number.doubleValue() : Double.NaN;
    }

    public FloatParameter(ParameterDescriptor<Double> parameterDescriptor, double d) {
        this(parameterDescriptor);
        this.setValue(d);
    }

    @Override
    public Unit<?> getUnit() {
        return this.unit;
    }

    @Override
    public double doubleValue(Unit<?> unit) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("unit", unit);
        Unit<?> unit2 = this.getUnit();
        if (unit2 == null) {
            throw FloatParameter.unitlessParameter(this.descriptor);
        }
        int n = FloatParameter.getUnitMessageID(unit2);
        if (FloatParameter.getUnitMessageID(unit) != n) {
            throw new IllegalArgumentException(Errors.format(n, unit));
        }
        try {
            return unit2.getConverterToAny(unit).convert(this.doubleValue());
        }
        catch (ConversionException conversionException) {
            throw new IllegalArgumentException(Errors.format(92, unit), conversionException);
        }
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public int intValue() throws IllegalStateException {
        double d = this.doubleValue();
        int n = (int)d;
        if ((double)n == d) {
            return n;
        }
        String string = FloatParameter.getName(this.descriptor);
        if (Double.isNaN(d)) {
            throw new IllegalStateException(Errors.format(119, string));
        }
        throw new InvalidParameterTypeException(FloatParameter.getClassTypeError(), string);
    }

    @Override
    public boolean booleanValue() throws IllegalStateException {
        double d = this.doubleValue();
        if (Double.isNaN(d)) {
            throw new IllegalStateException(Errors.format(119, FloatParameter.getName(this.descriptor)));
        }
        return d != 0.0;
    }

    @Override
    public String stringValue() throws IllegalStateException {
        double d = this.doubleValue();
        if (Double.isNaN(d)) {
            throw new IllegalStateException(Errors.format(119, FloatParameter.getName(this.descriptor)));
        }
        return String.valueOf(d);
    }

    @Override
    public double[] doubleValueList(Unit<?> unit) throws IllegalArgumentException {
        double[] dArray;
        double d = this.doubleValue(unit);
        if (Double.isNaN(d)) {
            dArray = XArrays.EMPTY_DOUBLE;
        } else {
            double[] dArray2 = new double[1];
            dArray = dArray2;
            dArray2[0] = d;
        }
        return dArray;
    }

    @Override
    public double[] doubleValueList() {
        double[] dArray;
        double d = this.doubleValue();
        if (Double.isNaN(d)) {
            dArray = XArrays.EMPTY_DOUBLE;
        } else {
            double[] dArray2 = new double[1];
            dArray = dArray2;
            dArray2[0] = d;
        }
        return dArray;
    }

    @Override
    public int[] intValueList() throws InvalidParameterTypeException {
        return new int[]{this.intValue()};
    }

    @Override
    public URI valueFile() throws InvalidParameterTypeException {
        throw new InvalidParameterTypeException(FloatParameter.getClassTypeError(), FloatParameter.getName(this.descriptor));
    }

    private static String getClassTypeError() {
        return Errors.format(87, Double.class);
    }

    @Override
    public Double getValue() {
        double d = this.doubleValue();
        return Double.isNaN(d) ? null : Double.valueOf(d);
    }

    @Override
    public void setValue(double d, Unit<?> unit) throws InvalidParameterValueException {
        double d2 = d;
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)this.descriptor;
        Unit<?> unit2 = parameterDescriptor.getUnit();
        if (unit2 != unit) {
            if (unit2 == null) {
                throw FloatParameter.unitlessParameter(parameterDescriptor);
            }
            ArgumentChecks.ensureNonNull("unit", unit);
            int n = FloatParameter.getUnitMessageID(unit2);
            if (FloatParameter.getUnitMessageID(unit) != n) {
                throw new InvalidParameterValueException(Errors.format(n, unit), parameterDescriptor.getName().getCode(), d);
            }
            try {
                d2 = unit.getConverterToAny(unit2).convert(d);
            }
            catch (ConversionException conversionException) {
                throw new IllegalArgumentException(Errors.format(92, unit), conversionException);
            }
        }
        if (Double.isNaN(d)) {
            this.value = FloatParameter.defaultValue(parameterDescriptor);
        } else {
            FloatParameter.ensureValidValue(parameterDescriptor, d2);
            this.value = d;
        }
        this.unit = unit;
        this.fireValueChanged();
    }

    @Override
    public void setValue(double d) throws InvalidParameterValueException {
        this.setValue(d, this.unit);
    }

    @Override
    public void setValue(int n) throws InvalidParameterValueException {
        this.setValue((double)n);
    }

    @Override
    public void setValue(boolean bl) throws InvalidParameterValueException {
        this.setValue(bl ? 1.0 : 0.0);
    }

    @Override
    public void setValue(Object object) throws InvalidParameterValueException {
        double d;
        if (object == null) {
            d = Double.NaN;
        } else if (object instanceof Number) {
            d = ((Number)object).doubleValue();
        } else {
            throw new InvalidParameterValueException(FloatParameter.getClassTypeError(), FloatParameter.getName(this.descriptor), object);
        }
        this.setValue(d);
    }

    @Override
    public void setValue(double[] dArray, Unit<?> unit) throws InvalidParameterValueException {
        ArgumentChecks.ensureNonNull("values", dArray);
        if (dArray.length != 1) {
            throw new InvalidParameterValueException(FloatParameter.getClassTypeError(), FloatParameter.getName(this.descriptor), dArray);
        }
        this.setValue(dArray[0], unit);
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            FloatParameter floatParameter = (FloatParameter)object;
            return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(floatParameter.value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Utilities.hash(this.value, super.hashCode());
    }

    @Override
    public FloatParameter clone() {
        return (FloatParameter)super.clone();
    }
}

