/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing;

import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.geotoolkit.factory.AuthorityFactoryFinder;
import org.geotoolkit.factory.Factories;
import org.geotoolkit.factory.Factory;
import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.factory.FactoryNotFoundException;
import org.geotoolkit.factory.FactoryRegistryException;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.geometry.Envelopes;
import org.geotoolkit.geometry.GeneralEnvelope;
import org.geotoolkit.internal.referencing.AxisDirections;
import org.geotoolkit.internal.referencing.CRSUtilities;
import org.geotoolkit.lang.Static;
import org.geotoolkit.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.geotoolkit.referencing.DefaultAuthorityFactory;
import org.geotoolkit.referencing.crs.DefaultCompoundCRS;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.geotoolkit.referencing.crs.DefaultVerticalCRS;
import org.geotoolkit.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotoolkit.referencing.cs.DefaultEllipsoidalCS;
import org.geotoolkit.referencing.operation.MathTransforms;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.Version;
import org.geotoolkit.util.logging.Logging;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.Geometry;
import org.opengis.metadata.extent.BoundingPolygon;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class CRS
extends Static {
    private static volatile CRSFactory crsFactory;
    private static volatile CRSAuthorityFactory standardFactory;
    private static volatile CRSAuthorityFactory xyFactory;
    private static volatile CoordinateOperationFactory strictFactory;
    private static volatile CoordinateOperationFactory lenientFactory;
    private static volatile Boolean defaultOrder;
    private static volatile Boolean defaultLenient;

    private CRS() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CRSFactory getCRSFactory() {
        CRSFactory cRSFactory = crsFactory;
        if (cRSFactory != null) return cRSFactory;
        Class<CRS> clazz = CRS.class;
        synchronized (CRS.class) {
            cRSFactory = crsFactory;
            if (cRSFactory != null) return cRSFactory;
            crsFactory = cRSFactory = FactoryFinder.getCRSFactory(null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cRSFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CRSAuthorityFactory getAuthorityFactory(Boolean bl) throws FactoryRegistryException {
        CRSAuthorityFactory cRSAuthorityFactory;
        if (bl == null && (bl = defaultOrder) == null) {
            defaultOrder = bl = Boolean.valueOf(Boolean.TRUE.equals(Hints.getSystemDefault(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER)));
        }
        CRSAuthorityFactory cRSAuthorityFactory2 = cRSAuthorityFactory = bl != false ? xyFactory : standardFactory;
        if (cRSAuthorityFactory != null) return cRSAuthorityFactory;
        Class<CRS> clazz = CRS.class;
        synchronized (CRS.class) {
            CRSAuthorityFactory cRSAuthorityFactory3 = cRSAuthorityFactory = bl != false ? xyFactory : standardFactory;
            if (cRSAuthorityFactory != null) return cRSAuthorityFactory;
            try {
                cRSAuthorityFactory = DefaultAuthorityFactory.create(bl);
                if (bl.booleanValue()) {
                    xyFactory = cRSAuthorityFactory;
                } else {
                    standardFactory = cRSAuthorityFactory;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new FactoryNotFoundException(null, noSuchElementException);
            }
            return cRSAuthorityFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CoordinateOperationFactory getCoordinateOperationFactory(boolean bl) {
        CoordinateOperationFactory coordinateOperationFactory;
        CoordinateOperationFactory coordinateOperationFactory2 = coordinateOperationFactory = bl ? lenientFactory : strictFactory;
        if (coordinateOperationFactory != null) return coordinateOperationFactory;
        Class<CRS> clazz = CRS.class;
        synchronized (CRS.class) {
            CoordinateOperationFactory coordinateOperationFactory3 = coordinateOperationFactory = bl ? lenientFactory : strictFactory;
            if (coordinateOperationFactory != null) return coordinateOperationFactory;
            Hints hints = new Hints();
            if (bl) {
                hints.put(Hints.LENIENT_DATUM_SHIFT, Boolean.TRUE);
            }
            coordinateOperationFactory = FactoryFinder.getCoordinateOperationFactory(hints);
            if (bl) {
                lenientFactory = coordinateOperationFactory;
            } else {
                strictFactory = coordinateOperationFactory;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return coordinateOperationFactory;
        }
    }

    public static Version getVersion(String string) throws FactoryRegistryException {
        Factory factory;
        ArgumentChecks.ensureNonNull("authority", string);
        CRSAuthorityFactory cRSAuthorityFactory = AuthorityFactoryFinder.getCRSAuthorityFactory(string, null);
        HashSet<Factory> hashSet = new HashSet<Factory>();
        while (cRSAuthorityFactory instanceof Factory && hashSet.add(factory = (Factory)((Object)cRSAuthorityFactory))) {
            Map<RenderingHints.Key, ?> map = factory.getImplementationHints();
            Object obj = map.get(Hints.VERSION);
            if (obj instanceof Version) {
                return (Version)obj;
            }
            cRSAuthorityFactory = map.get(Hints.CRS_AUTHORITY_FACTORY);
        }
        return null;
    }

    public static Set<String> getSupportedCodes(String string) {
        ArgumentChecks.ensureNonNull("authority", string);
        return DefaultAuthorityFactory.getSupportedCodes(string);
    }

    public static Set<String> getSupportedAuthorities(boolean bl) {
        return DefaultAuthorityFactory.getSupportedAuthorities(bl);
    }

    public static CoordinateReferenceSystem decode(String string) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull("code", string);
        return CRS.getAuthorityFactory(null).createCoordinateReferenceSystem(string);
    }

    public static CoordinateReferenceSystem decode(String string, boolean bl) throws NoSuchAuthorityCodeException, FactoryException {
        ArgumentChecks.ensureNonNull("code", string);
        return CRS.getAuthorityFactory(bl).createCoordinateReferenceSystem(string);
    }

    public static CoordinateReferenceSystem parseWKT(String string) throws FactoryException {
        ArgumentChecks.ensureNonNull("wkt", string);
        return CRS.getCRSFactory().createFromWKT(string);
    }

    public static Envelope getEnvelope(CoordinateReferenceSystem coordinateReferenceSystem) {
        Object object;
        Envelope envelope = null;
        GeneralEnvelope generalEnvelope = null;
        if (coordinateReferenceSystem != null && (object = coordinateReferenceSystem.getDomainOfValidity()) != null) {
            for (GeographicExtent object2 : object.getGeographicElements()) {
                if (Boolean.FALSE.equals(object2.getInclusion()) || !(object2 instanceof BoundingPolygon)) continue;
                for (Geometry geometry : ((BoundingPolygon)object2).getPolygons()) {
                    CoordinateReferenceSystem coordinateReferenceSystem2;
                    Envelope envelope2 = geometry.getEnvelope();
                    if (envelope2 == null || (coordinateReferenceSystem2 = envelope2.getCoordinateReferenceSystem()) != null && !CRS.equalsIgnoreMetadata(coordinateReferenceSystem2, coordinateReferenceSystem)) continue;
                    if (envelope == null) {
                        envelope = envelope2;
                        continue;
                    }
                    if (generalEnvelope == null) {
                        envelope = generalEnvelope = new GeneralEnvelope(envelope);
                    }
                    generalEnvelope.add(envelope);
                }
            }
        }
        if (envelope == null && (object = CRS.getGeographicBoundingBox(coordinateReferenceSystem)) != null && !Boolean.FALSE.equals(object.getInclusion())) {
            envelope = generalEnvelope = new GeneralEnvelope(new double[]{object.getWestBoundLongitude(), object.getSouthBoundLatitude()}, new double[]{object.getEastBoundLongitude(), object.getNorthBoundLatitude()});
            SingleCRS singleCRS = CRS.getHorizontalCRS(coordinateReferenceSystem);
            GeographicCRS geographicCRS = CRSUtilities.getStandardGeographicCRS2D(singleCRS);
            generalEnvelope.setCoordinateReferenceSystem(geographicCRS);
            try {
                envelope = CRS.transform(envelope, singleCRS);
            }
            catch (TransformException transformException) {
                envelope = null;
                CRS.unexpectedException("getEnvelope", transformException);
            }
            generalEnvelope.setCoordinateReferenceSystem(singleCRS);
        }
        return envelope;
    }

    public static GeographicBoundingBox getGeographicBoundingBox(CoordinateReferenceSystem coordinateReferenceSystem) {
        Extent extent;
        GeographicBoundingBox geographicBoundingBox = null;
        DefaultGeographicBoundingBox defaultGeographicBoundingBox = null;
        if (coordinateReferenceSystem != null && (extent = coordinateReferenceSystem.getDomainOfValidity()) != null) {
            for (GeographicExtent geographicExtent : extent.getGeographicElements()) {
                if (!(geographicExtent instanceof GeographicBoundingBox)) continue;
                GeographicBoundingBox geographicBoundingBox2 = (GeographicBoundingBox)geographicExtent;
                if (geographicBoundingBox == null) {
                    geographicBoundingBox = geographicBoundingBox2;
                    continue;
                }
                if (defaultGeographicBoundingBox == null) {
                    defaultGeographicBoundingBox = new DefaultGeographicBoundingBox(geographicBoundingBox);
                    geographicBoundingBox = defaultGeographicBoundingBox;
                }
                defaultGeographicBoundingBox.add(geographicBoundingBox2);
            }
        }
        return geographicBoundingBox;
    }

    public static boolean isHorizontalCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        Datum datum;
        int n;
        if (coordinateReferenceSystem instanceof SingleCRS && (n = coordinateReferenceSystem.getCoordinateSystem().getDimension()) == 2 && (datum = ((SingleCRS)coordinateReferenceSystem).getDatum()) instanceof GeodeticDatum) {
            while (coordinateReferenceSystem instanceof GeneralDerivedCRS) {
                coordinateReferenceSystem = ((GeneralDerivedCRS)coordinateReferenceSystem).getBaseCRS();
            }
            return coordinateReferenceSystem instanceof GeographicCRS;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static SingleCRS getHorizontalCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        IdentifiedObject identifiedObject;
        IdentifiedObject identifiedObject2;
        if (coordinateReferenceSystem instanceof SingleCRS) {
            identifiedObject2 = coordinateReferenceSystem.getCoordinateSystem();
            int n = identifiedObject2.getDimension();
            if (n == 2) {
                Datum identifiedObject3 = ((SingleCRS)coordinateReferenceSystem).getDatum();
                if (identifiedObject3 instanceof GeodeticDatum) {
                    identifiedObject = coordinateReferenceSystem;
                    while (identifiedObject instanceof GeneralDerivedCRS) {
                        identifiedObject = ((GeneralDerivedCRS)identifiedObject).getBaseCRS();
                    }
                    if (identifiedObject instanceof GeographicCRS) {
                        assert (CRS.isHorizontalCRS(coordinateReferenceSystem)) : coordinateReferenceSystem;
                        return (SingleCRS)coordinateReferenceSystem;
                    }
                }
            } else if (n >= 3 && coordinateReferenceSystem instanceof GeographicCRS) {
                Object object;
                Object var3_5 = null;
                identifiedObject = null;
                int n2 = 0;
                block9: for (int i = 0; i < n; ++i) {
                    object = identifiedObject2.getAxis(i);
                    if (!DefaultCoordinateSystemAxis.isCompassDirection(object.getDirection())) continue;
                    switch (n2++) {
                        case 0: {
                            CoordinateSystemAxis coordinateSystemAxis = object;
                            continue block9;
                        }
                        case 1: {
                            identifiedObject = object;
                            continue block9;
                        }
                    }
                }
                if (n2 == 2) {
                    GeographicCRS geographicCRS;
                    EllipsoidalCS ellipsoidalCS;
                    void var3_6;
                    GeodeticDatum geodeticDatum = ((GeographicCRS)coordinateReferenceSystem).getDatum();
                    object = CRSUtilities.changeDimensionInName(identifiedObject2, "3D", "2D");
                    try {
                        ellipsoidalCS = FactoryFinder.getCSFactory(null).createEllipsoidalCS((Map<String, ?>)object, (CoordinateSystemAxis)var3_6, (CoordinateSystemAxis)identifiedObject);
                    }
                    catch (FactoryException factoryException) {
                        Logging.recoverableException(CRS.class, "getHorizontalCRS", factoryException);
                        ellipsoidalCS = new DefaultEllipsoidalCS((Map<String, ?>)object, (CoordinateSystemAxis)var3_6, (CoordinateSystemAxis)identifiedObject);
                    }
                    object = CRSUtilities.changeDimensionInName(coordinateReferenceSystem, "3D", "2D");
                    try {
                        geographicCRS = CRS.getCRSFactory().createGeographicCRS((Map<String, ?>)object, geodeticDatum, ellipsoidalCS);
                    }
                    catch (FactoryException factoryException) {
                        Logging.recoverableException(CRS.class, "getHorizontalCRS", factoryException);
                        geographicCRS = new DefaultGeographicCRS((Map<String, ?>)object, geodeticDatum, ellipsoidalCS);
                    }
                    assert (CRS.isHorizontalCRS(geographicCRS)) : geographicCRS;
                    return geographicCRS;
                }
            }
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            identifiedObject2 = (CompoundCRS)coordinateReferenceSystem;
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : identifiedObject2.getComponents()) {
                identifiedObject = CRS.getHorizontalCRS(coordinateReferenceSystem2);
                if (identifiedObject == null) continue;
                assert (CRS.isHorizontalCRS(identifiedObject)) : identifiedObject;
                return identifiedObject;
            }
        }
        return null;
    }

    public static ProjectedCRS getProjectedCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (coordinateReferenceSystem instanceof ProjectedCRS) {
            return (ProjectedCRS)coordinateReferenceSystem;
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            CompoundCRS compoundCRS = (CompoundCRS)coordinateReferenceSystem;
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : compoundCRS.getComponents()) {
                ProjectedCRS projectedCRS = CRS.getProjectedCRS(coordinateReferenceSystem2);
                if (projectedCRS == null) continue;
                return projectedCRS;
            }
        }
        return null;
    }

    public static VerticalCRS getVerticalCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        IdentifiedObject identifiedObject;
        if (coordinateReferenceSystem instanceof VerticalCRS) {
            return (VerticalCRS)coordinateReferenceSystem;
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            identifiedObject = (CompoundCRS)coordinateReferenceSystem;
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : identifiedObject.getComponents()) {
                VerticalCRS verticalCRS = CRS.getVerticalCRS(coordinateReferenceSystem2);
                if (verticalCRS == null) continue;
                return verticalCRS;
            }
        }
        if (coordinateReferenceSystem instanceof GeographicCRS && (identifiedObject = coordinateReferenceSystem.getCoordinateSystem()).getDimension() >= 3) {
            assert (AxisDirections.indexOf((CoordinateSystem)identifiedObject, AxisDirection.UP) >= 0) : identifiedObject;
            return DefaultVerticalCRS.ELLIPSOIDAL_HEIGHT;
        }
        return null;
    }

    public static TemporalCRS getTemporalCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (coordinateReferenceSystem instanceof TemporalCRS) {
            return (TemporalCRS)coordinateReferenceSystem;
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            CompoundCRS compoundCRS = (CompoundCRS)coordinateReferenceSystem;
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : compoundCRS.getComponents()) {
                TemporalCRS temporalCRS = CRS.getTemporalCRS(coordinateReferenceSystem2);
                if (temporalCRS == null) continue;
                return temporalCRS;
            }
        }
        return null;
    }

    public static CompoundCRS getCompoundCRS(CompoundCRS compoundCRS, SingleCRS ... singleCRSArray) {
        Object object;
        List<SingleCRS> list = DefaultCompoundCRS.getSingleCRS(compoundCRS);
        if (list.size() == singleCRSArray.length) {
            int n = 0;
            SingleCRS[] object2 = (SingleCRS[])singleCRSArray.clone();
            object = list.iterator();
            block0: while (object.hasNext()) {
                SingleCRS singleCRS = object.next();
                for (int i = n; i < object2.length; ++i) {
                    if (!CRS.equalsIgnoreMetadata(singleCRS, object2[i])) continue;
                    System.arraycopy(object2, n, object2, n + 1, i - n);
                    object2[n++] = null;
                    continue block0;
                }
                n = -1;
                break;
            }
            if (n == object2.length) {
                return compoundCRS;
            }
        }
        for (CoordinateReferenceSystem coordinateReferenceSystem : compoundCRS.getComponents()) {
            if (!(coordinateReferenceSystem instanceof CompoundCRS) || (object = CRS.getCompoundCRS((CompoundCRS)coordinateReferenceSystem, singleCRSArray)) == null) continue;
            return object;
        }
        return null;
    }

    public static CoordinateReferenceSystem getSubCRS(CoordinateReferenceSystem coordinateReferenceSystem, int n, int n2) {
        if (coordinateReferenceSystem != null) {
            int n3 = coordinateReferenceSystem.getCoordinateSystem().getDimension();
            if (n < 0 || n > n2 || n2 > n3) {
                throw new IndexOutOfBoundsException(Errors.format(96, n < 0 ? n : n2));
            }
            block0: while (n != 0 || n2 != n3) {
                if (coordinateReferenceSystem instanceof CompoundCRS) {
                    List<CoordinateReferenceSystem> list = ((CompoundCRS)coordinateReferenceSystem).getComponents();
                    int n4 = list.size();
                    for (int i = 0; i < n4; ++i) {
                        coordinateReferenceSystem = list.get(i);
                        n3 = coordinateReferenceSystem.getCoordinateSystem().getDimension();
                        if (n < n3) continue block0;
                        n -= n3;
                        n2 -= n3;
                    }
                }
                return null;
            }
        }
        return coordinateReferenceSystem;
    }

    public static Datum getDatum(CoordinateReferenceSystem coordinateReferenceSystem) {
        return CRSUtilities.getDatum(coordinateReferenceSystem);
    }

    public static Ellipsoid getEllipsoid(CoordinateReferenceSystem coordinateReferenceSystem) {
        Object object;
        if (coordinateReferenceSystem instanceof SingleCRS && (object = ((SingleCRS)coordinateReferenceSystem).getDatum()) instanceof GeodeticDatum) {
            return ((GeodeticDatum)object).getEllipsoid();
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : ((CompoundCRS)coordinateReferenceSystem).getComponents()) {
                Ellipsoid ellipsoid = CRS.getEllipsoid(coordinateReferenceSystem2);
                if (ellipsoid == null) continue;
                return ellipsoid;
            }
        }
        return null;
    }

    public static boolean equalsIgnoreMetadata(Object object, Object object2) {
        return Utilities.deepEquals(object, object2, ComparisonMode.IGNORE_METADATA);
    }

    public static boolean equalsApproximatively(Object object, Object object2) {
        return Utilities.deepEquals(object, object2, ComparisonMode.APPROXIMATIVE);
    }

    public static MathTransform findMathTransform(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) throws FactoryException {
        Boolean bl = defaultLenient;
        if (bl == null) {
            defaultLenient = bl = Boolean.valueOf(Boolean.TRUE.equals(Hints.getSystemDefault(Hints.LENIENT_DATUM_SHIFT)));
        }
        return CRS.findMathTransform(coordinateReferenceSystem, coordinateReferenceSystem2, bl);
    }

    public static MathTransform findMathTransform(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, boolean bl) throws FactoryException {
        if (CRS.equalsIgnoreMetadata(coordinateReferenceSystem, coordinateReferenceSystem2)) {
            return MathTransforms.identity(coordinateReferenceSystem.getCoordinateSystem().getDimension());
        }
        ArgumentChecks.ensureNonNull("sourceCRS", coordinateReferenceSystem);
        ArgumentChecks.ensureNonNull("targetCRS", coordinateReferenceSystem2);
        CoordinateOperationFactory coordinateOperationFactory = CRS.getCoordinateOperationFactory(bl);
        return coordinateOperationFactory.createOperation(coordinateReferenceSystem, coordinateReferenceSystem2).getMathTransform();
    }

    public static Envelope transform(Envelope envelope, CoordinateReferenceSystem coordinateReferenceSystem) throws TransformException {
        return Envelopes.transform(envelope, coordinateReferenceSystem);
    }

    public static GeneralEnvelope transform(MathTransform mathTransform, Envelope envelope) throws TransformException {
        return Envelopes.transform(mathTransform, envelope);
    }

    public static GeneralEnvelope transform(CoordinateOperation coordinateOperation, Envelope envelope) throws TransformException {
        return Envelopes.transform(coordinateOperation, envelope);
    }

    public static Rectangle2D transform(MathTransform2D mathTransform2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) throws TransformException {
        return Envelopes.transform(mathTransform2D, rectangle2D, rectangle2D2);
    }

    public static Rectangle2D transform(CoordinateOperation coordinateOperation, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) throws TransformException {
        return Envelopes.transform(coordinateOperation, rectangle2D, rectangle2D2);
    }

    public static double[] deltaTransform(MathTransform mathTransform, DirectPosition directPosition, double ... dArray) throws TransformException {
        ArgumentChecks.ensureNonNull("transform", mathTransform);
        int n = mathTransform.getSourceDimensions();
        int n2 = mathTransform.getTargetDimensions();
        double[] dArray2 = new double[n2];
        if (dArray.length != n) {
            throw new IllegalArgumentException(Errors.format(113, "vector", dArray.length, n));
        }
        if (mathTransform instanceof AffineTransform) {
            ((AffineTransform)((Object)mathTransform)).deltaTransform(dArray, 0, dArray2, 0, 1);
        } else {
            int n3;
            double[] dArray3 = new double[2 * Math.max(n, n2)];
            for (n3 = 0; n3 < n; ++n3) {
                double d = directPosition.getOrdinate(n3);
                double d2 = dArray[n3] * 0.5;
                dArray3[n3] = d - d2;
                dArray3[n3 + n] = d + d2;
            }
            mathTransform.transform(dArray3, 0, dArray3, 0, 2);
            for (n3 = 0; n3 < n2; ++n3) {
                dArray2[n3] = dArray3[n3 + n2] - dArray3[n3];
            }
        }
        return dArray2;
    }

    static void unexpectedException(String string, Exception exception) {
        Logging.unexpectedException(CRS.class, string, exception);
    }

    static {
        Factories.addChangeListener(new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Class<CRS> clazz = CRS.class;
                synchronized (CRS.class) {
                    crsFactory = null;
                    standardFactory = null;
                    xyFactory = null;
                    strictFactory = null;
                    lenientFactory = null;
                    defaultOrder = null;
                    defaultLenient = null;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
    }
}

