/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.isoonjts.spatialschema.geometry.geometry;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.geometry.isoonjts.JTSUtils;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.geometry.AbstractJTSGenericCurve;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.geometry.JTSPointArray;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive.JTSCurveBoundary;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive.JTSPoint;
import org.geotoolkit.geometry.jts.SRIDGenerator;
import org.geotoolkit.internal.jaxb.DirectPositionAdapter;
import org.geotoolkit.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.complex.Complex;
import org.opengis.geometry.complex.Composite;
import org.opengis.geometry.coordinate.ParamForPoint;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.primitive.Curve;
import org.opengis.geometry.primitive.CurveBoundary;
import org.opengis.geometry.primitive.CurveInterpolation;
import org.opengis.geometry.primitive.CurveSegment;
import org.opengis.geometry.primitive.OrientablePrimitive;
import org.opengis.geometry.primitive.Primitive;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class JTSLineString
extends AbstractJTSGenericCurve
implements org.opengis.geometry.coordinate.LineString,
Primitive {
    private PointArray controlPoints = new JTSPointArray();

    public JTSLineString() {
        ((JTSPointArray)this.controlPoints).setJTSParent(this);
    }

    public JTSLineString(CoordinateReferenceSystem crs) {
        super(crs);
        ((JTSPointArray)this.controlPoints).setJTSParent(this);
    }

    @Override
    public PointArray getControlPoints() {
        return this.controlPoints;
    }

    public List asLineSegments() {
        return null;
    }

    @Override
    public CurveBoundary getBoundary() {
        return new JTSCurveBoundary(null, new JTSPoint(this.getStartPoint()), new JTSPoint(this.getEndPoint()));
    }

    @Override
    public Curve getCurve() {
        return null;
    }

    @Override
    public CurveInterpolation getInterpolation() {
        return CurveInterpolation.LINEAR;
    }

    public int getNumDerivativeInterior() {
        return 0;
    }

    @Override
    public int getNumDerivativesAtEnd() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getNumDerivativesAtStart() {
        return Integer.MAX_VALUE;
    }

    @Override
    public PointArray getSamplePoints() {
        return this.controlPoints;
    }

    @Override
    public CurveSegment reverse() {
        JTSLineString result = new JTSLineString();
        PointArray pa = result.getSamplePoints();
        List<Position> list = pa.positions();
        int n = this.controlPoints.length();
        for (int i = n - 1; i >= 0; --i) {
            list.add(new GeneralDirectPosition(this.controlPoints.positions().get(i).getDirectPosition()));
        }
        return result;
    }

    @Override
    public DirectPosition getStartPoint() {
        return (DirectPosition)this.controlPoints.positions().get(0);
    }

    @Override
    public DirectPosition getEndPoint() {
        return (DirectPosition)this.controlPoints.positions().get(this.controlPoints.length() - 1);
    }

    @Override
    public double[] getTangent(double s) {
        return null;
    }

    @Override
    public double getStartParam() {
        return 0.0;
    }

    @Override
    public double getEndParam() {
        return 1.0;
    }

    @Override
    public double getStartConstructiveParam() {
        return 0.0;
    }

    @Override
    public double getEndConstructiveParam() {
        return 1.0;
    }

    @Override
    public ParamForPoint getParamForPoint(DirectPosition p) {
        return null;
    }

    @Override
    public double length(DirectPosition point1, DirectPosition point2) {
        return 0.0;
    }

    @Override
    public double length(double cparam1, double cparam2) {
        return 0.0;
    }

    @Override
    public org.opengis.geometry.coordinate.LineString asLineString(double maxSpacing, double maxOffset) {
        return null;
    }

    @Override
    protected Geometry computeJTSPeer() {
        int n = this.controlPoints.length();
        Coordinate[] coords = new Coordinate[n];
        for (int i = 0; i < n; ++i) {
            coords[i] = JTSUtils.directPositionToCoordinate((DirectPosition)this.controlPoints.positions().get(i));
        }
        LineString result = JTSUtils.GEOMETRY_FACTORY.createLineString(coords);
        CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem();
        if (crs != null) {
            int srid = SRIDGenerator.toSRID(crs, SRIDGenerator.Version.V1);
            result.setSRID(srid);
        }
        return result;
    }

    @Override
    public int getNumDerivativesInterior() {
        return 0;
    }

    @Override
    public DirectPosition forConstructiveParam(double cp) {
        return null;
    }

    @Override
    public DirectPosition forParam(double s) {
        return null;
    }

    public void applyCRSOnChild() {
        if (this.controlPoints != null) {
            ArrayList<Position> newPositions = new ArrayList<Position>();
            for (Position pos : this.controlPoints.positions()) {
                if (!(pos instanceof GeneralDirectPosition)) continue;
                ((GeneralDirectPosition)pos).setCoordinateReferenceSystem(this.getCoordinateReferenceSystem());
                newPositions.add(pos);
            }
            this.controlPoints.clear();
            this.controlPoints.addAll(newPositions);
        }
    }

    @XmlElement(name="pos", namespace="http://www.opengis.net/gml")
    @XmlJavaTypeAdapter(value=DirectPositionAdapter.class)
    public List<Position> getPositions() {
        if (this.controlPoints != null) {
            return this.controlPoints.positions();
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("JTSLineString{");
        if (!this.controlPoints.isEmpty()) {
            sb.append("\n");
            for (Position pos : this.controlPoints) {
                sb.append("\t").append(pos.toString()).append("\n");
            }
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof JTSLineString & super.equals(object)) {
            JTSLineString that = (JTSLineString)object;
            return Utilities.equals(this.controlPoints, that.controlPoints);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (this.controlPoints != null ? this.controlPoints.hashCode() : 0);
        return hash;
    }

    @Override
    public Set<Primitive> getContainedPrimitives() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Set<Primitive> getContainingPrimitives() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Set<Complex> getComplexes() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Composite getComposite() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public OrientablePrimitive[] getProxy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

