/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.geotoolkit.geometry.jts.JTS;
import org.geotoolkit.gml.xml.AbstractCurve;
import org.geotoolkit.gml.xml.AbstractCurveSegment;
import org.geotoolkit.gml.xml.AbstractGeometry;
import org.geotoolkit.gml.xml.AbstractRing;
import org.geotoolkit.gml.xml.AbstractRingProperty;
import org.geotoolkit.gml.xml.Coordinates;
import org.geotoolkit.gml.xml.Curve;
import org.geotoolkit.gml.xml.CurveProperty;
import org.geotoolkit.gml.xml.CurveSegmentArrayProperty;
import org.geotoolkit.gml.xml.DirectPosition;
import org.geotoolkit.gml.xml.DirectPositionList;
import org.geotoolkit.gml.xml.Envelope;
import org.geotoolkit.gml.xml.GMLMarshallerPool;
import org.geotoolkit.gml.xml.LineString;
import org.geotoolkit.gml.xml.LineStringProperty;
import org.geotoolkit.gml.xml.LineStringSegment;
import org.geotoolkit.gml.xml.LinearRing;
import org.geotoolkit.gml.xml.MultiCurve;
import org.geotoolkit.gml.xml.MultiLineString;
import org.geotoolkit.gml.xml.MultiPoint;
import org.geotoolkit.gml.xml.MultiPolygon;
import org.geotoolkit.gml.xml.MultiSurface;
import org.geotoolkit.gml.xml.OrientableCurve;
import org.geotoolkit.gml.xml.Point;
import org.geotoolkit.gml.xml.PointProperty;
import org.geotoolkit.gml.xml.Polygon;
import org.geotoolkit.gml.xml.PolygonProperty;
import org.geotoolkit.gml.xml.Ring;
import org.geotoolkit.gml.xml.SurfaceProperty;
import org.geotoolkit.gml.xml.v311.ArcByCenterPointType;
import org.geotoolkit.gml.xml.v311.ArcStringByBulgeType;
import org.geotoolkit.gml.xml.v311.ArcStringType;
import org.geotoolkit.gml.xml.v311.BSplineType;
import org.geotoolkit.gml.xml.v311.ClothoidType;
import org.geotoolkit.gml.xml.v311.CubicSplineType;
import org.geotoolkit.gml.xml.v311.GeodesicStringType;
import org.geotoolkit.gml.xml.v311.OffsetCurveType;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.util.logging.Logging;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

public class GeometrytoJTS {
    private static final Logger LOGGER = Logging.getLogger(GeometrytoJTS.class);
    private static final GeometryFactory GF = new GeometryFactory();

    private GeometrytoJTS() {
    }

    private static CoordinateReferenceSystem toCRS(String name) throws FactoryException {
        return CRS.decode(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Geometry toJTS(String gmlString) throws JAXBException, FactoryException {
        Geometry geom;
        block6: {
            StringReader reader = new StringReader(gmlString);
            Unmarshaller unmarshaller = null;
            try {
                unmarshaller = GMLMarshallerPool.getInstance().acquireUnmarshaller();
                Object jax = unmarshaller.unmarshal((Reader)reader);
                if (jax instanceof JAXBElement) {
                    jax = ((JAXBElement)jax).getValue();
                }
                if (jax instanceof AbstractGeometry) {
                    geom = GeometrytoJTS.toJTS((AbstractGeometry)jax);
                    break block6;
                }
                throw new JAXBException("Object is not a valid GML " + jax);
            }
            finally {
                if (unmarshaller != null) {
                    GMLMarshallerPool.getInstance().release(unmarshaller);
                }
            }
        }
        return geom;
    }

    public static com.vividsolutions.jts.geom.Polygon toJTS(Envelope gmlEnvelope) throws NoSuchAuthorityCodeException, FactoryException {
        String crsName = gmlEnvelope.getSrsName();
        if (crsName == null) {
            throw new IllegalArgumentException("An operator BBOX must specified a CRS (coordinate Reference system) for the envelope.");
        }
        double[] min = gmlEnvelope.getLowerCorner().getCoordinate();
        double[] max = gmlEnvelope.getUpperCorner().getCoordinate();
        com.vividsolutions.jts.geom.LinearRing ring = GF.createLinearRing(new Coordinate[]{new Coordinate(min[0], min[1]), new Coordinate(min[0], max[1]), new Coordinate(max[0], max[1]), new Coordinate(max[0], min[1]), new Coordinate(min[0], min[1])});
        com.vividsolutions.jts.geom.Polygon polygon = GF.createPolygon(ring, new com.vividsolutions.jts.geom.LinearRing[0]);
        CoordinateReferenceSystem crs = GeometrytoJTS.toCRS(crsName);
        JTS.setCRS(polygon, crs);
        return polygon;
    }

    public static Geometry toJTS(AbstractGeometry gml) throws NoSuchAuthorityCodeException, FactoryException {
        if (gml instanceof Point) {
            return GeometrytoJTS.toJTS((Point)gml, null);
        }
        if (gml instanceof LineString) {
            return GeometrytoJTS.toJTS((LineString)gml);
        }
        if (gml instanceof Polygon) {
            return GeometrytoJTS.toJTS((Polygon)gml);
        }
        if (gml instanceof MultiPoint) {
            return GeometrytoJTS.toJTS((MultiPoint)gml);
        }
        if (gml instanceof MultiLineString) {
            return GeometrytoJTS.toJTS((MultiLineString)gml);
        }
        if (gml instanceof MultiCurve) {
            return GeometrytoJTS.toJTS((MultiCurve)gml);
        }
        if (gml instanceof MultiPolygon) {
            return GeometrytoJTS.toJTS((MultiPolygon)gml);
        }
        if (gml instanceof MultiSurface) {
            return GeometrytoJTS.toJTS((MultiSurface)gml);
        }
        if (gml instanceof LinearRing) {
            return GeometrytoJTS.toJTS((LinearRing)gml);
        }
        throw new IllegalArgumentException("Unssupported geometry type : " + gml);
    }

    public static com.vividsolutions.jts.geom.Point toJTS(Point gmlPoint, CoordinateReferenceSystem parentCRS) throws NoSuchAuthorityCodeException, FactoryException {
        String crsName = parentCRS == null ? gmlPoint.getSrsName() : null;
        if (gmlPoint.getCoordinates() == null && gmlPoint.getPos() == null) {
            throw new IllegalArgumentException("A GML point must specify coordinates or direct position.");
        }
        double[] coordinates = new double[2];
        if (gmlPoint.getCoordinates() != null) {
            String coord = gmlPoint.getCoordinates().getValue();
            StringTokenizer tokens = new StringTokenizer(coord, ",");
            int index = 0;
            while (tokens.hasMoreTokens()) {
                double value = GeometrytoJTS.parseDouble(tokens.nextToken());
                if (index >= coordinates.length) {
                    throw new IllegalArgumentException("This service support only 2D point.");
                }
                coordinates[index++] = value;
            }
        } else if (gmlPoint.getPos().getValue() != null && gmlPoint.getPos().getValue().size() == 2) {
            coordinates[0] = gmlPoint.getPos().getValue().get(0);
            coordinates[1] = gmlPoint.getPos().getValue().get(1);
        } else {
            throw new IllegalArgumentException("The GML point is malformed.");
        }
        com.vividsolutions.jts.geom.Point pt = GF.createPoint(new Coordinate(coordinates[0], coordinates[1]));
        CoordinateReferenceSystem crs = crsName != null ? GeometrytoJTS.toCRS(crsName) : parentCRS;
        if (crs != null) {
            JTS.setCRS(pt, crs);
        }
        return pt;
    }

    public static com.vividsolutions.jts.geom.Polygon toJTS(Polygon gml) throws FactoryException {
        AbstractRingProperty ext = gml.getExterior();
        List<? extends AbstractRingProperty> ints = gml.getInterior();
        com.vividsolutions.jts.geom.LinearRing exterior = GeometrytoJTS.toJTS(ext.getAbstractRing());
        com.vividsolutions.jts.geom.LinearRing[] holes = new com.vividsolutions.jts.geom.LinearRing[ints.size()];
        for (int i = 0; i < holes.length; ++i) {
            holes[i] = GeometrytoJTS.toJTS(ints.get(i).getAbstractRing());
        }
        com.vividsolutions.jts.geom.Polygon polygon = GF.createPolygon(exterior, holes);
        CoordinateReferenceSystem crs = gml.getCoordinateReferenceSystem();
        JTS.setCRS(polygon, crs);
        return polygon;
    }

    public static com.vividsolutions.jts.geom.LineString toJTS(LineString gmlLine) throws FactoryException {
        com.vividsolutions.jts.geom.LineString ls;
        String crsName = gmlLine.getSrsName();
        if (crsName == null) {
            throw new FactoryException("A CRS (coordinate Reference system) must be specified for the line.");
        }
        CoordinateReferenceSystem crs = GeometrytoJTS.toCRS(crsName);
        Coordinates coord = gmlLine.getCoordinates();
        if (coord != null) {
            List<Double> values = coord.getValues();
            Coordinate[] coordinates = new Coordinate[values.size() / 2];
            if (values != null && !values.isEmpty()) {
                int cpt = 0;
                for (int i = 0; i < values.size(); i += 2) {
                    coordinates[cpt] = new Coordinate(values.get(i), values.get(i + 1));
                    ++cpt;
                }
            }
            ls = GF.createLineString(coordinates);
        } else if (gmlLine.getPosList() != null) {
            DirectPositionList dplt = gmlLine.getPosList();
            int dim = gmlLine.getCoordinateDimension();
            List<Coordinate> coords = GeometrytoJTS.toJTSCoords(dplt, dim);
            ls = GF.createLineString(coords.toArray(new Coordinate[coords.size()]));
        } else {
            List<Coordinate> coords = GeometrytoJTS.toJTSCoords(gmlLine.getPos());
            ls = GF.createLineString(coords.toArray(new Coordinate[coords.size()]));
        }
        JTS.setCRS(ls, crs);
        return ls;
    }

    public static List<com.vividsolutions.jts.geom.LineString> toJTS(Curve gmlLine) throws FactoryException {
        String crsName = gmlLine.getSrsName();
        if (crsName == null) {
            throw new FactoryException("A CRS (coordinate Reference system) must be specified for the line.");
        }
        CoordinateReferenceSystem crs = GeometrytoJTS.toCRS(crsName);
        ArrayList<com.vividsolutions.jts.geom.LineString> lineList = new ArrayList<com.vividsolutions.jts.geom.LineString>();
        CurveSegmentArrayProperty arrayProperty = gmlLine.getSegments();
        List<? extends AbstractCurveSegment> segments = arrayProperty.getAbstractCurveSegment();
        for (AbstractCurveSegment abstractCurveSegment : segments) {
            if (abstractCurveSegment instanceof LineStringSegment) {
                com.vividsolutions.jts.geom.LineString ls;
                LineStringSegment lineSegment = (LineStringSegment)abstractCurveSegment;
                Coordinates coord = lineSegment.getCoordinates();
                if (coord != null) {
                    String s = coord.getValue();
                    String cs = coord.getCs() == null ? "," : coord.getCs();
                    int csIndex = s.indexOf(cs);
                    double x1 = Double.parseDouble(s.substring(0, csIndex));
                    String ts = coord.getTs() == null ? " " : coord.getTs();
                    int tsIndex = s.indexOf(ts, csIndex);
                    double y1 = Double.parseDouble(s.substring(csIndex + 1, tsIndex));
                    csIndex = s.indexOf(cs, tsIndex + 1);
                    double x2 = Double.parseDouble(s.substring(tsIndex + 1, csIndex));
                    double y2 = Double.parseDouble(s.substring(csIndex + 1));
                    ls = GF.createLineString(new Coordinate[]{new Coordinate(x1, y1), new Coordinate(x2, y2)});
                } else if (lineSegment.getPosList() != null) {
                    DirectPositionList dplt = lineSegment.getPosList();
                    int dim = gmlLine.getCoordinateDimension();
                    List<Coordinate> coords = GeometrytoJTS.toJTSCoords(dplt, dim);
                    ls = GF.createLineString(coords.toArray(new Coordinate[coords.size()]));
                } else {
                    List<Coordinate> coords = GeometrytoJTS.toJTSCoords(lineSegment.getPos());
                    ls = GF.createLineString(coords.toArray(new Coordinate[coords.size()]));
                }
                JTS.setCRS(ls, crs);
                lineList.add(ls);
                continue;
            }
            throw new IllegalArgumentException("only lineStringSegment are allowed in curveType segments");
        }
        return lineList;
    }

    public static List<Coordinate> toJTSCoords(List<? extends DirectPosition> pos) {
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        for (DirectPosition directPosition : pos) {
            coords.add(new Coordinate(directPosition.getOrdinate(0), directPosition.getOrdinate(1)));
        }
        return coords;
    }

    public static List<Coordinate> toJTSCoords(DirectPositionList lst, int dim) {
        List<Double> values = lst.getValue();
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        int n = values.size();
        for (int i = 0; i < n; i += dim) {
            coords.add(new Coordinate(values.get(i), values.get(i + 1)));
        }
        return coords;
    }

    public static com.vividsolutions.jts.geom.MultiPoint toJTS(MultiPoint gml) throws NoSuchAuthorityCodeException, FactoryException {
        List<? extends PointProperty> pos = gml.getPointMember();
        com.vividsolutions.jts.geom.Point[] members = new com.vividsolutions.jts.geom.Point[pos.size()];
        CoordinateReferenceSystem crs = gml.getCoordinateReferenceSystem();
        int n = pos.size();
        for (int i = 0; i < n; ++i) {
            members[i] = GeometrytoJTS.toJTS(pos.get(i).getPoint(), crs);
        }
        com.vividsolutions.jts.geom.MultiPoint geom = GF.createMultiPoint(members);
        JTS.setCRS(geom, crs);
        return geom;
    }

    public static com.vividsolutions.jts.geom.MultiLineString toJTS(MultiLineString gml) throws FactoryException {
        List<? extends LineStringProperty> pos = gml.getLineStringMember();
        com.vividsolutions.jts.geom.LineString[] members = new com.vividsolutions.jts.geom.LineString[pos.size()];
        int n = pos.size();
        for (int i = 0; i < n; ++i) {
            members[i] = GeometrytoJTS.toJTS(pos.get(i).getLineString());
        }
        com.vividsolutions.jts.geom.MultiLineString geom = GF.createMultiLineString(members);
        CoordinateReferenceSystem crs = gml.getCoordinateReferenceSystem();
        JTS.setCRS(geom, crs);
        return geom;
    }

    public static com.vividsolutions.jts.geom.MultiLineString toJTS(MultiCurve gml) throws FactoryException {
        List<? extends CurveProperty> pos = gml.getCurveMember();
        ArrayList<com.vividsolutions.jts.geom.LineString> members = new ArrayList<com.vividsolutions.jts.geom.LineString>();
        int n = pos.size();
        for (int i = 0; i < n; ++i) {
            AbstractCurve curve = pos.get(i).getAbstractCurve();
            if (curve instanceof LineString) {
                members.add(GeometrytoJTS.toJTS((LineString)((Object)curve)));
                continue;
            }
            if (curve instanceof Curve) {
                members.addAll(GeometrytoJTS.toJTS((Curve)((Object)curve)));
                continue;
            }
            throw new IllegalArgumentException("unexpected Curve type:" + curve);
        }
        com.vividsolutions.jts.geom.MultiLineString geom = GF.createMultiLineString(members.toArray(new com.vividsolutions.jts.geom.LineString[members.size()]));
        CoordinateReferenceSystem crs = gml.getCoordinateReferenceSystem();
        JTS.setCRS(geom, crs);
        return geom;
    }

    public static com.vividsolutions.jts.geom.MultiPolygon toJTS(MultiPolygon gml) throws FactoryException {
        List<? extends PolygonProperty> pos = gml.getPolygonMember();
        com.vividsolutions.jts.geom.Polygon[] members = new com.vividsolutions.jts.geom.Polygon[pos.size()];
        int n = pos.size();
        for (int i = 0; i < n; ++i) {
            members[i] = GeometrytoJTS.toJTS(pos.get(i).getPolygon());
        }
        com.vividsolutions.jts.geom.MultiPolygon geom = GF.createMultiPolygon(members);
        CoordinateReferenceSystem crs = gml.getCoordinateReferenceSystem();
        JTS.setCRS(geom, crs);
        return geom;
    }

    public static com.vividsolutions.jts.geom.MultiPolygon toJTS(MultiSurface gml) throws FactoryException {
        List<? extends SurfaceProperty> pos = gml.getSurfaceMember();
        com.vividsolutions.jts.geom.Polygon[] members = new com.vividsolutions.jts.geom.Polygon[pos.size()];
        int n = pos.size();
        for (int i = 0; i < n; ++i) {
            members[i] = GeometrytoJTS.toJTS((Polygon)((Object)pos.get(i).getAbstractSurface()));
        }
        com.vividsolutions.jts.geom.MultiPolygon geom = GF.createMultiPolygon(members);
        CoordinateReferenceSystem crs = gml.getCoordinateReferenceSystem();
        JTS.setCRS(geom, crs);
        return geom;
    }

    public static com.vividsolutions.jts.geom.LinearRing toJTS(AbstractRing gml) throws FactoryException {
        if (gml instanceof LinearRing) {
            return GeometrytoJTS.toJTS((LinearRing)gml);
        }
        if (gml instanceof Ring) {
            return GeometrytoJTS.toJTS((Ring)gml);
        }
        LOGGER.log(Level.WARNING, "Unssupported geometry type : {0}", gml);
        return GF.createLinearRing(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(0.0, 0.0), new Coordinate(0.0, 0.0), new Coordinate(0.0, 0.0)});
    }

    public static com.vividsolutions.jts.geom.LinearRing toJTS(LinearRing gml) {
        List<Double> values;
        DirectPositionList lst = gml.getPosList();
        Coordinates cds = gml.getCoordinates();
        if (lst != null) {
            values = lst.getValue();
        } else if (cds != null) {
            values = cds.getValues();
        } else {
            values = new ArrayList<Double>();
            LOGGER.warning("no coordinates available for linear ring");
        }
        int dim = gml.getCoordinateDimension();
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>(dim);
        int n = values.size();
        for (int i = 0; i < n; i += dim) {
            coords.add(new Coordinate(values.get(i), values.get(i + 1)));
        }
        com.vividsolutions.jts.geom.LinearRing ring = GF.createLinearRing(coords.toArray(new Coordinate[coords.size()]));
        CoordinateReferenceSystem crs = gml.getCoordinateReferenceSystem();
        JTS.setCRS(ring, crs);
        return ring;
    }

    /*
     * WARNING - void declaration
     */
    public static com.vividsolutions.jts.geom.LinearRing toJTS(Ring gml) throws FactoryException {
        LinkedList<Coordinate> coords = new LinkedList<Coordinate>();
        for (CurveProperty curveProperty : gml.getCurveMember()) {
            AbstractCurve act = curveProperty.getAbstractCurve();
            if (act instanceof Curve) {
                Curve ct = (Curve)((Object)act);
                for (AbstractCurveSegment abstractCurveSegment : ct.getSegments().getAbstractCurveSegment()) {
                    if (abstractCurveSegment instanceof ClothoidType) {
                        throw new IllegalArgumentException("ClothoidType not supported yet");
                    }
                    if (abstractCurveSegment instanceof BSplineType) {
                        throw new IllegalArgumentException("BSplineType not supported yet");
                    }
                    if (abstractCurveSegment instanceof CubicSplineType) {
                        throw new IllegalArgumentException("CubicSplineType not supported yet");
                    }
                    if (abstractCurveSegment instanceof GeodesicStringType) {
                        throw new IllegalArgumentException("GeodesicStringType not supported yet");
                    }
                    if (abstractCurveSegment instanceof LineStringSegment) {
                        LineStringSegment lsst = (LineStringSegment)abstractCurveSegment;
                        if (lsst.getPosList() != null) {
                            DirectPositionList dpst = lsst.getPosList();
                            int n = ct.getCoordinateDimension();
                            List<Coordinate> plots = GeometrytoJTS.toJTSCoords(dpst, n);
                            if (coords.isEmpty()) {
                                for (Coordinate c : plots) {
                                    coords.add(c);
                                }
                                continue;
                            }
                            if (((Coordinate)coords.getLast()).equals(plots.get(0))) {
                                for (int i = 1; i < plots.size(); ++i) {
                                    coords.add(plots.get(i));
                                }
                                continue;
                            }
                            for (Coordinate c : plots) {
                                coords.add(c);
                            }
                            continue;
                        }
                        if (coords.isEmpty()) {
                            for (DirectPosition directPosition : lsst.getPos()) {
                                coords.add(new Coordinate(directPosition.getOrdinate(0), directPosition.getOrdinate(1)));
                            }
                            if (lsst.getRest().isEmpty()) continue;
                            throw new IllegalArgumentException("not supported yet");
                        }
                        for (DirectPosition directPosition : lsst.getPos()) {
                            Coordinate c = new Coordinate(directPosition.getOrdinate(0), directPosition.getOrdinate(1));
                            if (c.equals2D((Coordinate)coords.getLast())) continue;
                            coords.add(c);
                        }
                        if (lsst.getRest().isEmpty()) continue;
                        throw new IllegalArgumentException("not supported yet");
                    }
                    if (abstractCurveSegment instanceof ArcByCenterPointType) {
                        throw new IllegalArgumentException("not supported yet");
                    }
                    if (abstractCurveSegment instanceof ArcStringType) {
                        throw new IllegalArgumentException("not supported yet");
                    }
                    if (abstractCurveSegment instanceof OffsetCurveType) {
                        throw new IllegalArgumentException("not supported yet");
                    }
                    if (abstractCurveSegment instanceof ArcStringByBulgeType) {
                        throw new IllegalArgumentException("not supported yet");
                    }
                    throw new IllegalArgumentException("not supported yet:" + abstractCurveSegment);
                }
                continue;
            }
            if (act instanceof LineString) {
                com.vividsolutions.jts.geom.LineString ls = GeometrytoJTS.toJTS((LineString)((Object)act));
                Coordinate[] plots = ls.getCoordinates();
                if (coords.isEmpty()) {
                    for (Coordinate coordinate : plots) {
                        coords.add(coordinate);
                    }
                    continue;
                }
                if (((Coordinate)coords.getLast()).equals(plots[0])) {
                    void var7_11;
                    boolean bl = true;
                    while (var7_11 < plots.length) {
                        coords.add(plots[var7_11]);
                        ++var7_11;
                    }
                    continue;
                }
                for (Coordinate coordinate : plots) {
                    coords.add(coordinate);
                }
                continue;
            }
            if (!(act instanceof OrientableCurve)) continue;
            throw new IllegalArgumentException("not supported yet");
        }
        com.vividsolutions.jts.geom.LinearRing ring = GF.createLinearRing(coords.toArray(new Coordinate[coords.size()]));
        CoordinateReferenceSystem coordinateReferenceSystem = gml.getCoordinateReferenceSystem();
        JTS.setCRS(ring, coordinateReferenceSystem);
        return ring;
    }

    private static double parseDouble(String value) {
        value = value.trim();
        return Double.parseDouble(value);
    }
}

