/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19136.components;

import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSTypeDefinition;
import org.opengis.cite.iso19136.ETSAssert;
import org.opengis.cite.iso19136.ErrorMessage;
import org.opengis.cite.iso19136.SuiteAttribute;
import org.opengis.cite.iso19136.general.SchemaModelFixture;
import org.opengis.cite.iso19136.util.XMLSchemaModelUtils;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class GeometryComponentTests
extends SchemaModelFixture {
    private XSTypeDefinition gmlGeomBaseType;
    private XSElementDeclaration abstractGmlGeom;

    @BeforeTest
    public void hasGeometryComponents(ITestContext testContext) {
        if (null == this.model) {
            this.model = (XSModel)testContext.getSuite().getAttribute(SuiteAttribute.XSMODEL.getName());
        }
        this.gmlGeomBaseType = this.model.getTypeDefinition("AbstractGeometryType", "http://www.opengis.net/gml/3.2");
        List<XSElementDeclaration> geomElements = XMLSchemaModelUtils.getGlobalElementsByType(this.model, this.gmlGeomBaseType);
        XSTypeDefinition geomPropBaseType = this.model.getTypeDefinition("GeometryPropertyType", "http://www.opengis.net/gml/3.2");
        Set<XSTypeDefinition> geomPropTypes = XMLSchemaModelUtils.getDerivedTypeDefinitions(this.model, geomPropBaseType, (short)2);
        this.abstractGmlGeom = this.model.getElementDeclaration("AbstractGeometry", "http://www.opengis.net/gml/3.2");
        List<XSElementDeclaration> geomProps = XMLSchemaModelUtils.getImplicitProperties(this.model, this.abstractGmlGeom);
        geomProps.addAll(XMLSchemaModelUtils.getExplicitGeometryProperties(this.model));
        if (geomElements.isEmpty() && geomPropTypes.isEmpty() && geomProps.isEmpty()) {
            throw new SkipException(ErrorMessage.get("NoUserDefinedGeomTypes"));
        }
    }

    @Test(description="See ISO 19136: 21.4.2.1")
    public void substitutesForGMLGeometry() {
        List<XSElementDeclaration> geometries = XMLSchemaModelUtils.getGeometryDeclarations(this.model);
        Set<XSTypeDefinition> geomTypeDefs = XMLSchemaModelUtils.getDerivedTypeDefinitions(this.model, this.gmlGeomBaseType, (short)1);
        for (XSTypeDefinition typeDef : geomTypeDefs) {
            List<XSElementDeclaration> geomDecls = XMLSchemaModelUtils.getGlobalElementsByType(this.model, typeDef);
            for (XSElementDeclaration geomDecl : geomDecls) {
                Assert.assertTrue(geometries.contains(geomDecl), ErrorMessage.format("SubstitutionError", new QName(geomDecl.getNamespace(), geomDecl.getName()), "gml:AbstractGeometry"));
            }
        }
    }

    @Test(description="See ISO 19136: 9.5, 21.4.2.2, A.1.1.10")
    public void validateImplicitGeometryProperty() {
        XSElementDeclaration geometry = this.model.getElementDeclaration("AbstractGeometry", "http://www.opengis.net/gml/3.2");
        List<XSElementDeclaration> geomProps = XMLSchemaModelUtils.getImplicitProperties(this.model, geometry);
        for (XSElementDeclaration prop : geomProps) {
            ETSAssert.assertValidPropertyType(this.model, prop, this.abstractGmlGeom);
        }
    }
}

