/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.charcode.UTF16;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLCharacterMap;
import net.sf.saxon.trans.XPathException;

public class XSLOutputCharacter
extends StyleElement {
    private int codepoint = -1;
    private String replacementString = null;

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f == "character") {
                String s = atts.getValue(a);
                switch (s.length()) {
                    case 0: {
                        this.compileError("character attribute must not be zero-length", "XTSE0020");
                        this.codepoint = 256;
                        break;
                    }
                    case 1: {
                        this.codepoint = s.charAt(0);
                        break;
                    }
                    case 2: {
                        if (UTF16.isHighSurrogate(s.charAt(0)) && UTF16.isLowSurrogate(s.charAt(1))) {
                            this.codepoint = UTF16.combinePair(s.charAt(0), s.charAt(1));
                            break;
                        }
                        this.compileError("character attribute must be a single XML character", "XTSE0020");
                        this.codepoint = 256;
                        break;
                    }
                    default: {
                        this.compileError("character attribute must be a single XML character", "XTSE0020");
                        this.codepoint = 256;
                        break;
                    }
                }
                continue;
            }
            if (f == "string") {
                this.replacementString = atts.getValue(a);
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
        if (this.codepoint == -1) {
            this.reportAbsence("character");
            return;
        }
        if (this.replacementString == null) {
            this.reportAbsence("string");
            return;
        }
    }

    public void validate() throws XPathException {
        if (!(this.getParent() instanceof XSLCharacterMap)) {
            this.compileError("xsl:output-character may appear only as a child of xsl:character-map", "XTSE0010");
        }
    }

    public Expression compile(Executable exec) throws XPathException {
        return null;
    }

    public int getCodePoint() {
        return this.codepoint;
    }

    public String getReplacementString() {
        return this.replacementString;
    }
}

