/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.imageio.spi.ServiceRegistry;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.factory.AuthorityFactoryFinder;
import org.geotoolkit.factory.FactoryRegistryException;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.internal.Citations;
import org.geotoolkit.internal.referencing.factory.ImplementationHints;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.geotoolkit.referencing.factory.AllAuthoritiesFactory;
import org.geotoolkit.referencing.factory.CachingAuthorityFactory;
import org.geotoolkit.referencing.factory.FactoryDependencies;
import org.geotoolkit.referencing.factory.MultiAuthoritiesFactory;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.util.collection.UnmodifiableArrayList;
import org.geotoolkit.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

@ThreadSafe
final class DefaultAuthorityFactory
extends CachingAuthorityFactory
implements CRSAuthorityFactory {
    private static final List<String> AUTHORITY_LESS = UnmodifiableArrayList.wrap((Object[])new String[]{"WGS84(DD)"});
    final MultiAuthoritiesFactory backingStore;

    private DefaultAuthorityFactory(MultiAuthoritiesFactory multiAuthoritiesFactory) {
        super(multiAuthoritiesFactory);
        this.backingStore = multiAuthoritiesFactory;
    }

    static DefaultAuthorityFactory create(boolean bl) {
        Hints hints = new Hints();
        Hints hints2 = EMPTY_HINTS.clone();
        Object object = hints.get((Object)Hints.CRS_AUTHORITY_FACTORY);
        if (object != null) {
            hints2.put((Object)Hints.CRS_AUTHORITY_FACTORY, object);
        }
        ArrayList<CRSAuthorityFactory> arrayList = new ArrayList<CRSAuthorityFactory>(AuthorityFactoryFinder.getCRSAuthorityFactories((Hints)hints2));
        hints2 = hints;
        TypeFilter typeFilter = new TypeFilter();
        hints2.put((Object)AuthorityFactoryFinder.FILTER_KEY, (Object)typeFilter);
        hints2.put((Object)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)bl);
        int n = arrayList.size();
        while (--n >= 0) {
            CRSAuthorityFactory cRSAuthorityFactory = (CRSAuthorityFactory)arrayList.get(n);
            ImplementationHints implementationHints = cRSAuthorityFactory.getClass().getAnnotation(ImplementationHints.class);
            if (implementationHints != null && implementationHints.forceLongitudeFirst() != bl) {
                arrayList.remove(n);
                continue;
            }
            String string = Citations.getIdentifier((Citation)cRSAuthorityFactory.getAuthority());
            typeFilter.type = cRSAuthorityFactory.getClass();
            hints2.put((Object)Hints.CRS_AUTHORITY_FACTORY, typeFilter.type);
            try {
                cRSAuthorityFactory = AuthorityFactoryFinder.getCRSAuthorityFactory((String)string, (Hints)hints2);
            }
            catch (FactoryRegistryException factoryRegistryException) {
                Logging.recoverableException((Logger)LOGGER, DefaultAuthorityFactory.class, (String)"create", (Throwable)factoryRegistryException);
                arrayList.remove(n);
                continue;
            }
            CRSAuthorityFactory cRSAuthorityFactory2 = arrayList.set(n, cRSAuthorityFactory);
            if (cRSAuthorityFactory2 == cRSAuthorityFactory) continue;
            LogRecord logRecord = Loggings.format((Level)Level.FINE, (int)26, (Object)string, cRSAuthorityFactory.getClass(), cRSAuthorityFactory2.getClass(), (Object)(bl ? 1 : 0));
            logRecord.setSourceClassName(DefaultAuthorityFactory.class.getName());
            logRecord.setSourceMethodName("create");
            logRecord.setLoggerName(LOGGER.getName());
            LOGGER.log(logRecord);
        }
        hints2.clear();
        hints2.put((Object)AllAuthoritiesFactory.USER_FACTORIES_KEY, arrayList);
        hints2.put((Object)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)bl);
        DefaultAuthorityFactory defaultAuthorityFactory = new DefaultAuthorityFactory(AllAuthoritiesFactory.getInstance(hints2));
        defaultAuthorityFactory.log(Level.CONFIG, bl);
        return defaultAuthorityFactory;
    }

    private void log(Level level, boolean bl) {
        Logger logger = Logging.getLogger(AuthorityFactoryFinder.class);
        if (logger.isLoggable(level)) {
            FactoryDependencies factoryDependencies = new FactoryDependencies(this);
            factoryDependencies.setAbridged(true);
            LogRecord logRecord = new LogRecord(level, "CRS.getAuthorityFactory(" + bl + ") creates:" + System.getProperty("line.separator", "\n") + factoryDependencies);
            logRecord.setSourceClassName("org.geotoolkit.referencing.CRS");
            logRecord.setSourceMethodName("getAuthorityFactory");
            logRecord.setLoggerName(logger.getName());
            logger.log(logRecord);
        }
    }

    static Set<String> getSupportedCodes(String string) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(AUTHORITY_LESS);
        for (CRSAuthorityFactory cRSAuthorityFactory : AuthorityFactoryFinder.getCRSAuthorityFactories(null)) {
            Set<String> set;
            if (!Citations.identifierMatches((Citation)cRSAuthorityFactory.getAuthority(), (String)string)) continue;
            try {
                set = cRSAuthorityFactory.getAuthorityCodes(CoordinateReferenceSystem.class);
            }
            catch (Exception exception) {
                CRS.unexpectedException("getSupportedCodes", exception);
                continue;
            }
            if (set == null) continue;
            linkedHashSet.addAll(set);
        }
        return linkedHashSet;
    }

    static Set<String> getSupportedAuthorities(boolean bl) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        block0: for (CRSAuthorityFactory cRSAuthorityFactory : AuthorityFactoryFinder.getCRSAuthorityFactories(null)) {
            for (Identifier identifier : cRSAuthorityFactory.getAuthority().getIdentifiers()) {
                linkedHashSet.add(identifier.getCode());
                if (bl) continue;
                continue block0;
            }
        }
        return linkedHashSet;
    }

    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String string) throws FactoryException {
        if (string != null && (string = string.trim()).equalsIgnoreCase("WGS84(DD)")) {
            return DefaultGeographicCRS.WGS84;
        }
        assert (!AUTHORITY_LESS.contains(string)) : string;
        return super.createCoordinateReferenceSystem(string);
    }

    private static final class TypeFilter
    implements ServiceRegistry.Filter {
        Class<?> type;

        private TypeFilter() {
        }

        @Override
        public boolean filter(Object object) {
            return object.getClass() == this.type;
        }
    }
}

