/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.sql.table;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.geotoolkit.internal.sql.TypeMapper;
import org.geotoolkit.internal.sql.table.CatalogException;
import org.geotoolkit.internal.sql.table.Database;
import org.geotoolkit.internal.sql.table.DuplicatedRecordException;
import org.geotoolkit.internal.sql.table.Entry;
import org.geotoolkit.internal.sql.table.IllegalUpdateException;
import org.geotoolkit.internal.sql.table.LocalCache;
import org.geotoolkit.internal.sql.table.MultiColumnIdentifier;
import org.geotoolkit.internal.sql.table.NameGenerator;
import org.geotoolkit.internal.sql.table.NoSuchRecordException;
import org.geotoolkit.internal.sql.table.Parameter;
import org.geotoolkit.internal.sql.table.Query;
import org.geotoolkit.internal.sql.table.QueryType;
import org.geotoolkit.internal.sql.table.Table;
import org.geotoolkit.util.collection.Cache;
import org.geotoolkit.util.logging.Logging;

public abstract class SingletonTable<E extends Entry>
extends Table {
    private final Parameter[] pkParam;
    private final Cache<Comparable<?>, E> cache;
    private transient NameGenerator generator;

    protected SingletonTable(Query query, Parameter ... parameterArray) {
        super(query);
        this.pkParam = (Parameter[])parameterArray.clone();
        this.cache = new Cache();
    }

    protected SingletonTable(SingletonTable<E> singletonTable) {
        super(singletonTable);
        this.pkParam = singletonTable.pkParam;
        this.cache = singletonTable.cache;
    }

    private int[] getPrimaryKeyColumns() {
        QueryType queryType = this.getQueryType();
        int[] nArray = new int[this.pkParam.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.pkParam[i].column.indexOf(queryType);
        }
        return nArray;
    }

    private int getPrimaryKeyColumn() {
        return SingletonTable.getPrimaryKeyColumn(this.getPrimaryKeyColumns());
    }

    private static int getPrimaryKeyColumn(int[] nArray) {
        for (int n : nArray) {
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    private void setPrimaryKeyParameter(PreparedStatement preparedStatement, Comparable<?> comparable) throws SQLException {
        Comparable<Object>[] comparableArray = comparable instanceof MultiColumnIdentifier ? ((MultiColumnIdentifier)comparable).getIdentifiers() : new Comparable[]{comparable};
        if (comparableArray.length != this.pkParam.length) {
            throw new CatalogException(this.errors().getString(109));
        }
        for (int i = 0; i < comparableArray.length; ++i) {
            Comparable<?> comparable2 = comparableArray[i];
            int n = this.indexOf(this.pkParam[i]);
            if (comparable2 instanceof Number) {
                preparedStatement.setInt(n, ((Number)((Object)comparable2)).intValue());
                continue;
            }
            preparedStatement.setString(n, comparable2.toString());
        }
    }

    private static boolean isNumeric(ResultSet resultSet, int n) throws SQLException {
        Class<?> clazz;
        if (n != 0 && (clazz = TypeMapper.toJavaType(resultSet.getMetaData().getColumnType(n))) != null) {
            return Number.class.isAssignableFrom(clazz);
        }
        return false;
    }

    @Override
    final boolean wantsAutoGeneratedKeys() {
        return this.getQueryType() == QueryType.INSERT;
    }

    protected Comparable<?> createIdentifier(ResultSet resultSet, int[] nArray) throws SQLException {
        if (nArray.length == 1) {
            return null;
        }
        resultSet.close();
        throw new CatalogException(this.errors().getString(243, (Object)this.getQueryType()));
    }

    protected abstract E createEntry(LocalCache var1, ResultSet var2, Comparable<?> var3) throws CatalogException, SQLException;

    private E createEntryCatchSQL(LocalCache localCache, ResultSet resultSet, Comparable<?> comparable) throws CatalogException, SQLException {
        CatalogException catalogException;
        try {
            return this.createEntry(localCache, resultSet, comparable);
        }
        catch (CatalogException catalogException2) {
            if (catalogException2.isMetadataInitialized()) {
                throw catalogException2;
            }
            catalogException = catalogException2;
        }
        catch (SQLException sQLException) {
            catalogException = new CatalogException(sQLException);
        }
        catalogException.setMetadata(this, resultSet, this.getPrimaryKeyColumn(), comparable);
        catalogException.clearColumnName();
        throw catalogException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E getEntry(Comparable<?> comparable) throws NoSuchRecordException, SQLException {
        Entry entry;
        block11: {
            if (comparable == null) {
                return null;
            }
            entry = (Entry)this.cache.peek(comparable);
            if (entry == null) {
                Cache.Handler<E> handler = this.cache.lock(comparable);
                try {
                    LocalCache localCache;
                    entry = (Entry)handler.peek();
                    if (entry != null) break block11;
                    LocalCache localCache2 = localCache = this.getLocalCache();
                    synchronized (localCache2) {
                        LocalCache.Stmt stmt = this.getStatement(localCache, QueryType.SELECT);
                        PreparedStatement preparedStatement = stmt.statement;
                        this.setPrimaryKeyParameter(preparedStatement, comparable);
                        ResultSet resultSet = preparedStatement.executeQuery();
                        while (resultSet.next()) {
                            E e = this.createEntryCatchSQL(localCache, resultSet, comparable);
                            if (entry == null) {
                                entry = e;
                                continue;
                            }
                            if (((Object)entry).equals(e)) continue;
                            throw new DuplicatedRecordException(this, resultSet, this.getPrimaryKeyColumn(), comparable);
                        }
                        if (entry == null) {
                            throw new NoSuchRecordException(this, resultSet, this.getPrimaryKeyColumn(), comparable);
                        }
                        resultSet.close();
                        this.release(localCache, stmt);
                    }
                }
                finally {
                    handler.putAndUnlock(entry);
                }
            }
        }
        return (E)entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<E> getEntries() throws SQLException {
        LocalCache localCache;
        LinkedHashSet<Entry> linkedHashSet = new LinkedHashSet<Entry>();
        LocalCache localCache2 = localCache = this.getLocalCache();
        synchronized (localCache2) {
            LocalCache.Stmt stmt;
            try {
                stmt = this.getStatement(localCache, QueryType.LIST);
            }
            catch (SQLDataException sQLDataException) {
                Logging.recoverableException(this.getLogger(), this.getClass(), "getEntries", sQLDataException);
                return linkedHashSet;
            }
            int[] nArray = this.getPrimaryKeyColumns();
            int n = SingletonTable.getPrimaryKeyColumn(nArray);
            ResultSet resultSet = stmt.statement.executeQuery();
            Boolean bl = null;
            while (resultSet.next()) {
                Entry entry;
                Comparable<?> comparable = this.createIdentifier(resultSet, nArray);
                if (comparable == null) {
                    if (bl == null) {
                        bl = SingletonTable.isNumeric(resultSet, n);
                    }
                    comparable = bl != false ? Integer.valueOf(resultSet.getInt(n)) : resultSet.getString(n);
                }
                if ((entry = (Entry)this.cache.peek(comparable)) == null) {
                    Cache.Handler<E> handler = this.cache.lock(comparable);
                    try {
                        entry = (Entry)handler.peek();
                        if (entry == null) {
                            entry = this.createEntryCatchSQL(localCache, resultSet, comparable);
                        }
                    }
                    finally {
                        handler.putAndUnlock(entry);
                    }
                }
                if (linkedHashSet.add(entry)) continue;
                throw new DuplicatedRecordException(this, resultSet, n, comparable);
            }
            resultSet.close();
            this.release(localCache, stmt);
        }
        return linkedHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getIdentifiers() throws SQLException {
        LocalCache localCache;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        LocalCache localCache2 = localCache = this.getLocalCache();
        synchronized (localCache2) {
            LocalCache.Stmt stmt = this.getStatement(localCache, QueryType.LIST_ID);
            ResultSet resultSet = stmt.statement.executeQuery();
            int n = this.getPrimaryKeyColumn();
            while (resultSet.next()) {
                linkedHashSet.add(resultSet.getString(n));
            }
            resultSet.close();
            this.release(localCache, stmt);
        }
        return linkedHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(Comparable<?> comparable) throws SQLException {
        boolean bl;
        LocalCache localCache;
        if (comparable == null) {
            return false;
        }
        if (this.cache.containsKey(comparable)) {
            return true;
        }
        LocalCache localCache2 = localCache = this.getLocalCache();
        synchronized (localCache2) {
            LocalCache.Stmt stmt = this.getStatement(localCache, QueryType.EXISTS);
            PreparedStatement preparedStatement = stmt.statement;
            this.setPrimaryKeyParameter(preparedStatement, comparable);
            ResultSet resultSet = preparedStatement.executeQuery();
            bl = resultSet.next();
            resultSet.close();
            this.release(localCache, stmt);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(Comparable<?> comparable) throws SQLException {
        int n;
        LocalCache localCache;
        if (comparable == null) {
            return 0;
        }
        boolean bl = false;
        LocalCache localCache2 = localCache = this.getLocalCache();
        synchronized (localCache2) {
            this.transactionBegin(localCache);
            try {
                LocalCache.Stmt stmt = this.getStatement(localCache, QueryType.DELETE);
                PreparedStatement preparedStatement = stmt.statement;
                this.setPrimaryKeyParameter(preparedStatement, comparable);
                n = this.update(preparedStatement);
                this.release(localCache, stmt);
                bl = true;
            }
            finally {
                this.transactionEnd(localCache, bl);
            }
        }
        this.cache.remove(comparable);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteAll() throws SQLException {
        int n;
        LocalCache localCache;
        boolean bl = false;
        LocalCache localCache2 = localCache = this.getLocalCache();
        synchronized (localCache2) {
            this.transactionBegin(localCache);
            try {
                LocalCache.Stmt stmt = this.getStatement(localCache, QueryType.DELETE_ALL);
                n = this.update(stmt.statement);
                this.release(localCache, stmt);
                bl = true;
            }
            finally {
                this.transactionEnd(localCache, bl);
            }
        }
        this.cache.clear();
        return n;
    }

    private int update(PreparedStatement preparedStatement) throws SQLException {
        Database database = this.getDatabase();
        database.ensureOngoingTransaction();
        return preparedStatement.executeUpdate();
    }

    protected final boolean updateSingleton(PreparedStatement preparedStatement) throws IllegalUpdateException, SQLException {
        int n = this.update(preparedStatement);
        if (n > 1) {
            throw new IllegalUpdateException(this.getLocale(), n);
        }
        return n != 0;
    }

    protected final String searchFreeIdentifier(LocalCache localCache, String string) throws SQLException {
        if (this.generator == null) {
            if (this.pkParam.length == 0) {
                throw new UnsupportedOperationException();
            }
            this.generator = this.getDatabase().getIdentifierGenerator(localCache, this.pkParam[0].column.name);
        }
        return this.generator.identifier(this.query.schema, this.query.table, string);
    }
}

