/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.measure;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.math.XMath;
import org.geotoolkit.measure.Angle;
import org.geotoolkit.measure.Latitude;
import org.geotoolkit.measure.Longitude;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.logging.LoggedFormat;

public class AngleFormat
extends Format {
    private static final long serialVersionUID = 4320403817210439764L;
    private static final char NORTH = 'N';
    private static final char SOUTH = 'S';
    private static final char EAST = 'E';
    private static final char WEST = 'W';
    static final int LONGITUDE = 0;
    static final int LATITUDE = 1;
    static final int ALTITUDE = 2;
    private static final int PREFIX_FIELD = -1;
    public static final int DEGREES_FIELD = 0;
    public static final int MINUTES_FIELD = 1;
    public static final int SECONDS_FIELD = 2;
    public static final int HEMISPHERE_FIELD = 3;
    private static final char[] SYMBOLS = new char[]{'D', 'M', 'S'};
    private int width0 = 1;
    private int width1 = 2;
    private int width2 = 0;
    private int widthDecimal = 0;
    private String prefix = null;
    private String suffix0 = "\u00b0";
    private String suffix1 = "\u2032";
    private String suffix2 = "\u2033";
    private boolean decimalSeparator = true;
    private final DecimalFormat numberFormat;
    private transient FieldPosition dummy = new FieldPosition(0);

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.dummy = new FieldPosition(0);
    }

    private int getWidth(int n) {
        switch (n) {
            case 0: {
                return this.width0;
            }
            case 1: {
                return this.width1;
            }
            case 2: {
                return this.width2;
            }
        }
        return 0;
    }

    private void setWidth(int n, int n2) {
        switch (n) {
            case 0: {
                this.width0 = n2;
                n2 = 0;
            }
            case 1: {
                this.width1 = n2;
                n2 = 0;
            }
            case 2: {
                this.width2 = n2;
            }
        }
    }

    private String getSuffix(int n) {
        switch (n) {
            case -1: {
                return this.prefix;
            }
            case 0: {
                return this.suffix0;
            }
            case 1: {
                return this.suffix1;
            }
            case 2: {
                return this.suffix2;
            }
        }
        return null;
    }

    private void setSuffix(int n, String string) {
        switch (n) {
            case -1: {
                this.prefix = string;
                string = "\u00b0";
            }
            case 0: {
                this.suffix0 = string;
                string = "\u2032";
            }
            case 1: {
                this.suffix1 = string;
                string = "\u2033";
            }
            case 2: {
                this.suffix2 = string;
            }
        }
    }

    public static AngleFormat getInstance() {
        return new AngleFormat();
    }

    public static AngleFormat getInstance(Locale locale) {
        return new AngleFormat("D\u00b0MM.m\u2032", locale);
    }

    public AngleFormat() {
        this("D\u00b0MM.m\u2032");
    }

    public AngleFormat(String string) throws IllegalArgumentException {
        this(string, new DecimalFormatSymbols());
    }

    public AngleFormat(String string, Locale locale) throws IllegalArgumentException {
        this(string, new DecimalFormatSymbols(locale));
    }

    public AngleFormat(String string, DecimalFormatSymbols decimalFormatSymbols) {
        this.numberFormat = new DecimalFormat("#0", decimalFormatSymbols);
        this.applyPattern(string);
    }

    public void applyPattern(String string) throws IllegalArgumentException {
        this.widthDecimal = 0;
        this.decimalSeparator = true;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = string.length();
        block4: for (int i = 0; i < n3; ++i) {
            char c = string.charAt(i);
            char c2 = Character.toUpperCase(c);
            for (int j = 0; j < SYMBOLS.length; ++j) {
                int n4;
                if (c2 != SYMBOLS[j]) continue;
                if (c == c2) {
                    ++n2;
                }
                if (j != n2 - 1 || bl) {
                    this.setWidth(0, 1);
                    this.setSuffix(-1, null);
                    this.widthDecimal = 0;
                    this.decimalSeparator = true;
                    throw new IllegalArgumentException(Errors.format(71, string));
                }
                if (c == c2) {
                    this.setSuffix(j - 1, i > n ? string.substring(n, i) : null);
                    n4 = 1;
                    while (++i < n3 && string.charAt(i) == c) {
                        ++n4;
                    }
                    this.setWidth(j, n4);
                } else {
                    switch (i - n) {
                        case 0: {
                            this.decimalSeparator = false;
                            break;
                        }
                        case 1: {
                            if (string.charAt(n) == '.') {
                                this.decimalSeparator = true;
                                break;
                            }
                        }
                        default: {
                            throw new IllegalArgumentException(Errors.format(71, string));
                        }
                    }
                    n4 = 1;
                    while (++i < n3 && string.charAt(i) == c) {
                        ++n4;
                    }
                    this.widthDecimal = n4;
                    bl = true;
                }
                n = i--;
                continue block4;
            }
        }
        this.setSuffix(n2 - 1, n < n3 ? string.substring(n) : null);
    }

    public String toPattern() {
        char c = '#';
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i <= SYMBOLS.length; ++i) {
            String string = this.getSuffix(i - 1);
            int n = this.getWidth(i);
            if (n > 0) {
                if (string != null) {
                    stringBuilder.append(string);
                }
                c = SYMBOLS[i];
                do {
                    stringBuilder.append(c);
                } while (--n > 0);
                continue;
            }
            n = this.widthDecimal;
            if (n > 0) {
                if (this.decimalSeparator) {
                    stringBuilder.append('.');
                }
                c = Character.toLowerCase(c);
                do {
                    stringBuilder.append(c);
                } while (--n > 0);
            }
            if (string == null) break;
            stringBuilder.append(string);
            break;
        }
        return stringBuilder.toString();
    }

    public final String format(double d) {
        return this.format(d, new StringBuffer(), (FieldPosition)null).toString();
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        int n;
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return this.numberFormat.format(d, stringBuffer, fieldPosition != null ? fieldPosition : new FieldPosition(0));
        }
        double d2 = d;
        double d3 = Double.NaN;
        double d4 = Double.NaN;
        if (this.width1 != 0 && !Double.isNaN(d)) {
            n = (int)d2;
            d3 = Math.abs(d2 - (double)n) * 60.0;
            d2 = n;
            if (d3 < 0.0 || d3 > 60.0) {
                throw new IllegalArgumentException(Errors.format(2, d));
            }
            if (this.width2 != 0) {
                n = (int)d3;
                d4 = (d3 - (double)n) * 60.0;
                d3 = n;
                if (d4 < 0.0 || d4 > 60.0) {
                    throw new IllegalArgumentException(Errors.format(2, d));
                }
                double d5 = XMath.pow10(this.widthDecimal);
                d4 = Math.rint(d4 * d5) / d5;
                n = (int)(d4 / 60.0);
                d4 -= (double)(60 * n);
                d3 += (double)n;
            } else {
                double d6 = XMath.pow10(this.widthDecimal);
                d3 = Math.rint(d3 * d6) / d6;
            }
            n = (int)(d3 / 60.0);
            d3 -= (double)(60 * n);
            d2 += (double)n;
        }
        if (this.prefix != null) {
            stringBuffer.append(this.prefix);
        }
        if (fieldPosition != null) {
            n = fieldPosition.getField();
            fieldPosition.setBeginIndex(0);
            fieldPosition.setEndIndex(0);
        } else {
            n = -1;
        }
        stringBuffer = this.formatField(d2, stringBuffer, n == 0 ? fieldPosition : null, this.width0, this.width1 == 0, this.suffix0);
        if (!Double.isNaN(d3)) {
            stringBuffer = this.formatField(d3, stringBuffer, n == 1 ? fieldPosition : null, this.width1, this.width2 == 0, this.suffix1);
        }
        if (!Double.isNaN(d4)) {
            stringBuffer = this.formatField(d4, stringBuffer, n == 2 ? fieldPosition : null, this.width2, true, this.suffix2);
        }
        return stringBuffer;
    }

    private StringBuffer formatField(double d, StringBuffer stringBuffer, FieldPosition fieldPosition, int n, boolean bl, String string) {
        int n2 = stringBuffer.length();
        if (!bl) {
            this.numberFormat.setMinimumIntegerDigits(n);
            this.numberFormat.setMaximumFractionDigits(0);
            stringBuffer = this.numberFormat.format(d, stringBuffer, this.dummy);
        } else if (this.decimalSeparator) {
            this.numberFormat.setMinimumIntegerDigits(n);
            this.numberFormat.setMinimumFractionDigits(this.widthDecimal);
            this.numberFormat.setMaximumFractionDigits(this.widthDecimal);
            stringBuffer = this.numberFormat.format(d, stringBuffer, this.dummy);
        } else {
            this.numberFormat.setMaximumFractionDigits(0);
            this.numberFormat.setMinimumIntegerDigits(n + this.widthDecimal);
            stringBuffer = this.numberFormat.format(d *= XMath.pow10(this.widthDecimal), stringBuffer, this.dummy);
        }
        if (string != null) {
            stringBuffer.append(string);
        }
        if (fieldPosition != null) {
            fieldPosition.setBeginIndex(n2);
            fieldPosition.setEndIndex(stringBuffer.length() - 1);
        }
        return stringBuffer;
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("obj", object);
        if (object instanceof Latitude) {
            return this.format(((Latitude)object).degrees(), stringBuffer, fieldPosition, 'N', 'S');
        }
        if (object instanceof Longitude) {
            return this.format(((Longitude)object).degrees(), stringBuffer, fieldPosition, 'E', 'W');
        }
        if (object instanceof Angle) {
            return this.format(((Angle)object).degrees(), stringBuffer, fieldPosition);
        }
        if (object instanceof Number) {
            this.numberFormat.setMinimumIntegerDigits(1);
            InternalUtilities.configure(this.numberFormat, ((Number)object).doubleValue(), 6);
            return this.numberFormat.format(object, stringBuffer, fieldPosition != null ? fieldPosition : this.dummy);
        }
        throw new IllegalArgumentException(Errors.format(141, object.getClass()));
    }

    final StringBuffer format(double d, int n, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        switch (n) {
            default: {
                throw new IllegalArgumentException(Integer.toString(n));
            }
            case 1: {
                return this.format(d, stringBuffer, fieldPosition, 'N', 'S');
            }
            case 0: {
                return this.format(d, stringBuffer, fieldPosition, 'E', 'W');
            }
            case 2: 
        }
        this.numberFormat.setMinimumIntegerDigits(1);
        InternalUtilities.configure(this.numberFormat, d, 6);
        return this.numberFormat.format(d, stringBuffer, fieldPosition != null ? fieldPosition : this.dummy);
    }

    private StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition, char c, char c2) {
        stringBuffer = this.format(Math.abs(d), stringBuffer, fieldPosition);
        int n = stringBuffer.length();
        stringBuffer.append(d < 0.0 ? c2 : c);
        if (fieldPosition != null && fieldPosition.getField() == 3) {
            fieldPosition.setBeginIndex(n);
            fieldPosition.setEndIndex(stringBuffer.length() - 1);
        }
        return stringBuffer;
    }

    private int skipSuffix(String string, ParsePosition parsePosition, int n) {
        char c;
        int n2;
        int n3 = string.length();
        int n4 = parsePosition.getIndex();
        for (n2 = SYMBOLS.length; n2 >= 0; --n2) {
            int n5 = n4;
            String string2 = this.getSuffix(n);
            if (string2 != null) {
                int n6 = string2.length();
                do {
                    if (!string.regionMatches(n5, string2, 0, n6)) continue;
                    parsePosition.setIndex(n5 + n6);
                    return n;
                } while (n5 < n3 && Character.isSpaceChar(string.charAt(n5++)));
            }
            if (++n < SYMBOLS.length) continue;
            n = -1;
        }
        do {
            if (n4 >= n3) {
                return SYMBOLS.length;
            }
            c = string.charAt(n4++);
            n2 = c;
        } while (Character.isSpaceChar(c));
        switch (n2) {
            case 176: {
                parsePosition.setIndex(n4);
                return 0;
            }
            case 39: 
            case 8242: {
                parsePosition.setIndex(n4);
                return 1;
            }
            case 34: 
            case 8243: {
                parsePosition.setIndex(n4);
                return 2;
            }
        }
        return SYMBOLS.length;
    }

    public Angle parse(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition, false);
    }

    private Angle parse(String string, ParsePosition parsePosition, boolean bl) {
        double d = Double.NaN;
        double d2 = Double.NaN;
        double d3 = Double.NaN;
        int n = string.length();
        int n2 = parsePosition.getIndex();
        int n3 = this.skipSuffix(string, parsePosition, -1);
        if (n3 >= 0 && n3 < SYMBOLS.length) {
            parsePosition.setErrorIndex(n2);
            parsePosition.setIndex(n2);
            return null;
        }
        for (n3 = parsePosition.getIndex(); n3 < n && Character.isSpaceChar(string.charAt(n3)); ++n3) {
        }
        parsePosition.setIndex(n3);
        Number number = this.numberFormat.parse(string, parsePosition);
        if (number == null) {
            parsePosition.setIndex(n2);
            if (parsePosition.getErrorIndex() < n2) {
                parsePosition.setErrorIndex(n3);
            }
            return null;
        }
        d = number.doubleValue();
        int n4 = parsePosition.getIndex();
        boolean bl2 = true;
        block0 : switch (this.skipSuffix(string, parsePosition, 0)) {
            case -1: {
                parsePosition.setIndex(n4);
                break;
            }
            case 2: {
                d3 = d;
                d = Double.NaN;
                break;
            }
            default: {
                if (this.width1 == 0 || !bl) break;
            }
            case 0: {
                int n5 = n3 = parsePosition.getIndex();
                while (n3 < n && Character.isSpaceChar(string.charAt(n3))) {
                    ++n3;
                }
                if (!bl && n3 != n5) break;
                parsePosition.setIndex(n3);
                number = this.numberFormat.parse(string, parsePosition);
                if (number == null) {
                    parsePosition.setIndex(n5);
                    break;
                }
                n4 = parsePosition.getIndex();
                d2 = number.doubleValue();
                switch (this.skipSuffix(string, parsePosition, this.width1 != 0 ? 1 : -1)) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        d3 = d2;
                        d2 = Double.NaN;
                        break block0;
                    }
                    default: {
                        if (this.width1 != 0) break;
                    }
                    case 0: {
                        parsePosition.setIndex(n5);
                        d2 = Double.NaN;
                        break block0;
                    }
                    case -1: {
                        parsePosition.setIndex(n4);
                        break block0;
                    }
                }
                bl2 = false;
            }
            case 1: {
                if (bl2) {
                    d2 = d;
                    d = Double.NaN;
                }
                int n5 = n3 = parsePosition.getIndex();
                while (n3 < n && Character.isSpaceChar(string.charAt(n3))) {
                    ++n3;
                }
                if (!bl && n3 != n5) break;
                parsePosition.setIndex(n3);
                number = this.numberFormat.parse(string, parsePosition);
                if (number == null) {
                    parsePosition.setIndex(n5);
                    break;
                }
                n4 = parsePosition.getIndex();
                d3 = number.doubleValue();
                switch (this.skipSuffix(string, parsePosition, this.width2 != 0 ? 1 : -1)) {
                    case 2: {
                        break block0;
                    }
                    default: {
                        if (this.width2 != 0) break block0;
                    }
                    case 0: 
                    case 1: {
                        parsePosition.setIndex(n5);
                        d3 = Double.NaN;
                        break block0;
                    }
                    case -1: {
                        parsePosition.setIndex(n4);
                        break block0;
                    }
                }
            }
        }
        if (d2 < 0.0) {
            d3 = -d3;
        }
        if (d < 0.0) {
            d2 = -d2;
            d3 = -d3;
        }
        if (!this.decimalSeparator) {
            double d4 = XMath.pow10(this.widthDecimal);
            if (this.width2 != 0) {
                if (this.suffix1 == null && Double.isNaN(d3)) {
                    if (this.suffix0 == null && Double.isNaN(d2)) {
                        d /= d4;
                    } else {
                        d2 /= d4;
                    }
                } else {
                    d3 /= d4;
                }
            } else if (Double.isNaN(d3)) {
                if (this.width1 != 0) {
                    if (this.suffix0 == null && Double.isNaN(d2)) {
                        d /= d4;
                    } else {
                        d2 /= d4;
                    }
                } else if (Double.isNaN(d2)) {
                    d /= d4;
                }
            }
        }
        if (this.suffix1 == null && this.width2 != 0 && Double.isNaN(d3)) {
            double d5 = XMath.pow10(this.width2);
            if (this.suffix0 == null && this.width1 != 0 && Double.isNaN(d2)) {
                d3 = d;
                d2 = (int)(d / d5);
                d3 -= d2 * d5;
                d5 = XMath.pow10(this.width1);
                d = (int)(d2 / d5);
                d2 -= d * d5;
            } else {
                d3 = d2;
                d2 = (int)(d2 / d5);
                d3 -= d2 * d5;
            }
        } else if (this.suffix0 == null && this.width1 != 0 && Double.isNaN(d2)) {
            double d6 = XMath.pow10(this.width1);
            d2 = d;
            d = (int)(d / d6);
            d2 -= d * d6;
        }
        parsePosition.setErrorIndex(-1);
        if (Double.isNaN(d)) {
            d = 0.0;
        }
        if (!Double.isNaN(d2)) {
            d += d2 / 60.0;
        }
        if (!Double.isNaN(d3)) {
            d += d3 / 3600.0;
        }
        for (int i = parsePosition.getIndex(); i < n; ++i) {
            n3 = string.charAt(i);
            switch (Character.toUpperCase((char)n3)) {
                case 'N': {
                    parsePosition.setIndex(i + 1);
                    return new Latitude(d);
                }
                case 'S': {
                    parsePosition.setIndex(i + 1);
                    return new Latitude(-d);
                }
                case 'E': {
                    parsePosition.setIndex(i + 1);
                    return new Longitude(d);
                }
                case 'W': {
                    parsePosition.setIndex(i + 1);
                    return new Longitude(-d);
                }
            }
            if (!Character.isSpaceChar((char)n3)) break;
        }
        return new Angle(d);
    }

    public Angle parse(String string) throws ParseException {
        int n;
        ParsePosition parsePosition = new ParsePosition(0);
        Angle angle = this.parse(string, parsePosition, true);
        int n2 = string.length();
        for (int i = n = parsePosition.getIndex(); i < n2; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            i = Math.max(n, parsePosition.getErrorIndex());
            throw new ParseException(LoggedFormat.formatUnparsable(string, 0, i, null), i);
        }
        return angle;
    }

    @Override
    public Angle parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    @Override
    public Angle parseObject(String string) throws ParseException {
        return this.parse(string);
    }

    final Number parseNumber(String string, ParsePosition parsePosition) {
        return this.numberFormat.parse(string, parsePosition);
    }

    public int hashCode() {
        int n = -1693325228;
        if (this.decimalSeparator) {
            n ^= 0xFF;
        }
        n = Utilities.hash(this.prefix, Utilities.hash(this.suffix0, Utilities.hash(this.suffix1, Utilities.hash(this.suffix2, n))));
        return n ^ ((this.width0 << 8 ^ this.width1) << 8 ^ this.width2) << 8 ^ this.widthDecimal;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            AngleFormat angleFormat = (AngleFormat)object;
            return this.width0 == angleFormat.width0 && this.width1 == angleFormat.width1 && this.width2 == angleFormat.width2 && this.widthDecimal == angleFormat.widthDecimal && this.decimalSeparator == angleFormat.decimalSeparator && Utilities.equals(this.prefix, angleFormat.prefix) && Utilities.equals(this.suffix0, angleFormat.suffix0) && Utilities.equals(this.suffix1, angleFormat.suffix1) && Utilities.equals(this.suffix2, angleFormat.suffix2) && Utilities.equals(this.numberFormat.getDecimalFormatSymbols(), angleFormat.numberFormat.getDecimalFormatSymbols());
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.toPattern() + ']';
    }
}

