/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.citation;

import java.net.URI;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.metadata.iso.MetadataEntity;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.util.InternationalString;

@ThreadSafe
@XmlType(name="CI_OnlineResource_Type", propOrder={"linkage", "protocol", "applicationProfile", "name", "description", "function"})
@XmlRootElement(name="CI_OnlineResource")
public class DefaultOnlineResource
extends MetadataEntity
implements OnlineResource {
    private static final long serialVersionUID = 5412370008274334799L;
    static final OnlineResource ISO;
    static final OnlineResource OGC;
    static final OnlineResource OPEN_GIS;
    static final OnlineResource EPSG;
    static final OnlineResource NETCDF;
    public static final OnlineResource GEOTIFF;
    static final OnlineResource PROJ4;
    static final OnlineResource ESRI;
    static final OnlineResource ORACLE;
    static final OnlineResource POSTGIS;
    static final OnlineResource SUN_MICROSYSTEMS;
    static final OnlineResource GEOTOOLKIT;
    static final OnlineResource GEOTOOLS;
    static final OnlineResource WMS;
    private String applicationProfile;
    private String name;
    private InternationalString description;
    private OnLineFunction function;
    private URI linkage;
    private String protocol;

    public DefaultOnlineResource() {
    }

    public DefaultOnlineResource(OnlineResource onlineResource) {
        super(onlineResource);
    }

    private DefaultOnlineResource(String string) {
        this.setLinkage(URI.create(string));
        this.setFunction(OnLineFunction.INFORMATION);
    }

    public DefaultOnlineResource(URI uRI) {
        if (uRI != null) {
            this.setLinkage(uRI);
        }
    }

    public static DefaultOnlineResource castOrCopy(OnlineResource onlineResource) {
        return onlineResource == null || onlineResource instanceof DefaultOnlineResource ? (DefaultOnlineResource)onlineResource : new DefaultOnlineResource(onlineResource);
    }

    @Override
    @XmlElement(name="applicationProfile")
    public synchronized String getApplicationProfile() {
        return this.applicationProfile;
    }

    public synchronized void setApplicationProfile(String string) {
        this.checkWritePermission();
        this.applicationProfile = string;
    }

    @Override
    @XmlElement(name="name")
    public synchronized String getName() {
        return this.name;
    }

    public synchronized void setName(String string) {
        this.checkWritePermission();
        this.name = string;
    }

    @Override
    @XmlElement(name="description")
    public synchronized InternationalString getDescription() {
        return this.description;
    }

    public synchronized void setDescription(InternationalString internationalString) {
        this.checkWritePermission();
        this.description = internationalString;
    }

    @Override
    @XmlElement(name="function")
    public synchronized OnLineFunction getFunction() {
        return this.function;
    }

    public synchronized void setFunction(OnLineFunction onLineFunction) {
        this.checkWritePermission();
        this.function = onLineFunction;
    }

    @Override
    @XmlElement(name="linkage", required=true)
    public synchronized URI getLinkage() {
        return this.linkage;
    }

    public synchronized void setLinkage(URI uRI) {
        this.checkWritePermission();
        this.linkage = uRI;
    }

    @Override
    @XmlElement(name="protocol")
    public synchronized String getProtocol() {
        return this.protocol;
    }

    public synchronized void setProtocol(String string) {
        this.checkWritePermission();
        this.protocol = string;
    }

    static {
        DefaultOnlineResource defaultOnlineResource = new DefaultOnlineResource("http://www.iso.org/");
        ISO = defaultOnlineResource;
        defaultOnlineResource.freeze();
        defaultOnlineResource = new DefaultOnlineResource("http://www.opengeospatial.org/");
        OGC = defaultOnlineResource;
        defaultOnlineResource.freeze();
        defaultOnlineResource = new DefaultOnlineResource("http://www.opengis.org");
        OPEN_GIS = defaultOnlineResource;
        defaultOnlineResource.freeze();
        defaultOnlineResource = new DefaultOnlineResource("http://www.epsg.org");
        EPSG = defaultOnlineResource;
        defaultOnlineResource.freeze();
        defaultOnlineResource = new DefaultOnlineResource("http://www.unidata.ucar.edu/software/netcdf-java");
        NETCDF = defaultOnlineResource;
        defaultOnlineResource.freeze();
        defaultOnlineResource = new DefaultOnlineResource("http://www.remotesensing.org/geotiff");
        GEOTIFF = defaultOnlineResource;
        defaultOnlineResource.freeze();
        defaultOnlineResource = new DefaultOnlineResource("http://trac.osgeo.org/proj");
        PROJ4 = defaultOnlineResource;
        defaultOnlineResource.freeze();
        defaultOnlineResource = new DefaultOnlineResource("http://www.esri.com");
        ESRI = defaultOnlineResource;
        defaultOnlineResource.freeze();
        defaultOnlineResource = new DefaultOnlineResource("http://www.oracle.com");
        ORACLE = defaultOnlineResource;
        defaultOnlineResource.freeze();
        defaultOnlineResource = new DefaultOnlineResource("http://postgis.refractions.net");
        POSTGIS = defaultOnlineResource;
        defaultOnlineResource.freeze();
        defaultOnlineResource = new DefaultOnlineResource("http://java.sun.com");
        SUN_MICROSYSTEMS = defaultOnlineResource;
        defaultOnlineResource.freeze();
        defaultOnlineResource = new DefaultOnlineResource("http://www.geotoolkit.org");
        GEOTOOLKIT = defaultOnlineResource;
        defaultOnlineResource.freeze();
        defaultOnlineResource = new DefaultOnlineResource("http://www.geotools.org");
        GEOTOOLS = defaultOnlineResource;
        defaultOnlineResource.freeze();
        defaultOnlineResource = new DefaultOnlineResource("http://portal.opengis.org/files/?artifact_id=5316");
        WMS = defaultOnlineResource;
        defaultOnlineResource.setFunction(OnLineFunction.DOWNLOAD);
        defaultOnlineResource.freeze();
    }
}

