/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import java.util.Collection;
import java.util.Collections;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.MathTransformDecorator;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.parameter.DefaultParameterDescriptor;
import org.geotoolkit.parameter.Parameters;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.operation.MathTransformProvider;
import org.geotoolkit.referencing.operation.provider.IdentifierCode;
import org.geotoolkit.referencing.operation.provider.PositionVector7Param;
import org.geotoolkit.referencing.operation.provider.UniversalParameters;
import org.geotoolkit.referencing.operation.transform.MolodenskyTransform;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.GenericName;

@Immutable
public class Molodensky
extends MathTransformProvider {
    private static final long serialVersionUID = 8126525068450868912L;
    @Deprecated
    public static final ParameterDescriptor<Integer> DIM = DefaultParameterDescriptor.create(Collections.singletonMap("name", new NamedIdentifier(Citations.OGC, "dim")), 2, 2, 3, false);
    static final ParameterDescriptor<Integer> SRC_DIM = PositionVector7Param.SRC_DIM;
    static final ParameterDescriptor<Integer> TGT_DIM = PositionVector7Param.TGT_DIM;
    @Deprecated
    public static final ParameterDescriptor<Double> DX = PositionVector7Param.DX;
    @Deprecated
    public static final ParameterDescriptor<Double> DY = PositionVector7Param.DY;
    @Deprecated
    public static final ParameterDescriptor<Double> DZ = PositionVector7Param.DZ;
    @Deprecated
    public static final ParameterDescriptor<Double> SRC_SEMI_MAJOR = UniversalParameters.createDescriptor(Molodensky.identifiers(PositionVector7Param.SRC_SEMI_MAJOR), Double.NaN, 0.0, Double.POSITIVE_INFINITY, SI.METRE, true);
    @Deprecated
    public static final ParameterDescriptor<Double> SRC_SEMI_MINOR = UniversalParameters.createDescriptor(Molodensky.identifiers(PositionVector7Param.SRC_SEMI_MINOR), Double.NaN, 0.0, Double.POSITIVE_INFINITY, SI.METRE, true);
    @Deprecated
    public static final ParameterDescriptor<Double> TGT_SEMI_MAJOR = UniversalParameters.createDescriptor(Molodensky.identifiers(PositionVector7Param.TGT_SEMI_MAJOR), Double.NaN, 0.0, Double.POSITIVE_INFINITY, SI.METRE, true);
    @Deprecated
    public static final ParameterDescriptor<Double> TGT_SEMI_MINOR = UniversalParameters.createDescriptor(Molodensky.identifiers(PositionVector7Param.TGT_SEMI_MINOR), Double.NaN, 0.0, Double.POSITIVE_INFINITY, SI.METRE, true);
    static final ParameterDescriptor<Double> AXIS_LENGTH_DIFFERENCE = UniversalParameters.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.EPSG, "Semi-major axis length difference")}, Double.NaN, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, SI.METRE, false);
    static final ParameterDescriptor<Double> FLATTENING_DIFFERENCE = UniversalParameters.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.EPSG, "Flattening difference")}, Double.NaN, -1.0, 1.0, Unit.ONE, false);
    public static final ParameterDescriptorGroup PARAMETERS = UniversalParameters.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier(Citations.OGC, "Molodenski"), new NamedIdentifier(Citations.EPSG, "Molodensky"), new IdentifierCode(Citations.EPSG, 9604), new NamedIdentifier(Citations.GEOTOOLKIT, Vocabulary.formatInternational(197))}, null, new ParameterDescriptor[]{DIM, SRC_DIM, TGT_DIM, DX, DY, DZ, SRC_SEMI_MAJOR, SRC_SEMI_MINOR, TGT_SEMI_MAJOR, TGT_SEMI_MINOR, AXIS_LENGTH_DIFFERENCE, FLATTENING_DIFFERENCE}, 0);
    final Molodensky[] complements;

    private static NamedIdentifier[] identifiers(ParameterDescriptor<Double> parameterDescriptor) {
        Collection<GenericName> collection = parameterDescriptor.getAlias();
        return collection.toArray(new NamedIdentifier[collection.size()]);
    }

    private static int index(int n, int n2) {
        return (n & 1) << 1 | n2 & 1;
    }

    public Molodensky() {
        this(2, 2, PARAMETERS, new Molodensky[4]);
        new Molodensky(2, 3, PARAMETERS, this.complements);
        new Molodensky(3, 2, PARAMETERS, this.complements);
        new Molodensky(3, 3, PARAMETERS, this.complements);
    }

    Molodensky(int n, int n2, ParameterDescriptorGroup parameterDescriptorGroup, Molodensky[] molodenskyArray) {
        super(n, n2, parameterDescriptorGroup);
        this.complements = molodenskyArray;
        int n3 = Molodensky.index(n, n2);
        if (molodenskyArray[n3] != null) {
            throw new AssertionError(n3);
        }
        molodenskyArray[n3] = this;
    }

    public Class<Transformation> getOperationType() {
        return Transformation.class;
    }

    private static int dimension(ParameterDescriptor<Integer> parameterDescriptor, ParameterValueGroup parameterValueGroup) throws InvalidParameterValueException {
        Integer n = Parameters.integerValue(parameterDescriptor, parameterValueGroup);
        if (n == null) {
            return 0;
        }
        int n2 = n;
        if (n2 != 2 && n2 != 3) {
            String string = parameterDescriptor.getName().getCode();
            throw new InvalidParameterValueException(Errors.format(73, string, n2), string, n2);
        }
        return n2;
    }

    @Override
    protected MathTransform createMathTransform(ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        int n = this.sourceDimension;
        int n2 = this.targetDimension;
        int n3 = Molodensky.dimension(DIM, parameterValueGroup);
        if (n3 != 0) {
            n = n2 = n3;
        }
        if ((n3 = Molodensky.dimension(SRC_DIM, parameterValueGroup)) != 0) {
            n = n3;
        }
        if ((n3 = Molodensky.dimension(TGT_DIM, parameterValueGroup)) != 0) {
            n2 = n3;
        }
        double d = Parameters.doubleValue(SRC_SEMI_MAJOR, parameterValueGroup);
        double d2 = Parameters.doubleValue(SRC_SEMI_MINOR, parameterValueGroup);
        double d3 = Parameters.doubleValue(AXIS_LENGTH_DIFFERENCE, parameterValueGroup);
        double d4 = Double.isNaN(d3) ? Parameters.doubleValue(TGT_SEMI_MAJOR, parameterValueGroup) : d + d3;
        d3 = Parameters.doubleValue(FLATTENING_DIFFERENCE, parameterValueGroup);
        double d5 = Double.isNaN(d3) ? Parameters.doubleValue(TGT_SEMI_MINOR, parameterValueGroup) : d4 * (d2 / d - d3);
        double d6 = Parameters.doubleValue(DX, parameterValueGroup);
        double d7 = Parameters.doubleValue(DY, parameterValueGroup);
        double d8 = Parameters.doubleValue(DZ, parameterValueGroup);
        MathTransform mathTransform = MolodenskyTransform.create(this.isAbridged(), d, d2, n == 3, d4, d5, n2 == 3, d6, d7, d8);
        Molodensky molodensky = this.complements[Molodensky.index(n, n2)];
        if (molodensky != this) {
            mathTransform = new MathTransformDecorator(mathTransform, molodensky);
        }
        return mathTransform;
    }

    boolean isAbridged() {
        return false;
    }
}

