/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.geotoolkit.lang.Static;
import org.geotoolkit.util.converter.ConverterRegistry;
import org.geotoolkit.util.converter.NonconvertibleObjectException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class DomUtilities
extends Static {
    private DomUtilities() {
    }

    public static Document read(Object input) throws ParserConfigurationException, SAXException, IOException {
        InputStream stream = DomUtilities.toInputStream(input);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder constructeur = factory.newDocumentBuilder();
        Document document = constructeur.parse(stream);
        stream.close();
        return document;
    }

    public static void write(Document doc, Object output) throws TransformerException, FileNotFoundException, IOException {
        StreamResult result;
        DOMSource source = new DOMSource(doc);
        if (output instanceof File) {
            result = new StreamResult((File)output);
        } else if (output instanceof Writer) {
            result = new StreamResult((Writer)output);
        } else {
            OutputStream stream = DomUtilities.toOutputStream(output);
            result = new StreamResult(stream);
        }
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer trs = factory.newTransformer();
        trs.setOutputProperty("indent", "yes");
        trs.setOutputProperty("encoding", "ISO-8859-1");
        trs.transform(source, result);
    }

    public static Element firstElement(Element parent, String tagName) {
        return DomUtilities.firstElement(parent, tagName, true);
    }

    public static Element firstElement(Element parent, String tagName, boolean recursive) {
        if (recursive) {
            NodeList lst = parent.getElementsByTagName(tagName);
            if (lst.getLength() > 0) {
                return (Element)lst.item(0);
            }
        } else {
            NodeList lst = parent.getChildNodes();
            int n = lst.getLength();
            for (int i = 0; i < n; ++i) {
                Node child = lst.item(i);
                if (!(child instanceof Element) || !tagName.equalsIgnoreCase(child.getLocalName())) continue;
                return (Element)child;
            }
        }
        return null;
    }

    public static List<Element> getListElements(Element parent, String tagName) {
        NodeList lst = parent.getElementsByTagName(tagName);
        ArrayList<Element> result = new ArrayList<Element>();
        int n = lst.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = lst.item(i);
            if (!(child instanceof Element) || !tagName.equalsIgnoreCase(child.getNodeName())) continue;
            result.add((Element)child);
        }
        return result;
    }

    public static Node getNodeByLocalName(Node parent, String name) {
        NodeList lst = parent.getChildNodes();
        int n = lst.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = lst.item(i);
            if (!name.equalsIgnoreCase(child.getLocalName())) continue;
            return child;
        }
        return null;
    }

    public static <T> T textValue(Element parent, String tagName, Class<T> clazz) throws NonconvertibleObjectException {
        Element ele = DomUtilities.firstElement(parent, tagName, true);
        if (ele == null) {
            return null;
        }
        String text = ele.getTextContent();
        if (text == null) {
            return null;
        }
        return ConverterRegistry.system().converter(String.class, clazz).convert(text);
    }

    public static <T> T textAttributeValue(Element parent, String tagName, String attributeName, Class<T> clazz) throws NonconvertibleObjectException {
        Element ele = DomUtilities.firstElement(parent, tagName, true);
        if (ele == null) {
            return null;
        }
        String text = ele.getAttribute(attributeName);
        if (text == null) {
            return null;
        }
        return ConverterRegistry.system().converter(String.class, clazz).convert(text);
    }

    public static <T> T textValueSafe(Element parent, String tagName, Class<T> clazz) {
        try {
            return DomUtilities.textValue(parent, tagName, clazz);
        }
        catch (NonconvertibleObjectException ex) {
            Logger.getLogger(DomUtilities.class.getName()).log(Level.WARNING, null, ex);
            return null;
        }
    }

    public static <T> T textAttributeValueSafe(Element parent, String tagName, String attributeName, Class<T> clazz) {
        try {
            return DomUtilities.textAttributeValue(parent, tagName, attributeName, clazz);
        }
        catch (NonconvertibleObjectException ex) {
            Logger.getLogger(DomUtilities.class.getName()).log(Level.WARNING, null, ex);
            return null;
        }
    }

    private static OutputStream toOutputStream(Object input) throws FileNotFoundException, IOException {
        if (input instanceof File) {
            return new FileOutputStream((File)((Object)input));
        }
        throw new IOException("Can not handle input type : " + (input != null ? input.getClass() : input));
    }

    private static InputStream toInputStream(Object input) throws FileNotFoundException, IOException {
        if (input instanceof InputStream) {
            return (InputStream)((Object)input);
        }
        if (input instanceof File) {
            return new FileInputStream((File)((Object)input));
        }
        if (input instanceof URI) {
            return ((URI)((Object)input)).toURL().openStream();
        }
        if (input instanceof URL) {
            return ((URL)((Object)input)).openStream();
        }
        if (input instanceof String) {
            try {
                return new URL((String)((Object)input)).openStream();
            }
            catch (Exception ex) {
                return new ByteArrayInputStream(((Object)input).toString().getBytes());
            }
        }
        throw new IOException("Can not handle input type : " + (input != null ? input.getClass() : input));
    }
}

