/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.paging;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import org.opengis.cite.iso19142.BaseFixture;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.FeatureTypeInfo;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.SuiteAttribute;
import org.opengis.cite.iso19142.util.DataSampler;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.WFSMessage;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class PagingTests
extends BaseFixture {
    private int cacheTimeout = 0;
    private DataSampler dataSampler;

    @BeforeClass
    public void initDataSample(ITestContext testContext) {
        this.dataSampler = (DataSampler)testContext.getSuite().getAttribute(SuiteAttribute.SAMPLER.getName());
    }

    @BeforeClass
    public void getPagingConstraints(ITestContext testContext) {
        Object obj = testContext.getAttribute("ResponseCacheTimeout");
        if (null != obj) {
            this.cacheTimeout = (Integer)Integer.class.cast(obj);
        }
    }

    @Test(description="See OGC 09-025: 7.7.4.2")
    public void getFeatureWithHitsOnly() {
        this.reqEntity = WFSMessage.createRequestEntity("GetFeature-Minimal", this.wfsVersion);
        this.reqEntity.getDocumentElement().setAttribute("count", "2");
        this.reqEntity.getDocumentElement().setAttribute("resultType", "hits");
        QName featureType = this.anyFeatureType(this.featureInfo);
        WFSMessage.appendSimpleQuery(this.reqEntity, featureType);
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "GetFeature", ProtocolBinding.GET);
        ClientResponse rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), ProtocolBinding.GET, endpoint);
        this.rspEntity = this.extractBodyAsDocument(rsp);
        ETSAssert.assertQualifiedName(this.rspEntity.getDocumentElement(), new QName("http://www.opengis.net/wfs/2.0", "FeatureCollection"));
        String numReturned = this.rspEntity.getDocumentElement().getAttribute("numberReturned");
        Assert.assertEquals((int)Integer.parseInt(numReturned), (int)0, (String)ErrorMessage.get("UnexpectedNumReturned"));
        String prev = this.rspEntity.getDocumentElement().getAttribute("previous");
        Assert.assertTrue((boolean)prev.isEmpty(), (String)"Unexpected attribute found in response entity: 'previous'.");
        String next = this.rspEntity.getDocumentElement().getAttribute("next");
        Assert.assertFalse((boolean)next.isEmpty(), (String)"Expected attribute not found in response entity: 'next'.");
        rsp = this.retrieveResource(next);
        this.rspEntity = this.extractBodyAsDocument(rsp);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        ETSAssert.assertQualifiedName(this.rspEntity.getDocumentElement(), new QName("http://www.opengis.net/wfs/2.0", "FeatureCollection"));
        numReturned = this.rspEntity.getDocumentElement().getAttribute("numberReturned");
        Assert.assertEquals((int)Integer.parseInt(numReturned), (int)2, (String)ErrorMessage.get("UnexpectedNumReturned"));
    }

    @Test(description="See OGC 09-025: 7.7.4.4.1")
    public void traverseResultSetInBothDirections() {
        QName featureType = this.featureTypeWithAtLeastTwoFeatures(this.featureInfo);
        if (featureType == null) {
            throw new SkipException("Could not find appropriate feature type. A feature type with at least two features is required.");
        }
        this.reqEntity = WFSMessage.createRequestEntity("GetFeature-Minimal", this.wfsVersion);
        int count = 1;
        this.reqEntity.getDocumentElement().setAttribute("count", Integer.toString(count));
        WFSMessage.appendSimpleQuery(this.reqEntity, featureType);
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "GetFeature", ProtocolBinding.GET);
        ClientResponse rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), ProtocolBinding.GET, endpoint);
        this.rspEntity = this.extractBodyAsDocument(rsp);
        ETSAssert.assertQualifiedName(this.rspEntity.getDocumentElement(), new QName("http://www.opengis.net/wfs/2.0", "FeatureCollection"));
        ETSAssert.assertFeatureCount(this.rspEntity, featureType, count);
        Set<String> initialMembers = WFSMessage.extractFeatureIdentifiers(this.rspEntity, featureType);
        String next = this.rspEntity.getDocumentElement().getAttribute("next");
        Assert.assertFalse((boolean)next.isEmpty(), (String)"Expected attribute not found in response entity: 'next'.");
        rsp = this.retrieveResource(next);
        this.rspEntity = this.extractBodyAsDocument(rsp);
        String prev = this.rspEntity.getDocumentElement().getAttribute("previous");
        Assert.assertFalse((boolean)prev.isEmpty(), (String)"Expected attribute not found in response entity: 'previous'.");
        rsp = this.retrieveResource(prev);
        this.rspEntity = this.extractBodyAsDocument(rsp);
        Set<String> prevMembers = WFSMessage.extractFeatureIdentifiers(this.rspEntity, featureType);
        Assert.assertTrue((boolean)prevMembers.containsAll(initialMembers), (String)String.format("Expected members of previous page to include all members of first page. \nFeature Identifiers: %s", initialMembers));
    }

    ClientResponse retrieveResource(String uriRef) {
        URI uri;
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Attempting to retrieve XML resource from {0}", uriRef);
        try {
            uri = new URI(uriRef);
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e.getMessage());
        }
        WebResource resource = this.wfsClient.getClient().resource(uri);
        ClientResponse rsp = (ClientResponse)resource.accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get(ClientResponse.class);
        return rsp;
    }

    QName anyFeatureType(Map<QName, FeatureTypeInfo> featureInfo) {
        QName qName = null;
        for (QName featureType : featureInfo.keySet()) {
            if (!featureInfo.get(featureType).isInstantiated()) continue;
            qName = featureType;
            break;
        }
        return qName;
    }

    QName featureTypeWithAtLeastTwoFeatures(Map<QName, FeatureTypeInfo> featureInfo) {
        for (Map.Entry<QName, FeatureTypeInfo> featureTypeNameToInfo : featureInfo.entrySet()) {
            QName featureTypeName;
            Set<String> featureId;
            FeatureTypeInfo featureTypeValue = featureTypeNameToInfo.getValue();
            if (!featureTypeValue.isInstantiated() || (featureId = this.dataSampler.selectRandomFeatureIdentifiers(featureTypeName = featureTypeNameToInfo.getKey(), 2)).size() <= 1) continue;
            return featureTypeName;
        }
        return null;
    }
}

