/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ConstantExpressionVisitor;
import org.apache.derby.impl.sql.compile.CursorNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.HasNodeVisitor;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.compile.StaticMethodCallNode;

abstract class DMLStatementNode
extends StatementNode {
    ResultSetNode resultSet;

    DMLStatementNode() {
    }

    public void init(Object object) {
        this.resultSet = (ResultSetNode)object;
    }

    public void printSubNodes(int n) {
    }

    public ResultSetNode getResultSetNode() {
        return this.resultSet;
    }

    QueryTreeNode bind(DataDictionary dataDictionary) throws StandardException {
        this.getCompilerContext().pushCurrentPrivType(this.getPrivType());
        try {
            this.bindTables(dataDictionary);
            this.bindExpressions();
        }
        finally {
            this.getCompilerContext().popCurrentPrivType();
        }
        return this;
    }

    public QueryTreeNode bindResultSetsWithTables(DataDictionary dataDictionary) throws StandardException {
        this.bindTables(dataDictionary);
        this.bindExpressionsWithTables();
        return this;
    }

    protected void bindTables(DataDictionary dataDictionary) throws StandardException {
        this.resultSet = this.resultSet.bindNonVTITables(dataDictionary, (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()));
        this.resultSet = this.resultSet.bindVTITables((FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()));
    }

    protected void bindExpressions() throws StandardException {
        FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
        this.resultSet.bindExpressions(fromList);
    }

    protected void bindExpressionsWithTables() throws StandardException {
        FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
        this.resultSet.bindExpressionsWithTables(fromList);
    }

    int activationKind() {
        List list = this.getCompilerContext().getParameterList();
        if (list != null && !list.isEmpty()) {
            return 2;
        }
        return 1;
    }

    public void optimizeStatement() throws StandardException {
        this.resultSet = this.resultSet.preprocess(this.getCompilerContext().getNumTables(), null, null);
        this.accept(new ConstantExpressionVisitor());
        this.resultSet = this.resultSet.optimize(this.getDataDictionary(), null, 1.0);
        this.resultSet = this.resultSet.modifyAccessPaths();
        if (this instanceof CursorNode) {
            ResultSetNode resultSetNode = this.resultSet;
            ResultColumnList resultColumnList = this.resultSet.getResultColumns();
            ResultColumnList resultColumnList2 = resultColumnList.copyListAndObjects();
            this.resultSet.setResultColumns(resultColumnList2);
            resultColumnList.genVirtualColumnNodes(this.resultSet, resultColumnList2);
            this.resultSet = (ResultSetNode)this.getNodeFactory().getNode(123, this.resultSet, resultColumnList, null, this.getContextManager());
            if (resultSetNode.getReferencedTableMap() != null) {
                this.resultSet.setReferencedTableMap((JBitSet)resultSetNode.getReferencedTableMap().clone());
            }
        }
    }

    public ResultDescription makeResultDescription() {
        ResultColumnDescriptor[] resultColumnDescriptorArray = this.resultSet.makeResultDescriptors();
        String string = this.statementToString();
        return this.getExecutionFactory().getResultDescription(resultColumnDescriptorArray, string);
    }

    void generateParameterValueSet(ActivationClassBuilder activationClassBuilder) throws StandardException {
        int n;
        List list = this.getCompilerContext().getParameterList();
        int n2 = n = list == null ? 0 : list.size();
        if (n <= 0) {
            return;
        }
        ParameterNode.generateParameterValueSet(activationClassBuilder, n, list);
    }

    public boolean isAtomic() throws StandardException {
        HasNodeVisitor hasNodeVisitor = new HasNodeVisitor(FromBaseTable.class, StaticMethodCallNode.class);
        this.accept(hasNodeVisitor);
        return hasNodeVisitor.hasNode();
    }

    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.resultSet != null) {
            this.resultSet = (ResultSetNode)this.resultSet.accept(visitor);
        }
    }

    int getPrivType() {
        return 0;
    }
}

