/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.provider;

import net.jcip.annotations.Immutable;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.referencing.operation.projection.Equirectangular;
import org.geotoolkit.referencing.operation.provider.IdentifierCode;
import org.geotoolkit.referencing.operation.provider.MapProjection;
import org.geotoolkit.referencing.operation.provider.UniversalParameters;
import org.geotoolkit.resources.Vocabulary;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform2D;

@Immutable
public class EquidistantCylindrical
extends MapProjection {
    private static final long serialVersionUID = -278288251842178001L;
    @Deprecated
    public static final ParameterDescriptor<Double> CENTRAL_MERIDIAN;
    @Deprecated
    public static final ParameterDescriptor<Double> LATITUDE_OF_ORIGIN;
    @Deprecated
    public static final ParameterDescriptor<Double> FALSE_EASTING;
    @Deprecated
    public static final ParameterDescriptor<Double> FALSE_NORTHING;
    public static final ParameterDescriptorGroup PARAMETERS;

    public EquidistantCylindrical() {
        super(PARAMETERS);
    }

    EquidistantCylindrical(ParameterDescriptorGroup parameterDescriptorGroup) {
        super(parameterDescriptorGroup);
    }

    public Class<CylindricalProjection> getOperationType() {
        return CylindricalProjection.class;
    }

    @Override
    protected MathTransform2D createMathTransform(ParameterValueGroup parameterValueGroup) {
        return Equirectangular.create(this.getParameters(), parameterValueGroup);
    }

    static {
        Citation[] citationArray = new Citation[]{Citations.NETCDF};
        CENTRAL_MERIDIAN = UniversalParameters.CENTRAL_MERIDIAN.select(null, null, citationArray, new String[]{"Longitude of false origin"}, "Longitude of natural origin", "central_meridian", "Central_Meridian", "ProjCenterLong");
        LATITUDE_OF_ORIGIN = UniversalParameters.LATITUDE_OF_ORIGIN.select(null, null, citationArray, new String[]{"Latitude of natural origin"}, "Latitude of 1st standard parallel", "latitude_of_origin", "Standard_Parallel_1", "ProjCenterLat");
        FALSE_EASTING = UniversalParameters.FALSE_EASTING.select(citationArray, "False easting", "FalseEasting");
        FALSE_NORTHING = UniversalParameters.FALSE_NORTHING.select(citationArray, "False northing", "FalseNorthing");
        PARAMETERS = UniversalParameters.createDescriptorGroup(new ReferenceIdentifier[]{new NamedIdentifier(Citations.OGC, "Equidistant_Cylindrical"), new NamedIdentifier((Citation)Citations.EPSG, "Equidistant Cylindrical"), new NamedIdentifier((Citation)Citations.EPSG, "Equidistant Cylindrical (Spherical)"), new IdentifierCode((Citation)Citations.EPSG, 1028), new IdentifierCode((Citation)Citations.EPSG, 1029), new IdentifierCode((Citation)Citations.EPSG, 9842, 1028), new IdentifierCode((Citation)Citations.EPSG, 9823, 1029), new NamedIdentifier(Citations.ESRI, "Equidistant_Cylindrical"), new NamedIdentifier(Citations.OGC, "Equirectangular"), new NamedIdentifier(Citations.GEOTIFF, "CT_Equirectangular"), new IdentifierCode(Citations.GEOTIFF, 17), new NamedIdentifier((Citation)Citations.PROJ4, "eqc"), new NamedIdentifier(Citations.GEOTOOLKIT, Vocabulary.formatInternational((int)97))}, citationArray, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, ROLL_LONGITUDE, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, FALSE_EASTING, FALSE_NORTHING}, 1);
    }
}

