/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry;

import org.geotoolkit.geometry.DirectPosition2D;
import org.geotoolkit.geometry.GeneralEnvelope;
import org.geotoolkit.referencing.CRS;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class DefaultBoundingBox
extends GeneralEnvelope
implements BoundingBox,
Envelope {
    public DefaultBoundingBox(CoordinateReferenceSystem crs) {
        super(crs);
    }

    public DefaultBoundingBox(Envelope env) {
        super(env);
    }

    public DefaultBoundingBox(BoundingBox bounds, CoordinateReferenceSystem crs) {
        super(crs);
        this.setBounds(bounds);
    }

    public DefaultBoundingBox(double[] min, double[] max) {
        super(min, max);
    }

    public void setBounds(BoundingBox bounds) {
        for (int dim = 0; dim < bounds.getDimension(); ++dim) {
            this.setRange(dim, bounds.getMinimum(dim), bounds.getMaximum(dim));
        }
    }

    public double getMinX() {
        return this.getMinimum(0);
    }

    public double getMaxX() {
        return this.getMaximum(0);
    }

    public double getMinY() {
        return this.getMinimum(1);
    }

    public double getMaxY() {
        return this.getMaximum(1);
    }

    public double getWidth() {
        return this.getSpan(0);
    }

    public double getHeight() {
        return this.getSpan(1);
    }

    public void include(BoundingBox bounds) {
        this.add((Envelope)bounds);
    }

    public void include(double x, double y) {
        this.add((DirectPosition)new DirectPosition2D(this.getCoordinateReferenceSystem(), x, y));
    }

    public boolean intersects(BoundingBox bounds) {
        return this.intersects((Envelope)bounds, true);
    }

    public boolean contains(BoundingBox bounds) {
        return this.contains((Envelope)bounds, true);
    }

    public boolean contains(double x, double y) {
        return this.contains((DirectPosition)new DirectPosition2D(this.getCoordinateReferenceSystem(), x, y));
    }

    public BoundingBox toBounds(CoordinateReferenceSystem targetCRS) throws TransformException {
        return new DefaultBoundingBox(CRS.getEnvelope((CoordinateReferenceSystem)targetCRS));
    }
}

