/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19136;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import javax.ws.rs.core.MediaType;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTerm;
import org.opengis.cite.iso19136.ErrorMessage;
import org.opengis.cite.iso19136.util.NamespaceBindings;
import org.opengis.cite.iso19136.util.TestSuiteLogger;
import org.opengis.cite.iso19136.util.XMLSchemaModelUtils;
import org.opengis.cite.iso19136.util.XMLUtils;
import org.opengis.cite.validation.SchematronValidator;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.testng.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;

public class ETSAssert {
    private ETSAssert() {
    }

    public static void assertQualifiedName(Node node, QName qName) {
        Assert.assertEquals((String)node.getLocalName(), (String)qName.getLocalPart(), (String)ErrorMessage.get("LocalName"));
        Assert.assertEquals((String)node.getNamespaceURI(), (String)qName.getNamespaceURI(), (String)ErrorMessage.get("NamespaceName"));
    }

    public static void assertXPath(String expr, Node context, Map<String, String> namespaceBindings) {
        Boolean result;
        if (null == context) {
            throw new NullPointerException("Context node is null.");
        }
        NamespaceBindings bindings = NamespaceBindings.withStandardBindings();
        bindings.addAllBindings(namespaceBindings);
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(bindings);
        try {
            result = (Boolean)xpath.evaluate(expr, context, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException xpe) {
            String msg = ErrorMessage.format("XPathError", expr);
            TestSuiteLogger.log(Level.WARNING, msg, xpe);
            throw new AssertionError((Object)msg);
        }
        Assert.assertTrue((boolean)result, (String)ErrorMessage.format("XPathResult", context.getNodeName(), expr));
    }

    public static void assertSchemaValid(Validator validator, Source source) {
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        validator.setErrorHandler((ErrorHandler)errHandler);
        try {
            validator.validate(source);
        }
        catch (Exception e) {
            throw new AssertionError((Object)ErrorMessage.format("XMLError", e.getMessage()));
        }
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)ErrorMessage.format("NotSchemaValid", errHandler.getErrorCount(), errHandler.toString()));
    }

    public static void assertSchematronValid(URL schemaRef, Source xmlSource) {
        SchematronValidator validator;
        try {
            validator = new SchematronValidator((Source)new StreamSource(schemaRef.toString()), "#ALL");
        }
        catch (Exception e) {
            StringBuilder msg = new StringBuilder("Failed to process Schematron schema at ");
            msg.append(schemaRef).append('\n');
            msg.append(e.getMessage());
            throw new AssertionError(msg);
        }
        Result result = validator.validate(xmlSource);
        Assert.assertFalse((boolean)validator.ruleViolationsDetected(), (String)ErrorMessage.format("NotSchemaValid", validator.getRuleViolationCount(), XMLUtils.resultToString(result)));
    }

    public static void assertURLIsResolvable(URL url, MediaType expectedMediaType) {
        MediaType contentType;
        int contentLength = 0;
        try {
            URLConnection urlConnection = url.openConnection();
            urlConnection.connect();
            contentLength = urlConnection.getContentLength();
            contentType = MediaType.valueOf((String)urlConnection.getContentType());
        }
        catch (IOException iox) {
            throw new AssertionError((Object)String.format("Failed to connect to URL %s \n %s", url.toString(), iox));
        }
        Assert.assertTrue((contentLength > 0 ? 1 : 0) != 0, (String)ErrorMessage.get("MissingEntity"));
        if (null != expectedMediaType) {
            Assert.assertEquals((Object)contentType, (Object)expectedMediaType, (String)ErrorMessage.get("UnexpectedMediaType"));
        }
    }

    public static void assertValidPropertyType(XSModel model, XSElementDeclaration propertyDecl, XSElementDeclaration head) {
        ETSAssert.assertValidPropertyType(model, propertyDecl, head, false);
    }

    public static void assertValidPropertyType(XSModel model, XSElementDeclaration propertyDecl, XSElementDeclaration head, boolean includeHeadInSubstition) {
        XSComplexTypeDefinition propTypeDef = (XSComplexTypeDefinition)propertyDecl.getTypeDefinition();
        String localName = propTypeDef.getAnonymous() ? propertyDecl.getName() : propTypeDef.getName();
        boolean isEmpty = propTypeDef.getContentType() == 0;
        XSObjectList attrUses = propTypeDef.getAttributeUses();
        if (isEmpty) {
            Assert.assertNotNull((Object)ETSAssert.getAttributeUseByName(attrUses, new QName("http://www.w3.org/1999/xlink", "href")), (String)ErrorMessage.format("AttribDeclRequired", "xlink:href", propTypeDef.getNamespace(), localName));
        } else {
            boolean isArrayProperty;
            XSParticle topParticle = propTypeDef.getParticle();
            if (topParticle.getMinOccurs() == 0) {
                Assert.assertNotNull((Object)ETSAssert.getAttributeUseByName(attrUses, new QName("http://www.w3.org/1999/xlink", "href")), (String)("Property value has minOccurs = 0. " + ErrorMessage.format("AttribDeclRequired", "xlink:href", propTypeDef.getNamespace(), localName)));
            }
            XSTerm term = topParticle.getTerm();
            Assert.assertTrue((boolean)XSModelGroup.class.isInstance(term), (String)ErrorMessage.format("ModelGroupExpected", propTypeDef.getNamespace(), localName));
            XSModelGroup group = (XSModelGroup)term;
            Assert.assertEquals((short)group.getCompositor(), (short)1, (String)ErrorMessage.format("SequenceExpected", propTypeDef.getNamespace(), localName));
            boolean bl = isArrayProperty = topParticle.getMaxOccursUnbounded() || topParticle.getMaxOccurs() > 1;
            if (isArrayProperty) {
                Assert.assertNull((Object)ETSAssert.getAttributeUseByName(attrUses, new QName("http://www.w3.org/1999/xlink", "href")), (String)ErrorMessage.format("AttribDeclProhibited", "xlink:href", propTypeDef.getNamespace(), localName));
            }
            Assert.assertTrue((group.getParticles().size() == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("TooManyParticles", propTypeDef.getNamespace(), localName));
            XSParticle particle = (XSParticle)group.getParticles().item(0);
            switch (particle.getTerm().getType()) {
                case 2: {
                    ETSAssert.assertSubstitition(model, head, propTypeDef, particle, includeHeadInSubstition);
                    break;
                }
                case 7: {
                    XSModelGroup modelGroup = (XSModelGroup)XSModelGroup.class.cast(particle.getTerm());
                    if (modelGroup.getCompositor() != 2) {
                        throw new AssertionError((Object)("Only a choice compositor is allowed. Found " + particle.getTerm().getClass().getName()));
                    }
                    ListIterator itr = modelGroup.getParticles().listIterator();
                    while (itr.hasNext()) {
                        XSParticle xsParticle = (XSParticle)itr.next();
                        if (xsParticle.getTerm().getType() != 2) {
                            throw new AssertionError((Object)"Only element declarations are allowed in choice compositor.");
                        }
                        ETSAssert.assertSubstitition(model, head, propTypeDef, xsParticle, includeHeadInSubstition);
                    }
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Wildcard component not permitted in property type: " + XMLSchemaModelUtils.getQName((XSObject)propTypeDef)));
                }
            }
        }
    }

    public static void assertDescendantElementCount(Document xmlEntity, QName elementName, int expectedCount) {
        NodeList features = xmlEntity.getElementsByTagNameNS(elementName.getNamespaceURI(), elementName.getLocalPart());
        Assert.assertEquals((int)features.getLength(), (int)expectedCount, (String)String.format("Unexpected number of %s descendant elements.", elementName));
    }

    private static XSAttributeUse getAttributeUseByName(XSObjectList attrUses, QName qName) {
        XSAttributeUse attrUse = null;
        for (int i = 0; i < attrUses.getLength(); ++i) {
            XSAttributeUse item = (XSAttributeUse)attrUses.item(i);
            XSAttributeDeclaration attrDecl = item.getAttrDeclaration();
            if (!attrDecl.getName().equals(qName.getLocalPart()) || attrDecl.getNamespace() != null && !attrDecl.getNamespace().equals(qName.getNamespaceURI())) continue;
            attrUse = item;
            break;
        }
        return attrUse;
    }

    private static void assertSubstitition(XSModel model, XSElementDeclaration head, XSComplexTypeDefinition propTypeDef, XSParticle xsParticle, boolean includeHead) {
        if (null != head) {
            XSElementDeclaration elemDecl = (XSElementDeclaration)xsParticle.getTerm();
            List<XSElementDeclaration> elementsByAffiliation = XMLSchemaModelUtils.getElementsByAffiliation(model, head);
            if (includeHead) {
                elementsByAffiliation.add(head);
            }
            Assert.assertTrue((boolean)elementsByAffiliation.contains(elemDecl), (String)ErrorMessage.format("DisallowedSubstitution", elemDecl, head, XMLSchemaModelUtils.getQName((XSObject)propTypeDef)));
        }
    }
}

